
package fr.ifremer.tutti.ui.swing;

/*
 * #%L
 * Tutti :: UI
 * $Id: AbstractChangeScreenAction.java 349 2013-02-06 10:54:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-1.0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/AbstractChangeScreenAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.event.ActionEvent;

/**
 * Abstract action defining actions which sets the screen of the application.
 *
 * @author kmorin <kmorin@codelutin.com>
 * @since 1.0
 */
public abstract class AbstractChangeScreenAction extends AbstractTuttiAction<TuttiUIContext, MainUI, MainUIHandler> {

    private static final long serialVersionUID = 1L;

    protected AbstractChangeScreenAction(MainUIHandler handler,
                                         String name,
                                         String icon,
                                         String text,
                                         String tip,
                                         boolean hideBody) {
        super(handler, name, icon, text, tip, hideBody);
    }

    @Override
    protected boolean prepareAction(ActionEvent event) {
        boolean result = super.prepareAction(event);
        result &= getHandler().getCurrentHandler().canCloseUI(getNextScreen());
        return result;
    }

    /** @return the next screen to display. */
    protected abstract TuttiScreen getNextScreen();

}
