/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TabHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import javax.swing.JTabbedPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCatchesUIHandler
extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel>
implements TabHandler {
    private static final Log log = LogFactory.getLog(EditCatchesUIHandler.class);
    private final EditCatchesUI ui;
    private final PersistenceService persistenceService;
    private final TuttiBeanMonitor<EditCatchesUIModel> fishingOperationMonitor;

    public EditCatchesUIHandler(FishingOperationsUI parentUi, EditCatchesUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
        this.persistenceService = this.context.getService(PersistenceService.class);
        this.fishingOperationMonitor = new TuttiBeanMonitor("speciesTotalWeight", "speciesTotalUnsortedWeight", "speciesTotalSortedWeight", "speciesTotalSampleSortedWeight", "benthosTotalWeight", "benthosTotalSampleSortedWeight", "planktonTotalWeight", "planktonTotalSampleWeight", "macroWasteTotalWeight");
    }

    @Override
    public void beforeInitUI() {
        EditCatchesUIModel model = this.ui.getContextValue(EditCatchesUIModel.class);
        this.listModelIsModify(model);
        this.fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        EditCatchesUIModel model = this.getModel();
        this.listenValidatorValid((SimpleBeanValidator)this.ui.getValidator(), model);
        this.setCustomTab(0, model);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
        this.closeUI(this.ui.getSpeciesTabContent());
        this.closeUI(this.ui.getBenthosTabContent());
        this.closeUI(this.ui.getPlanktonTabContent());
        this.closeUI(this.ui.getMacroWasteTabContent());
        this.closeUI(this.ui.getAccidentalTabContent());
    }

    @Override
    protected EditCatchesUIModel getModel() {
        return this.ui.getModel();
    }

    @Override
    protected JTabbedPane getTabPanel() {
        return this.ui.getTabPane();
    }

    @Override
    public boolean onHideTab() {
        EditCatchesUIModel model = this.getModel();
        boolean result = model.isValid();
        if (result && model.isModify()) {
            this.save();
        }
        return result;
    }

    @Override
    public void onShowTab() {
    }

    public void selectFishingOperation(FishingOperation bean, String fishingOperationText) {
        if (this.fishingOperationMonitor.wasModified()) {
            this.save();
        }
        this.ui.getSpeciesTabContent().getHandler().clearTableSelection();
        this.ui.getBenthosTabContent().getHandler().clearTableSelection();
        this.ui.getPlanktonTabContent().getHandler().clearTableSelection();
        this.ui.getMacroWasteTabContent().getHandler().clearTableSelection();
        this.ui.getAccidentalTabContent().getHandler().clearTableSelection();
        boolean empty = bean == null;
        EditCatchesUIModel model = this.getModel();
        if (empty) {
            bean = new FishingOperation();
            model.setFishingOperation(null);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId() + " - " + fishingOperationText));
            }
            model.setFishingOperation(bean);
        }
        model.fromBean(bean);
        model.setModify(false);
        this.fishingOperationMonitor.clearModified();
        this.ui.getCatchesCaracteristicsTabPane().setTitle(fishingOperationText);
        this.ui.getSpeciesTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        this.ui.getBenthosTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        this.ui.getPlanktonTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        this.ui.getMacroWasteTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        this.ui.getAccidentalTabFishingOperationReminderLabel().setTitle(fishingOperationText);
        this.ui.getSpeciesTabContent().getHandler().selectFishingOperation(bean);
        this.ui.getBenthosTabContent().getHandler().selectFishingOperation(bean);
        this.ui.getPlanktonTabContent().getHandler().selectFishingOperation(bean);
        this.ui.getMacroWasteTabContent().getHandler().selectFishingOperation(bean);
        this.ui.getAccidentalTabContent().getHandler().selectFishingOperation(bean);
        this.ui.getTabPane().repaint();
    }

    protected void save() {
        EditCatchesUIModel beanToSave = this.fishingOperationMonitor.getBean();
        FishingOperation fishingOperation = (FishingOperation)beanToSave.toBean();
        if (log.isInfoEnabled()) {
            log.info((Object)("FishingOperation " + fishingOperation.getId() + " was modified, will save it."));
        }
        this.showInformationMessage("[ Captures - Caract\u00e9ristiques g\u00e9n\u00e9rales ] Sauvegarde des modifications de " + this.decorate(fishingOperation) + ".");
        this.persistenceService.saveFishingOperation(fishingOperation);
    }

    public void importPupitri() {
    }
}

