/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.plankton;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.IdAware;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.PlanktonBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.operation.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.plankton.PlanktonBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.plankton.PlanktonBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.plankton.PlanktonBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.plankton.PlanktonBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentCellComponent;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextCellComponent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.nuiton.i18n.I18n;
import org.nuiton.util.decorator.Decorator;

public class PlanktonBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<PlanktonBatchRowModel, PlanktonBatchUIModel> {
    private static final Log log = LogFactory.getLog(PlanktonBatchUIHandler.class);
    private final PlanktonBatchUI ui;

    public PlanktonBatchUIHandler(FishingOperationsUI parentUi, PlanktonBatchUI ui) {
        super(parentUi, new String[]{"totalWeight", "sampleTotalWeight"}, "speciesToConfirm", "species", "weight", "comment");
        this.ui = ui;
    }

    @Override
    protected PlanktonBatchUIModel getModel() {
        return this.ui.getModel();
    }

    protected PlanktonBatchTableModel getTableModel() {
        return (PlanktonBatchTableModel)this.getTable().getModel();
    }

    @Override
    protected JXTable getTable() {
        return this.ui.getTable();
    }

    @Override
    protected FishingOperation getFishingOperation() {
        return this.getModel().getFishingOperation();
    }

    @Override
    protected String[] getRowPropertiesToIgnore() {
        return new String[]{"sampleWeight", "samplingRatio"};
    }

    @Override
    protected TableColumnModel createTableColumnModel() {
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addBooleanColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SPECIES_TO_CONFIRM, (JTable)this.getTable());
        List allSpecies = this.persistenceService.getAllSpecies();
        Decorator<Species> decorator = this.getDecorator(Species.class, "byCode");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SPECIES_BY_CODE, decorator, allSpecies);
        decorator = this.getDecorator(Species.class, "byGenus");
        this.addComboDataColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SPECIES_BY_GENUS_CODE, decorator, allSpecies);
        this.addFloatColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.WEIGHT, "\\d{0,6}|\\d{1,6}.\\d{0,3}");
        this.addColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SAMPLE_WEIGHT);
        this.addColumnToModel((TableColumnModel)columnModel, PlanktonBatchTableModel.SAMPLING_RATIO);
        this.addColumnToModel((TableColumnModel)columnModel, LongTextCellComponent.newEditor(this.ui.getLongTextEditor()), LongTextCellComponent.newRender(I18n.n_((String)"tutti.tooltip.comment.none", (Object[])new Object[0])), PlanktonBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellComponent.newEditor(this.ui.getAttachmentEditor()), AttachmentCellComponent.newRender(this.getDecorator(Attachment.class, null), I18n.n_((String)"tutti.tooltip.attachment.none", (Object[])new Object[0])), PlanktonBatchTableModel.ATTACHMENTS);
        return columnModel;
    }

    @Override
    protected void onRowModified(PlanktonBatchRowModel row, String propertyName, Object oldValue, Object newValue) {
        boolean wasValid = row.isValid();
        boolean valid = this.isRowValid(row);
        if (log.isInfoEnabled()) {
            log.info((Object)("Was valid / Is valid: " + wasValid + " / " + valid));
        }
        row.setValid(valid);
    }

    @Override
    protected void onRowValidStateChanged(PlanktonBatchRowModel row, Boolean oldValue, Boolean newValue) {
        int rowIndex = this.getTableModel().getRowIndex(row);
        if (rowIndex > -1) {
            this.getTableModel().fireTableRowsUpdated(rowIndex, rowIndex);
        }
    }

    @Override
    protected void onRowModifyStateChanged(PlanktonBatchRowModel row, Boolean oldValue, Boolean newValue) {
    }

    @Override
    protected void onModelRowsChanged(List<PlanktonBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        for (PlanktonBatchRowModel row : rows) {
            boolean valid = this.isRowValid(row);
            row.setValid(valid);
        }
    }

    @Override
    protected void saveSelectedRowIfRequired() {
        TuttiBeanMonitor rowMonitor = this.getRowMonitor();
        PlanktonBatchRowModel bean = (PlanktonBatchRowModel)((Object)rowMonitor.getBean());
        if (bean != null) {
            if (bean.isValid()) {
                if (rowMonitor.wasModified()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Row " + (Object)((Object)bean) + " was modified, will save it"));
                    }
                    this.saveRow(bean);
                    rowMonitor.clearModified();
                }
            } else {
                PlanktonBatch catchBean = (PlanktonBatch)bean.toBean();
                if (!TuttiEntities.isNew((IdAware)catchBean)) {
                    this.persistenceService.deletePlanktonBatch(catchBean.getId());
                }
            }
        }
    }

    @Override
    protected boolean isRowValid(PlanktonBatchRowModel row) {
        boolean result = row.getSpecies() != null && row.getWeight() != null;
        return result;
    }

    @Override
    protected void saveRow(PlanktonBatchRowModel row) {
        PlanktonBatch catchBean = (PlanktonBatch)row.toBean();
        FishingOperation fishingOperation = this.getModel().getFishingOperation();
        catchBean.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew((IdAware)catchBean)) {
            catchBean = this.persistenceService.createPlanktonBatch(catchBean);
            row.setId(catchBean.getId());
        } else {
            this.persistenceService.savePlanktonBatch(catchBean);
        }
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        String fishingoperationText;
        ArrayList rows;
        JXTable table = this.getTable();
        if (table.isEditing()) {
            table.editingCanceled(null);
        }
        if (this.fishingOperationMonitor.wasModified()) {
            PlanktonBatchUIModel beanToSave = (PlanktonBatchUIModel)((Object)this.fishingOperationMonitor.getBean());
            FishingOperation fishingOperation = (FishingOperation)beanToSave.toBean();
            if (log.isInfoEnabled()) {
                log.info((Object)("FishingOperation " + fishingOperation.getId() + " was modified, will save it."));
            }
            this.persistenceService.saveFishingOperation(fishingOperation);
        }
        table.clearSelection();
        boolean empty = bean == null;
        PlanktonBatchUIModel model = this.getModel();
        if (empty) {
            rows = null;
            bean = new FishingOperation();
            model.setFishingOperation(null);
            fishingoperationText = "";
        } else {
            Decorator<FishingOperation> decorator = this.getDecorator(FishingOperation.class, null);
            fishingoperationText = I18n._((String)"tutti.label.traitReminder", (Object[])new Object[]{decorator.toString((Object)bean)});
            if (log.isInfoEnabled()) {
                log.info((Object)("Get species batch for fishingOperation: " + bean.getId() + " - " + fishingoperationText));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew((IdAware)bean)) {
                List catches = this.persistenceService.getAllPlanktonBatch(bean.getId());
                for (PlanktonBatch aBatch : catches) {
                    PlanktonBatchRowModel entry = new PlanktonBatchRowModel(aBatch);
                    rows.add(entry);
                }
            }
            model.setFishingOperation(bean);
        }
        model.fromBean(bean);
        model.setRows(rows);
        this.fishingOperationMonitor.clearModified();
        this.ui.getFishingOperationReminderLabel().setText(fishingoperationText);
    }

    @Override
    public void beforeInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("beforeInit: " + this.ui));
        }
        PlanktonBatchUIModel model = new PlanktonBatchUIModel();
        this.ui.setContextValue(model);
        this.fishingOperationMonitor.setBean(model);
    }

    @Override
    public void afterInitUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("afterInit: " + this.ui));
        }
        this.initUI(this.ui);
        JXTable table = this.getTable();
        TableColumnModel columnModel = this.createTableColumnModel();
        PlanktonBatchTableModel tableModel = new PlanktonBatchTableModel(columnModel);
        table.setModel((TableModel)tableModel);
        table.setColumnModel(columnModel);
        this.initBatchTable(table, columnModel, tableModel);
    }

    @Override
    public void onCloseUI() {
        if (log.isInfoEnabled()) {
            log.info((Object)("closing: " + this.ui));
        }
    }
}

