/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.config;

import com.google.common.base.Throwables;
import fr.ifremer.tutti.service.TuttiServiceTechnicalException;
import fr.ifremer.tutti.service.config.TuttiServiceConfig;
import fr.ifremer.tutti.ui.swing.config.TuttiConfigOption;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.util.ArgumentsParserException;
import org.nuiton.util.Version;

public class TuttiConfig {
    private static final Log log = LogFactory.getLog(TuttiConfig.class);
    protected final ApplicationConfig applicationConfig = new ApplicationConfig();
    protected final TuttiServiceConfig serviceConfig;

    public TuttiConfig(String file, String ... args) {
        this.applicationConfig.setConfigFileName(file);
        log.info((Object)(this + " is initializing..."));
        this.applicationConfig.loadDefaultOptions((ApplicationConfig.OptionDef[])TuttiConfigOption.values());
        this.serviceConfig = new TuttiServiceConfig(this.applicationConfig);
        try {
            this.applicationConfig.parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new TuttiServiceTechnicalException("Could not parse configuration", (Throwable)e);
        }
        try {
            this.serviceConfig.prepareDirectories();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public TuttiServiceConfig getServiceConfig() {
        return this.serviceConfig;
    }

    public void save() {
        this.applicationConfig.saveForUser(new String[0]);
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    public File getUIConfigFile() {
        return this.applicationConfig.getOptionAsFile(TuttiConfigOption.UI_CONFIG_FILE.getKey());
    }

    public boolean isAutoPopupNumberEditor() {
        return this.applicationConfig.getOptionAsBoolean(TuttiConfigOption.AUTO_POPUP_NUMBER_EDITOR.getKey());
    }

    public boolean isShowNumberEditorButton() {
        return this.applicationConfig.getOptionAsBoolean(TuttiConfigOption.SHOW_NUMBER_EDITOR_BUTTON.getKey());
    }

    public String getProgramId() {
        return this.applicationConfig.getOption(TuttiConfigOption.PROGRAM_ID.getKey());
    }

    public String getCruiseId() {
        return this.applicationConfig.getOption(TuttiConfigOption.CRUISE_ID.getKey());
    }

    public KeyStroke getShortCut(String actionName) {
        KeyStroke result = this.applicationConfig.getOptionAsKeyStroke("tutti.ui." + actionName);
        return result;
    }

    public Version getVersion() {
        return this.serviceConfig.getVersion();
    }

    public int getInceptionYear() {
        return this.serviceConfig.getInceptionYear();
    }

    public URL getSiteUrl() {
        return this.serviceConfig.getSiteUrl();
    }

    public String getOrganizationName() {
        return this.serviceConfig.getOrganizationName();
    }

    public File getTmpDirectory() {
        return this.serviceConfig.getTmpDirectory();
    }

    public File getDataDirectory() {
        return this.serviceConfig.getDataDirectory();
    }

    public void setProgramId(String programId) {
        if (programId == null) {
            Properties options = this.applicationConfig.getOptions();
            options.remove(TuttiConfigOption.PROGRAM_ID.getKey());
            this.applicationConfig.setOptions(options);
        } else {
            this.applicationConfig.setOption(TuttiConfigOption.PROGRAM_ID.getKey(), programId);
        }
    }

    public void setCruiseId(String cruiseId) {
        if (cruiseId == null) {
            Properties options = this.applicationConfig.getOptions();
            options.remove(TuttiConfigOption.CRUISE_ID.getKey());
            this.applicationConfig.setOptions(options);
        } else {
            this.applicationConfig.setOption(TuttiConfigOption.CRUISE_ID.getKey(), cruiseId);
        }
    }
}

