package fr.ifremer.tutti.ui.swing.content.operation.species;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.util.editor.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.editor.LongTextEditorUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesBatchUI extends JPanel implements TuttiUI<SpeciesBatchUIModel, SpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_SAMPLE_VRAC_WEIGHT_FIELD_MODEL = "sampleVracWeightField.model";
    public static final String BINDING_SAMPLE_VRAC_WEIGHT_FIELD_NUMBER_PATTERN = "sampleVracWeightField.numberPattern";
    public static final String BINDING_TOTAL_HORS_VRAC_WEIGHT_FIELD_TEXT = "totalHorsVracWeightField.text";
    public static final String BINDING_TOTAL_VRAC_WEIGHT_FIELD_MODEL = "totalVracWeightField.model";
    public static final String BINDING_TOTAL_VRAC_WEIGHT_FIELD_NUMBER_PATTERN = "totalVracWeightField.numberPattern";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_MODEL = "totalWeightField.model";
    public static final String BINDING_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "totalWeightField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1XzU8bRxQfXAyYj0BC49AG1HzQFFppTS9RJaIm4GAwNQaxToLCgY7tsb1kvLOZmQ1GFlX/hP4J7b2XSr310qiHnnvopeq/UFU59Fr1zay96zXrmo8gMaCZ937vze/NvN/s93+huODo9iFuNAzu2tKqE2NzZW9vu3hISvIxESVuOZJx5P0MxFBsH42V/Xkh0d39nHJPtdxTaVZ3mE3sDu/lHBoV8pgSUSNESjQX9igJkTL95eWG4/I2qp9UFOq3b/6OfVP++rsYQg0HskvCVm718wp2MphDMass0TWI9AqnKLarkAa37CrkO6Hm0hQLkcd18hJ9hYZzaMjBHMAkunP2LWsM7d9wJErUWJ3sYJtQiVYr3LAqnNQJN6QrpWW4liGOIL5RYrYEOIM5hGNpMdsQDilZRBim93cVy1LtSdZxNPSQRMM1bJcp4RJlLw+74WEF6PE6K6uU1y+PvaWQAuRJwjnjBVykZMuL8SBUwVeYWmUMhLbCmGp82p7cIkLgKgncA+CE7ynRJ+eA7EgNNvrSJXbpeK1saZzMJbafaYM9ySr8hB/mCmV2tUAash3lfu8orrSoQbSdkQu5daNOYSlxqVaHnNq4n50Nd6XLsRt5ZH5TH+AluDnqkjRaGN5s2HauYokaLG63WdkldcsuE57DRVXrMICeVJ63fYDx+U2TwK1TlYGAyZC9vxL2GawwXpdoJlR0z0UflLD1lGQS02fEqtakn8A9NXwcaZOxCIWmcS8CvUVg3q0XCffIC+O8q3Geclz6/3jddjqmWvs0bHdd4LpDSX/AU4a9EGd05A1o7P1Bo2xb7ITrpE6pHzDwn5SqGmaJM0rV2ZHoRri8/kr4UMW1n0Q3Ga8ah6BFLyRzPKeGsbnn1/ihA3pwM1QnUBojUJpACgb2UZy7MA272j8tTruw5MnSTJcsKUC9+m9y+vef/vwx09aicYh9PdK0Q0pBIxyuOoa0VOhJT4jUZUxtYWd5HyUEoaDDWmdnIxIzW8uQHMS7qty9u7yBRQ0g4sN/vP4l+eVv76BYBo1ShssZrOyzKCFrHFhgtNxwHj7SGY0fjcA4Bb+DcImKBNsgK03d+U+gn2JXsh3muKBiqWZLbYwqkWlmV6zqwqJhiZW2SecVWFhU3hDqaJcIpf6DkrtA/qSa0tar0IygfaKlHrAmGHYievaA24CKzEZUxKelmPj1n2nzh0ftqgwAS+/1NA8qE3+OhiybWjbRb4SW/Ee+CcYcQdwyC2Q+SvgRkDbeuYWWymzqMX+qADFos1Rdu4xq3Nea3f3nRLEIt0qiD7xOro19yekwb7gqwp7eu/rvOYpoeU6fdAaDF8CMdyBUhQoBiq7xhK03uAPKQziUM9nM5gsH9w8eZ9ezBfNgZ6VQWNvNg+GIK0gGDiOkH69gCocCjbTuwbFEY+fIXpPRL/swmclmVHMNCL3bk9DAJSqtyN5+DmJnu4gNkN4muZMX2MkFSL7RjBScgOX5KJa7faKSi5a8c/A8F/BsdkG9TaKnLrSZC1D9frOXDAdsf9TzTIfdonLs+SI4Q5qt8EtNRbb+soJntksWwic9jL2wqKowot5Snsx75J41tTMxCMdhwlNWeJKq7waJPmzmLCHNzklqmNn8em7twFzLraUL2W1ddQGkdyYm0bQPBQUhVc5cG55AE800o/AaXM2tpL846bRaxaUXbauhpu1SehK1O++Z028rA4BB8TGDAqMrD+ALBt8qwgsbqP78FOiAGkf7Iqrpn9XwOhrhDiD8B2aLkZw5EAAA";
    private static final Log log = LogFactory.getLog(SpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected AttachmentEditorUI attachmentEditor;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JLabel fishingOperationReminderLabel;
    protected Table form;
    protected SpeciesFrequencyUI frequencyEditor;
    protected SpeciesBatchUIHandler handler;
    protected SpeciesBatchUI homePanel = this;
    protected LongTextEditorUI longTextEditor;
    protected SpeciesBatchUIModel model;
    @ValidatorField( validatorId = "validator",  propertyName = "sampleVracWeight",  editorName = "sampleVracWeightField")
    protected NumberEditor sampleVracWeightField;
    protected JLabel sampleVracWeightLabel;
    protected JXTable table;
    protected JScrollPane tableScrollPane;
    @ValidatorField( validatorId = "validator",  propertyName = "totalHorsVracWeight",  editorName = "totalHorsVracWeightField")
    protected JTextField totalHorsVracWeightField;
    protected JLabel totalHorsVracWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "totalVracWeight",  editorName = "totalVracWeightField")
    protected NumberEditor totalVracWeightField;
    protected JLabel totalVracWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "totalWeight",  editorName = "totalWeightField")
    protected NumberEditor totalWeightField;
    protected JLabel totalWeightLabel;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void selectFishingOperation(FishingOperation fishingOperation) { handler.selectFishingOperation(fishingOperation); }
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesBatchUI(FishingOperationsUI parentUI) {
        SpeciesBatchUIHandler handler = new SpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI() {
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doFocusLost__on__table(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.saveSelectedRowIfRequired(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI getAttachmentEditor() {
        return attachmentEditor;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JLabel getFishingOperationReminderLabel() {
        return fishingOperationReminderLabel;
    }

    public Table getForm() {
        return form;
    }

    public SpeciesFrequencyUI getFrequencyEditor() {
        return frequencyEditor;
    }

    public SpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public LongTextEditorUI getLongTextEditor() {
        return longTextEditor;
    }

    public SpeciesBatchUIModel getModel() {
        return model;
    }

    public NumberEditor getSampleVracWeightField() {
        return sampleVracWeightField;
    }

    public JLabel getSampleVracWeightLabel() {
        return sampleVracWeightLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public JTextField getTotalHorsVracWeightField() {
        return totalHorsVracWeightField;
    }

    public JLabel getTotalHorsVracWeightLabel() {
        return totalHorsVracWeightLabel;
    }

    public NumberEditor getTotalVracWeightField() {
        return totalVracWeightField;
    }

    public JLabel getTotalVracWeightLabel() {
        return totalVracWeightLabel;
    }

    public NumberEditor getTotalWeightField() {
        return totalWeightField;
    }

    public JLabel getTotalWeightLabel() {
        return totalWeightLabel;
    }

    public SwingValidator<SpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToForm() {
        if (!allComponentsCreated) {
            return;
        }
        form.add(totalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(totalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(totalVracWeightLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(totalVracWeightField), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(sampleVracWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(sampleVracWeightField), new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(totalHorsVracWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        form.add(SwingUtil.boxComponentWithJxLayer(totalHorsVracWeightField), new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(frequencyEditor);
        add(longTextEditor);
        add(attachmentEditor);
        add($JPanel0, BorderLayout.NORTH);
        add(tableScrollPane, BorderLayout.CENTER);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAttachmentEditor() {
        $objectMap.put("attachmentEditor", attachmentEditor = new AttachmentEditorUI());
        
        attachmentEditor.setName("attachmentEditor");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createFishingOperationReminderLabel() {
        $objectMap.put("fishingOperationReminderLabel", fishingOperationReminderLabel = new JLabel());
        
        fishingOperationReminderLabel.setName("fishingOperationReminderLabel");
    }

    protected void createForm() {
        $objectMap.put("form", form = new Table());
        
        form.setName("form");
    }

    protected void createFrequencyEditor() {
        $objectMap.put("frequencyEditor", frequencyEditor = new SpeciesFrequencyUI(handler.getContext()));
        
        frequencyEditor.setName("frequencyEditor");
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesBatchUIHandler.class));
    }

    protected void createLongTextEditor() {
        $objectMap.put("longTextEditor", longTextEditor = new LongTextEditorUI());
        
        longTextEditor.setName("longTextEditor");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesBatchUIModel.class));
    }

    protected void createSampleVracWeightField() {
        $objectMap.put("sampleVracWeightField", sampleVracWeightField = new NumberEditor(this));
        
        sampleVracWeightField.setName("sampleVracWeightField");
        sampleVracWeightField.setProperty("sampleVracWeight");
        sampleVracWeightField.setUseFloat(false);
        sampleVracWeightField.setShowReset(true);
    }

    protected void createSampleVracWeightLabel() {
        $objectMap.put("sampleVracWeightLabel", sampleVracWeightLabel = new JLabel());
        
        sampleVracWeightLabel.setName("sampleVracWeightLabel");
        sampleVracWeightLabel.setText(_("tutti.label.species.sampleVracWeight"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
        table.addFocusListener(JAXXUtil.getEventListener(FocusListener.class, "focusLost", this, "doFocusLost__on__table"));
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createTotalHorsVracWeightField() {
        $objectMap.put("totalHorsVracWeightField", totalHorsVracWeightField = new JTextField());
        
        totalHorsVracWeightField.setName("totalHorsVracWeightField");
        totalHorsVracWeightField.setColumns(15);
        totalHorsVracWeightField.setEditable(false);
    }

    protected void createTotalHorsVracWeightLabel() {
        $objectMap.put("totalHorsVracWeightLabel", totalHorsVracWeightLabel = new JLabel());
        
        totalHorsVracWeightLabel.setName("totalHorsVracWeightLabel");
        totalHorsVracWeightLabel.setText(_("tutti.label.species.totalHorsVracWeight"));
    }

    protected void createTotalVracWeightField() {
        $objectMap.put("totalVracWeightField", totalVracWeightField = new NumberEditor(this));
        
        totalVracWeightField.setName("totalVracWeightField");
        totalVracWeightField.setProperty("totalVracWeight");
        totalVracWeightField.setUseFloat(false);
        totalVracWeightField.setShowReset(true);
    }

    protected void createTotalVracWeightLabel() {
        $objectMap.put("totalVracWeightLabel", totalVracWeightLabel = new JLabel());
        
        totalVracWeightLabel.setName("totalVracWeightLabel");
        totalVracWeightLabel.setText(_("tutti.label.species.totalVracWeight"));
    }

    protected void createTotalWeightField() {
        $objectMap.put("totalWeightField", totalWeightField = new NumberEditor(this));
        
        totalWeightField.setName("totalWeightField");
        totalWeightField.setProperty("totalWeight");
        totalWeightField.setUseFloat(false);
        totalWeightField.setShowReset(true);
    }

    protected void createTotalWeightLabel() {
        $objectMap.put("totalWeightLabel", totalWeightLabel = new JLabel());
        
        totalWeightLabel.setName("totalWeightLabel");
        totalWeightLabel.setText(_("tutti.label.species.totalWeight"));
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        // inline complete setup of $JPanel0
        $JPanel0.add(fishingOperationReminderLabel, BorderLayout.NORTH);
        $JPanel0.add($JSeparator0, BorderLayout.CENTER);
        $JPanel0.add(form, BorderLayout.SOUTH);
        addChildrenToForm();
        addChildrenToTableScrollPane();
        
        // apply 7 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        totalWeightLabel.setLabelFor(totalWeightField);
        totalWeightField.setBean(model);
        totalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        totalVracWeightLabel.setLabelFor(totalVracWeightField);
        totalVracWeightField.setBean(model);
        totalVracWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        totalVracWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        sampleVracWeightLabel.setLabelFor(sampleVracWeightField);
        sampleVracWeightField.setBean(model);
        sampleVracWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        sampleVracWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        totalHorsVracWeightLabel.setLabelFor(totalHorsVracWeightField);
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createFrequencyEditor();
        createLongTextEditor();
        createAttachmentEditor();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createFishingOperationReminderLabel();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createForm();
        createTotalWeightLabel();
        createTotalWeightField();
        createTotalVracWeightLabel();
        createTotalVracWeightField();
        createSampleVracWeightLabel();
        createSampleVracWeightField();
        createTotalHorsVracWeightLabel();
        createTotalHorsVracWeightField();
        createTableScrollPane();
        createTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 7 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 7 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalWeightField.setModel(model.getTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                totalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_VRAC_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalVracWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    totalVracWeightField.setModel(model.getTotalVracWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalVracWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_TOTAL_VRAC_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                totalVracWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAMPLE_VRAC_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("sampleVracWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    sampleVracWeightField.setModel(model.getSampleVracWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("sampleVracWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SAMPLE_VRAC_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                sampleVracWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TOTAL_HORS_VRAC_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("totalHorsVracWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(totalHorsVracWeightField, getStringValue(model.getTotalHorsVracWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("totalHorsVracWeight", this);
                }
            }
        });
    }

}