package fr.ifremer.tutti.ui.swing.content.operation.plankton;

/*
 * #%L
 * Tutti :: UI
 * $Id: PlanktonBatchUIModel.java 55 2012-12-13 01:57:28Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/plankton/PlanktonBatchUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIModel;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderModelBuilder;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class PlanktonBatchUIModel extends AbstractTuttiTableUIModel<FishingOperation, PlanktonBatchRowModel, PlanktonBatchUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_TOTAL_WEIGHT = "totalWeight";

    public static final String PROPERTY_SAMPLE_TOTAL_WEIGHT = "sampleTotalWeight";

    /**
     * Editing fishing operation.
     *
     * @since 0.2
     */
    protected FishingOperation fishingOperation;

    /**
     * Total Weight filled in screen.
     *
     * @since 0.2
     */
    protected Float totalWeight;

    /**
     * Total Sample Weight filled in screen.
     *
     * @since 0.2
     */
    protected Float sampleTotalWeight;

    protected static final Binder<FishingOperation, PlanktonBatchUIModel> fromBeanBinder = BinderModelBuilder.newEmptyBuilder(FishingOperation.class, PlanktonBatchUIModel.class)
            .addProperty(FishingOperation.PROPERTY_PLANKTON_TOTAL_WEIGHT, PROPERTY_TOTAL_WEIGHT)
            .addProperty(FishingOperation.PROPERTY_PLANKTON_SAMPLE_TOTAL_WEIGHT, PROPERTY_SAMPLE_TOTAL_WEIGHT)
            .addProperty(FishingOperation.PROPERTY_ID, PROPERTY_ID)
            .toBinder();

    protected static final Binder<PlanktonBatchUIModel, FishingOperation> toBeanBinder = BinderModelBuilder.newEmptyBuilder(PlanktonBatchUIModel.class, FishingOperation.class)
            .addProperty(PROPERTY_TOTAL_WEIGHT, FishingOperation.PROPERTY_PLANKTON_TOTAL_WEIGHT)
            .addProperty(PROPERTY_SAMPLE_TOTAL_WEIGHT, FishingOperation.PROPERTY_PLANKTON_SAMPLE_TOTAL_WEIGHT)
            .toBinder();


    public PlanktonBatchUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
    }

    public Float getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(Float totalWeight) {
        Object oldValue = getTotalWeight();
        this.totalWeight = totalWeight;
        firePropertyChange(PROPERTY_TOTAL_WEIGHT, oldValue, totalWeight);
    }

    public Float getSampleTotalWeight() {
        return sampleTotalWeight;
    }

    public void setSampleTotalWeight(Float sampleTotalWeight) {
        Object oldValue = getSampleTotalWeight();
        this.sampleTotalWeight = sampleTotalWeight;
        firePropertyChange(PROPERTY_SAMPLE_TOTAL_WEIGHT, oldValue, sampleTotalWeight);
    }

    @Override
    protected FishingOperation newEntity() {
        return fishingOperation;
    }
}