package fr.ifremer.tutti.ui.swing.util.editor;

/*
 * #%L
 * Tutti :: UI
 * $Id: AttachmentEditorUIHandler.java 132 2012-12-30 19:39:00Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/util/editor/AttachmentEditorUIHandler.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.HBox;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;

/**
 * Handler of the LongTextEditorUI
 *
 * @author kmorin
 * @since 0.2
 */
public class AttachmentEditorUIHandler {

    private static final Log log = LogFactory.getLog(AttachmentEditorUIHandler.class);

    private final AttachmentEditorUI ui;

    public AttachmentEditorUIHandler(AttachmentEditorUI attachmentEditorUI) {
        ui = attachmentEditorUI;

        ui.addPropertyChangeListener(new PropertyChangeListener() {

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                init();
            }
        });
    }

    public void init() {
        resetFields();
        ui.getAttachments().removeAll();
        AbstractTuttiBeanUIModel bean = ui.getBean();
        String property = ui.getProperty();
        if (bean != null && !StringUtils.isEmpty(property)) {
            List<Attachment> list = (List<Attachment>) TuttiUIUtil.getProperty(bean, property);
            if (list != null) {
                for (Attachment attachment : list) {
                    addAttachment(attachment);
                }
            }
        }
    }

    protected void addAttachment(final Attachment attachment) {
        final HBox hbox = new HBox();
        hbox.setVerticalAlignment(SwingConstants.CENTER);

        JButton deleteButton = new JButton(SwingUtil.createActionIcon("delete"));
        deleteButton.addActionListener(new ActionListener() {

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractTuttiBeanUIModel bean = ui.getBean();
                String property = ui.getProperty();
                List<Attachment> list = (List<Attachment>) TuttiUIUtil.getProperty(bean, property);
                if (list != null) {
                    list.remove(attachment);
                    TuttiUIUtil.setProperty(bean, property, list);
                }

                ui.getAttachments().remove(hbox);

                JDialog parent = SwingUtil.getParentContainer(ui, JDialog.class);
                parent.pack();
            }
        });
        hbox.add(deleteButton);

        final JLabel label = new JLabel("<html><body><a href=''>"
                                        + attachment.getName() + "</a></body></html>");
        label.setToolTipText(attachment.getComment());
        label.addMouseListener(new MouseAdapter() {

            @Override
            public void mouseClicked(MouseEvent e) {
                SwingUtil.openLink("file://" + attachment.getFile().getAbsolutePath());
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                label.setCursor(Cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                label.setCursor(Cursor.getDefaultCursor());
            }

        });
        hbox.add(label);

        ui.getAttachments().add(hbox);
    }

    /** closes the editor */
    public void close() {
        if (log.isInfoEnabled()) {
            log.info("Will close UI " + ui);
        }
        SwingUtil.getParentContainer(ui, Window.class).dispose();
    }

//    public void chooseFile() {
//        if (fileChooser.showOpenDialog(ui) == JFileChooser.APPROVE_OPTION) {
//            File file = fileChooser.getSelectedFile();
//            getModel().setFile(file);
//            ui.getFile().setText(file.getAbsolutePath());
//        }
//    }

    public void addAttachment() {
        AbstractTuttiBeanUIModel bean = ui.getBean();
        String property = ui.getProperty();
        List<Attachment> list = (List<Attachment>) TuttiUIUtil.getProperty(bean, property);
        if (list == null) {
            list = Lists.newArrayList();
        }
        Attachment attachment = new Attachment();
        File file = ui.getFile().getSelectedFile();
        if (file != null) {
            attachment.setFile(file);
            String name = ui.getFileName().getText();
            if (StringUtils.isEmpty(name)) {
                name = file.getName();
            }
            attachment.setName(name);
            attachment.setComment(ui.getFileComment().getText());
            list.add(attachment);
            TuttiUIUtil.setProperty(bean, property, list);

            resetFields();
            addAttachment(attachment);

            JDialog parent = SwingUtil.getParentContainer(ui, JDialog.class);
            parent.pack();
        }
    }

    protected void resetFields() {
        ui.getFile().setSelectedFile((File) null);
        ui.getFileName().setText("");
        ui.getFileComment().setText("");
    }

}
