package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id: CreateSpeciesBatchUIHandler.java 137 2013-01-01 23:04:02Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/species/split/CreateSpeciesBatchUIHandler.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.Cancelable;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableRenderer;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;

/**
 * Handler of {@link CreateSpeciesBatchUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class CreateSpeciesBatchUIHandler extends AbstractTuttiUIHandler<CreateSpeciesBatchUIModel> implements Cancelable {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(CreateSpeciesBatchUIHandler.class);

    /**
     * UI.
     *
     * @since 0.3
     */
    private final CreateSpeciesBatchUI ui;

    public CreateSpeciesBatchUIHandler(SpeciesBatchUI parentUi, CreateSpeciesBatchUI ui) {
        super(parentUi.getHandler().getContext());
        this.ui = ui;
    }

    //------------------------------------------------------------------------//
    //-- AbstractTuttiUIHandler methods                                     --//
    //------------------------------------------------------------------------//

    @Override
    public void beforeInitUI() {

        CreateSpeciesBatchUIModel model = new CreateSpeciesBatchUIModel();
        ui.setContextValue(model);
        listModelIsModify(model);
    }

    @Override
    public void afterInitUI() {

        initUI(ui);

        initBeanComboBox(ui.getSpeciesComboBox(),
                         Lists.<Species>newArrayList(),
                         null);

        SwingValidatorUtil.installUI(ui.getErrorTable(),
                                     new SwingValidatorMessageTableRenderer());

        listenValidatorValid(ui.getValidator(), getModel());
    }

    @Override
    public void onCloseUI() {

        if (log.isInfoEnabled()) {
            log.info("closing: " + ui);
        }

    }

    @Override
    protected CreateSpeciesBatchUIModel getModel() {
        return ui.getModel();
    }

    //------------------------------------------------------------------------//
    //-- Cancelable methods                                                 --//
    //------------------------------------------------------------------------//

    @Override
    public void cancel() {

        if (log.isInfoEnabled()) {
            log.info("Cancel UI " + ui);
        }

        // evict model from validator
        ui.getValidator().setBean(null);

        // when canceling always invalid model
        getModel().setValid(false);

        // close dialog
        closeDialog(ui);
    }

    //------------------------------------------------------------------------//
    //-- Public methods                                                     --//
    //------------------------------------------------------------------------//

    public void openUI(SpeciesBatchUIModel batchModel) {

        CreateSpeciesBatchUIModel model = getModel();

        // connect model to validator
        ui.getValidator().setBean(model);

        model.setSpecies(null);
        model.setBatchWeight(null);

        List<Species> speciesToUse = Lists.newArrayList();

        if (batchModel != null) {

            speciesToUse.addAll(batchModel.getAvailableSpecies());
        }

        ui.getSpeciesComboBox().setData(speciesToUse);
    }

    public void save() {

        if (log.isInfoEnabled()) {
            log.info("Save UI " + ui);
        }

        // close dialog
        closeDialog(ui);
    }
}
