package fr.ifremer.tutti.ui.swing.content.operation.catches.species.split;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SampleCategoryType;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class CreateSpeciesBatchUI extends JPanel implements TuttiUI<CreateSpeciesBatchUIModel, CreateSpeciesBatchUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BATCH_WEIGHT_FIELD_MODEL = "batchWeightField.model";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SPECIES_COMBO_BOX_DATA = "speciesComboBox.data";
    public static final String BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM = "speciesComboBox.selectedItem";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVWTW8bRRieOHG+Q5uklKAWqYRSklbatIUDUkup7TrUkfOB1wlVIxTG3kk81Xp3mZ1NHKwifgI/Ae5ckLhxKhw4c+CC+AsIceCKeN+Z9X44mzoVaqQ4zsz7Pu/HvPM8892fJO8L8uYT2ukYInAkbzNjrfDo0WbjCWvKB8xvCu5JVxD9M5QjuV0yZUXrviRv7VbRfSV0Xym5bc91mJPwvlMlk748tpnfYkxK8kbao+n7K2a0fafjBaKHGiWVhfrN33/lvra++jZHSMeD7GahlCuDvOJKRqokxy1J5iDSIV2xqXMAaQjuHEC+M7hWsqnvb9A2+5x8ScaqZNSjAsAkWTx7yQpD+Xc8SSZabpttUYfZkuzsC4PvC9ZmwpCBlNwIuOEfQXyj6ToS4AzXY4JK7jpGk8pmi/mG77EmV39tLo2SYFQyU68V0WS74nkq3KgkYy3qWDYTknz6ckI91PhxxHzbtbC03ZcTbx3R42jnmBCuqNOGzdZ13Lup0z+kNrcoHEYY2sTPnd7iOvN9esBi9xh4IvKU5MYLQCYQVBF40JJcxFHqhA5rZm8DLScihznoyz4/CHRPwglZSMXWACpfdFqIfKfDzlVpA73mUvHUIhpeivsW2sPYNtyi2+kvUnsyi2OdDUYdowgfPes01vkGHs0njB+0ZBTqyuk2q5zZcOeunR5wI2g3mCirf9I441fXVGNu9teoVtO2003qNJldhOGDgSPzKXu9ipbLkcOkTw9ZvGGkd6fbelqiSDfSRzBzdc1sCte20QDyey195tEWmt+KY8YD3F9SdMzvesBql1LtAr40Yr6MCW1ol+RFAMswObsnKbYGW5pcF/rIFQHV7r8X53/78Y8fVnuMeh5iv5ppmhAEYDpP4HWWHEOf03QaSG6vrFPvzi5cBmaDmii1uJyRmBluQ3IQbxbdDXQ3HlK/BRD5sd+f/Xzxs1+HSW6VTNoutVYp2lfIhGwJ6IJrWx3vw/sqo+mjcUwcfoclGcHpBSLsKl56Ch3nt953tgTb5zD15zQ1hckfG3htW+5RjfkoUiNSBKwD3bqc0a0o5cbEL//Mm9/f73VsCCp4/VTzuGv5x2SUOzZ3mFKhUGAyVWfK81lgubGQZEkLAXGZTl7TkIvuqc9iVnMmaCDdLdcLwHWlG2qFccBkSVHR0rLB/ULPJHkrl5afZrQKeQWWlHXv2t08BdYEwySitgfcToDprqlG4reqqitpOqCuEaAblBjuBG4AjHjsBnGCU67goD2KYiW51I3J2Ngp1+qVUqG6Z25VK3Wobw4Eve4GzVa540EN+o6GONMwdPwLphlNkuGbxu2TiSdFwBuQdQ7IzUb2XEXJme32EfRTjMw6EOqaHlllazRPSGRPQ7OySanEoISG0V4NLbMqkrUluaDvEB5kGFGNwQgIH4UXXbxbOKTcxnYlzcZ7lwwu43Ny7FemF+vbXLdfaOLGXR/QuIRnVmInZG5QZvn4MbQQ96YYo+ju9fPTjKNGfYtKyYSDJT0olyrrheqtva1CvV6ubWAzA5+tAg3Gg51o79QLVKJ6dIZRGGMOHqiFo6lr4b569OgidIdndYeBmfFRh2oKdKv/q+CNJCO4lpVSQnrPcOBhuPlUOK32fQFH9WrmZUg+DwYFHQKohissfEl/0C2qb1qBjsNRqnMJ7dE7S3tLizo3iatG+HLwF5ez6K3vaTEolcQbe7bb9/yFo7gANdlabKAL5d6p5fepDURNZvzeFjpI8na3yn1pJhdtw6xsfFQt75nlarlUr2ziwL2CSlFTnKcd3+nqB4pR2K5v7tXKZuUxeGwXzfLH2+WN+l5ps7q9vmGC67xwj6IABdt2jzChcGznEVc/9GtgBncYWxwKb8acxAWf5cjskPxfuYscdaXBHQueVvdOIA/h5+QZEMfxttaPPSXMP2XjLA7EweVnz0G4/r8Rbp+hFhBJO2g7DxmFkd3h7Og5eO8B3n9J6Z1zKhAAAA==";
    private static final Log log = LogFactory.getLog(CreateSpeciesBatchUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    @ValidatorField( validatorId = "validator",  propertyName = "batchWeight",  editorName = "batchWeightField")
    protected NumberEditor batchWeightField;
    protected JLabel batchWeightLabel;
    protected JButton cancelButton;
    protected Table configurationPanel;
    protected JTable errorTable;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected CreateSpeciesBatchUIHandler handler;
    protected CreateSpeciesBatchUI homePanel = this;
    protected JPanel messagePanel;
    protected CreateSpeciesBatchUIModel model;
    protected JButton saveButton;
    @ValidatorField( validatorId = "validator",  propertyName = "species",  editorName = "speciesComboBox")
    protected BeanComboBox<Species> speciesComboBox;
    protected JLabel speciesLabel;
    protected JSplitPane splitPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<CreateSpeciesBatchUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public CreateSpeciesBatchUI(SpeciesBatchUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            CreateSpeciesBatchUIHandler handler = new CreateSpeciesBatchUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public CreateSpeciesBatchUI() {
        $initialize();
    }

    public CreateSpeciesBatchUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public NumberEditor getBatchWeightField() {
        return batchWeightField;
    }

    public JLabel getBatchWeightLabel() {
        return batchWeightLabel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public Table getConfigurationPanel() {
        return configurationPanel;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public CreateSpeciesBatchUIHandler getHandler() {
        return handler;
    }

    public JPanel getMessagePanel() {
        return messagePanel;
    }

    public CreateSpeciesBatchUIModel getModel() {
        return model;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public BeanComboBox<Species> getSpeciesComboBox() {
        return speciesComboBox;
    }

    public JLabel getSpeciesLabel() {
        return speciesLabel;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public SwingValidator<CreateSpeciesBatchUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add(speciesLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(speciesComboBox), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(batchWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add(SwingUtil.boxComponentWithJxLayer(batchWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        configurationPanel.add($JPanel0, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(splitPane, BorderLayout.NORTH);
    }

    protected void addChildrenToMessagePanel() {
        if (!allComponentsCreated) {
            return;
        }
        messagePanel.add($JScrollPane0);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add(configurationPanel, JSplitPane.LEFT);
        splitPane.add(messagePanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createBatchWeightField() {
        $objectMap.put("batchWeightField", batchWeightField = new NumberEditor(this));
        
        batchWeightField.setName("batchWeightField");
        batchWeightField.setProperty("batchWeight");
        batchWeightField.setUseFloat(true);
        batchWeightField.setShowReset(true);
    }

    protected void createBatchWeightLabel() {
        $objectMap.put("batchWeightLabel", batchWeightLabel = new JLabel());
        
        batchWeightLabel.setName("batchWeightLabel");
        batchWeightLabel.setText(_("tutti.label.createSpeciesBatch.batchWeight"));
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new Table());
        
        configurationPanel.setName("configurationPanel");
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setAutoCreateRowSorter(true);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(CreateSpeciesBatchUIHandler.class));
    }

    protected void createMessagePanel() {
        $objectMap.put("messagePanel", messagePanel = new JPanel());
        
        messagePanel.setName("messagePanel");
        messagePanel.setLayout(new GridLayout());
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(CreateSpeciesBatchUIModel.class));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSpeciesComboBox() {
        $objectMap.put("speciesComboBox", speciesComboBox = new BeanComboBox<Species>(this));
        
        speciesComboBox.setName("speciesComboBox");
        speciesComboBox.setI18nPrefix("tutti.property.");
        speciesComboBox.setProperty("species");
        speciesComboBox.setShowReset(true);
    }

    protected void createSpeciesLabel() {
        $objectMap.put("speciesLabel", speciesLabel = new JLabel());
        
        speciesLabel.setName("speciesLabel");
        speciesLabel.setText(_("tutti.label.createSpeciesBatch.species"));
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.2);
        splitPane.setOneTouchExpandable(true);
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(CreateSpeciesBatchUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToSplitPane();
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel0
        $JPanel0.add(cancelButton);
        $JPanel0.add(saveButton);
        addChildrenToMessagePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 18 property setters
        speciesComboBox.setBeanType(Species.class);
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        speciesLabel.setLabelFor(speciesComboBox);
        speciesComboBox.setBean(model);
        batchWeightLabel.setLabelFor(batchWeightField);
        batchWeightField.setBean(model);
        batchWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        batchWeightField.setNumberPattern(DECIMAL1_PATTERN);
        batchWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        messagePanel.setBorder(BorderFactory.createTitledBorder(_("tutti.title.messages")));
        errorTable.setModel(errorTableModel);
        errorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        errorTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createSplitPane();
        createConfigurationPanel();
        createSpeciesLabel();
        createSpeciesComboBox();
        createBatchWeightLabel();
        createBatchWeightField();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1, 0));
        createCancelButton();
        createSaveButton();
        createMessagePanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("species", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setSelectedItem(model.getSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("species", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_COMBO_BOX_DATA, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("availableSpecies", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesComboBox.setData(model.getAvailableSpecies());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("availableSpecies", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BATCH_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("batchWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    batchWeightField.setModel(model.getBatchWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("batchWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}