package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.border.TitledBorder;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.swing.editor.bean.BeanComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class SpeciesFrequencyUI extends JPanel implements TuttiUI<SpeciesFrequencyUIModel, SpeciesFrequencyUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_AUTO_GEN_MODE_BUTTON_SELECTED = "autoGenModeButton.selected";
    public static final String BINDING_GENERATE_BUTTON_ENABLED = "generateButton.enabled";
    public static final String BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM = "lengthStepCaracteristicComboBox.selectedItem";
    public static final String BINDING_MAX_STEP_FIELD_MODEL = "maxStepField.model";
    public static final String BINDING_MIN_STEP_FIELD_MODEL = "minStepField.model";
    public static final String BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED = "modeConfigurationLayout.selected";
    public static final String BINDING_RAFALE_MODE_BUTTON_SELECTED = "rafaleModeButton.selected";
    public static final String BINDING_SAVE_BUTTON_ENABLED = "saveButton.enabled";
    public static final String BINDING_SIMPLE_MODE_BUTTON_SELECTED = "simpleModeButton.selected";
    public static final String BINDING_STEP_FIELD_MODEL = "stepField.model";
    public static final String BINDING_TABLE_ENABLED = "table.enabled";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW = "$JScrollPane0.columnHeaderView";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(SpeciesFrequencyUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel actionPanel;
    protected JRadioButton autoGenModeButton;
    protected JPanel autoGenModePanel;
    protected JButton cancelButton;
    protected JPanel configurationPanel;
    protected JTable errorTable;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected JButton generateButton;
    protected SpeciesFrequencyUIHandler handler;
    protected SpeciesFrequencyUI homePanel = this;
    @ValidatorField( validatorId = "validator",  propertyName = "lengthStepCaracteristic",  editorName = "lengthStepCaracteristicComboBox")
    protected BeanComboBox<Caracteristic> lengthStepCaracteristicComboBox;
    protected JLabel lengthStepCaracteristicLabel;
    protected NumberEditor maxStepField;
    protected JLabel maxStepLabel;
    protected JPanel messagePanel;
    protected NumberEditor minStepField;
    protected JLabel minStepLabel;
    protected JAXXButtonGroup mode;
    protected CardLayout2Ext modeConfigurationLayout;
    protected JPanel modeConfigurationPanel;
    protected VBox modePanel;
    protected SpeciesFrequencyUIModel model;
    protected JRadioButton rafaleModeButton;
    protected JPanel rafaleModePanel;
    protected NumberEditor rafaleStepField;
    protected JLabel rafaleStepLabel;
    protected JButton saveButton;
    protected JRadioButton simpleModeButton;
    protected JLabel simpleModeLabel;
    protected JPanel simpleModePanel;
    protected JSplitPane splitPane;
    protected NumberEditor stepField;
    protected JLabel stepLabel;
    protected JXTable table;
    @ValidatorField( validatorId = "validator",  propertyName = "rows",  editorName = "tableScrollPane")
    protected JScrollPane tableScrollPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<SpeciesFrequencyUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private JPanel $JPanel1;
    private JPanel $JPanel2;
    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
          public void editBatch(SpeciesBatchRowModel row) {
              handler.editBatch(row);
          }
    
          protected void $afterCompleteSetup() {
              handler.afterInitUI();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public SpeciesFrequencyUI(SpeciesBatchUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
                  SpeciesFrequencyUIHandler handler = new SpeciesFrequencyUIHandler(parentUI.getHandler().getContext(), this);
                  setContextValue(handler);
                  handler.beforeInitUI();
            $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public SpeciesFrequencyUI() {
        $initialize();
    }

    public SpeciesFrequencyUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__autoGenModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.AUTO_GEN);
    }

    public void doActionPerformed__on__cancelButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.cancel();
    }

    public void doActionPerformed__on__generateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.generateLengthSteps();
    }

    public void doActionPerformed__on__rafaleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.RAFALE);
    }

    public void doActionPerformed__on__saveButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.save();
    }

    public void doActionPerformed__on__simpleModeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        model.setConfigurationMode(SpeciesFrequencyUIModel.ConfigurationMode.SIMPLE);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JPanel getActionPanel() {
        return actionPanel;
    }

    public JRadioButton getAutoGenModeButton() {
        return autoGenModeButton;
    }

    public JPanel getAutoGenModePanel() {
        return autoGenModePanel;
    }

    public JButton getCancelButton() {
        return cancelButton;
    }

    public JPanel getConfigurationPanel() {
        return configurationPanel;
    }

    public JTable getErrorTable() {
        return errorTable;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public JButton getGenerateButton() {
        return generateButton;
    }

    public SpeciesFrequencyUIHandler getHandler() {
        return handler;
    }

    public BeanComboBox<Caracteristic> getLengthStepCaracteristicComboBox() {
        return lengthStepCaracteristicComboBox;
    }

    public JLabel getLengthStepCaracteristicLabel() {
        return lengthStepCaracteristicLabel;
    }

    public NumberEditor getMaxStepField() {
        return maxStepField;
    }

    public JLabel getMaxStepLabel() {
        return maxStepLabel;
    }

    public JPanel getMessagePanel() {
        return messagePanel;
    }

    public NumberEditor getMinStepField() {
        return minStepField;
    }

    public JLabel getMinStepLabel() {
        return minStepLabel;
    }

    public JAXXButtonGroup getMode() {
        return mode;
    }

    public CardLayout2Ext getModeConfigurationLayout() {
        return modeConfigurationLayout;
    }

    public JPanel getModeConfigurationPanel() {
        return modeConfigurationPanel;
    }

    public VBox getModePanel() {
        return modePanel;
    }

    public SpeciesFrequencyUIModel getModel() {
        return model;
    }

    public JRadioButton getRafaleModeButton() {
        return rafaleModeButton;
    }

    public JPanel getRafaleModePanel() {
        return rafaleModePanel;
    }

    public NumberEditor getRafaleStepField() {
        return rafaleStepField;
    }

    public JLabel getRafaleStepLabel() {
        return rafaleStepLabel;
    }

    public JButton getSaveButton() {
        return saveButton;
    }

    public JRadioButton getSimpleModeButton() {
        return simpleModeButton;
    }

    public JLabel getSimpleModeLabel() {
        return simpleModeLabel;
    }

    public JPanel getSimpleModePanel() {
        return simpleModePanel;
    }

    public JSplitPane getSplitPane() {
        return splitPane;
    }

    public NumberEditor getStepField() {
        return stepField;
    }

    public JLabel getStepLabel() {
        return stepLabel;
    }

    public JXTable getTable() {
        return table;
    }

    public JScrollPane getTableScrollPane() {
        return tableScrollPane;
    }

    public SwingValidator<SpeciesFrequencyUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JPanel get$JPanel2() {
        return $JPanel2;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    protected Table get$Table2() {
        return $Table2;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToActionPanel() {
        if (!allComponentsCreated) {
            return;
        }
        actionPanel.add(cancelButton);
        actionPanel.add(saveButton);
    }

    protected void addChildrenToAutoGenModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; autoGenModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(autoGenModeButton); }
    }

    protected void addChildrenToAutoGenModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        autoGenModePanel.add($Table0, BorderLayout.SOUTH);
    }

    protected void addChildrenToConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        configurationPanel.add($JPanel1, BorderLayout.CENTER);
        configurationPanel.add($Table2, BorderLayout.SOUTH);
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(splitPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMessagePanel() {
        if (!allComponentsCreated) {
            return;
        }
        messagePanel.add($JScrollPane0);
    }

    protected void addChildrenToModeConfigurationPanel() {
        if (!allComponentsCreated) {
            return;
        }
        modeConfigurationPanel.add(simpleModePanel, "simpleMode");
        modeConfigurationPanel.add(autoGenModePanel, "autoGenMode");
        modeConfigurationPanel.add(rafaleModePanel, "rafaleMode");
    }

    protected void addChildrenToModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        modePanel.add(simpleModeButton);
        modePanel.add(autoGenModeButton);
        modePanel.add(rafaleModeButton);
    }

    protected void addChildrenToRafaleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; rafaleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(rafaleModeButton); }
    }

    protected void addChildrenToRafaleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        rafaleModePanel.add($Table1, BorderLayout.SOUTH);
    }

    protected void addChildrenToSimpleModeButton() {
        if (!allComponentsCreated) {
            return;
        }
        { ButtonGroup $buttonGroup = mode; simpleModeButton.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(simpleModeButton); }
    }

    protected void addChildrenToSimpleModePanel() {
        if (!allComponentsCreated) {
            return;
        }
        simpleModePanel.add(simpleModeLabel, BorderLayout.CENTER);
    }

    protected void addChildrenToSplitPane() {
        if (!allComponentsCreated) {
            return;
        }
        splitPane.add($JPanel0, JSplitPane.LEFT);
        splitPane.add(messagePanel, JSplitPane.RIGHT);
    }

    protected void addChildrenToTableScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        tableScrollPane.getViewport().add(table);
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        SwingValidatorUtil.registerErrorTableMouseListener(errorTable);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createActionPanel() {
        $objectMap.put("actionPanel", actionPanel = new JPanel());
        
        actionPanel.setName("actionPanel");
        actionPanel.setLayout(new GridLayout(1, 0));
    }

    protected void createAutoGenModeButton() {
        $objectMap.put("autoGenModeButton", autoGenModeButton = new JRadioButton());
        
        autoGenModeButton.setName("autoGenModeButton");
        autoGenModeButton.setText(_("tutti.label.frequencyConfiguration.mode.autoGen"));
        { autoGenModeButton.putClientProperty("$value", "autoGenMode");  Object $buttonGroup = autoGenModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        autoGenModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.autoGen.tip"));
        autoGenModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__autoGenModeButton"));
    }

    protected void createAutoGenModePanel() {
        $objectMap.put("autoGenModePanel", autoGenModePanel = new JPanel());
        
        autoGenModePanel.setName("autoGenModePanel");
    }

    protected void createCancelButton() {
        $objectMap.put("cancelButton", cancelButton = new JButton());
        
        cancelButton.setName("cancelButton");
        cancelButton.setText(_("tutti.action.cancel"));
        cancelButton.setMnemonic(67);
        cancelButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancelButton"));
    }

    protected void createConfigurationPanel() {
        $objectMap.put("configurationPanel", configurationPanel = new JPanel());
        
        configurationPanel.setName("configurationPanel");
        configurationPanel.setLayout(new BorderLayout());
    }

    protected void createErrorTable() {
        $objectMap.put("errorTable", errorTable = new JTable());
        
        errorTable.setName("errorTable");
        errorTable.setCellSelectionEnabled(false);
        errorTable.setRowSelectionAllowed(true);
        errorTable.setAutoCreateRowSorter(true);
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createGenerateButton() {
        $objectMap.put("generateButton", generateButton = new JButton());
        
        generateButton.setName("generateButton");
        generateButton.setText(_("tutti.action.generate"));
        generateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__generateButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(SpeciesFrequencyUIHandler.class));
    }

    protected void createLengthStepCaracteristicComboBox() {
        $objectMap.put("lengthStepCaracteristicComboBox", lengthStepCaracteristicComboBox = new BeanComboBox<Caracteristic>(this));
        
        lengthStepCaracteristicComboBox.setName("lengthStepCaracteristicComboBox");
        lengthStepCaracteristicComboBox.setI18nPrefix("tutti.property.");
        lengthStepCaracteristicComboBox.setProperty("lengthStepCaracteristic");
        lengthStepCaracteristicComboBox.setShowReset(true);
    }

    protected void createLengthStepCaracteristicLabel() {
        $objectMap.put("lengthStepCaracteristicLabel", lengthStepCaracteristicLabel = new JLabel());
        
        lengthStepCaracteristicLabel.setName("lengthStepCaracteristicLabel");
        lengthStepCaracteristicLabel.setText(_("tutti.label.frequencyConfiguration.lengthStepCaracteristic"));
    }

    protected void createMaxStepField() {
        $objectMap.put("maxStepField", maxStepField = new NumberEditor(this));
        
        maxStepField.setName("maxStepField");
        maxStepField.setProperty("maxStep");
        maxStepField.setUseFloat(true);
        maxStepField.setShowReset(true);
    }

    protected void createMaxStepLabel() {
        $objectMap.put("maxStepLabel", maxStepLabel = new JLabel());
        
        maxStepLabel.setName("maxStepLabel");
        maxStepLabel.setText(_("tutti.label.frequencyConfiguration.maxStep"));
    }

    protected void createMessagePanel() {
        $objectMap.put("messagePanel", messagePanel = new JPanel());
        
        messagePanel.setName("messagePanel");
        messagePanel.setLayout(new GridLayout());
    }

    protected void createMinStepField() {
        $objectMap.put("minStepField", minStepField = new NumberEditor(this));
        
        minStepField.setName("minStepField");
        minStepField.setProperty("minStep");
        minStepField.setUseFloat(true);
        minStepField.setShowReset(true);
    }

    protected void createMinStepLabel() {
        $objectMap.put("minStepLabel", minStepLabel = new JLabel());
        
        minStepLabel.setName("minStepLabel");
        minStepLabel.setText(_("tutti.label.frequencyConfiguration.minStep"));
    }

    protected void createMode() {
        $objectMap.put("mode", mode = new JAXXButtonGroup());
    }

    protected void createModeConfigurationLayout() {
        $objectMap.put("modeConfigurationLayout", modeConfigurationLayout = new CardLayout2Ext(this, "modeConfigurationPanel"));
    }

    protected void createModeConfigurationPanel() {
        $objectMap.put("modeConfigurationPanel", modeConfigurationPanel = new JPanel());
        
        modeConfigurationPanel.setName("modeConfigurationPanel");
        modeConfigurationPanel.setLayout(modeConfigurationLayout);
    }

    protected void createModePanel() {
        $objectMap.put("modePanel", modePanel = new VBox());
        
        modePanel.setName("modePanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(SpeciesFrequencyUIModel.class));
    }

    protected void createRafaleModeButton() {
        $objectMap.put("rafaleModeButton", rafaleModeButton = new JRadioButton());
        
        rafaleModeButton.setName("rafaleModeButton");
        rafaleModeButton.setText(_("tutti.label.frequencyConfiguration.mode.rafale"));
        { rafaleModeButton.putClientProperty("$value", "rafaleMode");  Object $buttonGroup = rafaleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        rafaleModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.rafale.tip"));
        rafaleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__rafaleModeButton"));
    }

    protected void createRafaleModePanel() {
        $objectMap.put("rafaleModePanel", rafaleModePanel = new JPanel());
        
        rafaleModePanel.setName("rafaleModePanel");
    }

    protected void createRafaleStepField() {
        $objectMap.put("rafaleStepField", rafaleStepField = new NumberEditor(this));
        
        rafaleStepField.setName("rafaleStepField");
        rafaleStepField.setUseFloat(true);
        rafaleStepField.setShowReset(true);
    }

    protected void createRafaleStepLabel() {
        $objectMap.put("rafaleStepLabel", rafaleStepLabel = new JLabel());
        
        rafaleStepLabel.setName("rafaleStepLabel");
        rafaleStepLabel.setText(_("tutti.label.frequencyConfiguration.rafaleStep"));
    }

    protected void createSaveButton() {
        $objectMap.put("saveButton", saveButton = new JButton());
        
        saveButton.setName("saveButton");
        saveButton.setText(_("tutti.action.save"));
        saveButton.setMnemonic(83);
        saveButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__saveButton"));
    }

    protected void createSimpleModeButton() {
        $objectMap.put("simpleModeButton", simpleModeButton = new JRadioButton());
        
        simpleModeButton.setName("simpleModeButton");
        simpleModeButton.setText(_("tutti.label.frequencyConfiguration.mode.simple"));
        { simpleModeButton.putClientProperty("$value", "simpleMode");  Object $buttonGroup = simpleModeButton.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        simpleModeButton.setToolTipText(_("tutti.label.frequencyConfiguration.mode.simple.tip"));
        simpleModeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__simpleModeButton"));
    }

    protected void createSimpleModeLabel() {
        $objectMap.put("simpleModeLabel", simpleModeLabel = new JLabel());
        
        simpleModeLabel.setName("simpleModeLabel");
        simpleModeLabel.setEnabled(false);
        simpleModeLabel.setText(_("tutti.label.frequencyConfiguration.no.configuration"));
    }

    protected void createSimpleModePanel() {
        $objectMap.put("simpleModePanel", simpleModePanel = new JPanel());
        
        simpleModePanel.setName("simpleModePanel");
        simpleModePanel.setLayout(new BorderLayout());
    }

    protected void createSplitPane() {
        $objectMap.put("splitPane", splitPane = new JSplitPane());
        
        splitPane.setName("splitPane");
        splitPane.setContinuousLayout(true);
        splitPane.setResizeWeight(0.2);
        splitPane.setOneTouchExpandable(true);
    }

    protected void createStepField() {
        $objectMap.put("stepField", stepField = new NumberEditor(this));
        
        stepField.setName("stepField");
        stepField.setProperty("step");
        stepField.setUseFloat(true);
    }

    protected void createStepLabel() {
        $objectMap.put("stepLabel", stepLabel = new JLabel());
        
        stepLabel.setName("stepLabel");
        stepLabel.setText(_("tutti.label.frequencyConfiguration.step"));
    }

    protected void createTable() {
        $objectMap.put("table", table = new JXTable());
        
        table.setName("table");
        table.setSortable(false);
    }

    protected void createTableScrollPane() {
        $objectMap.put("tableScrollPane", tableScrollPane = new JScrollPane());
        
        tableScrollPane.setName("tableScrollPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(SpeciesFrequencyUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToSplitPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(configurationPanel, BorderLayout.NORTH);
        $JPanel0.add(SwingUtil.boxComponentWithJxLayer(tableScrollPane), BorderLayout.CENTER);
        $JPanel0.add(actionPanel, BorderLayout.SOUTH);
        addChildrenToConfigurationPanel();
        // inline complete setup of $JPanel1
        $JPanel1.add(modePanel, BorderLayout.WEST);
        $JPanel1.add(modeConfigurationPanel, BorderLayout.CENTER);
        addChildrenToModePanel();
        addChildrenToSimpleModeButton();
        addChildrenToAutoGenModeButton();
        addChildrenToRafaleModeButton();
        addChildrenToModeConfigurationPanel();
        addChildrenToSimpleModePanel();
        addChildrenToAutoGenModePanel();
        // inline complete setup of $Table0
        $Table0.add(minStepLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(minStepField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(maxStepField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JPanel2, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel2
        $JPanel2.add(generateButton);
        addChildrenToRafaleModePanel();
        // inline complete setup of $Table1
        $Table1.add(rafaleStepLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(rafaleStepField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table2
        $Table2.add($JSeparator0, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(lengthStepCaracteristicLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(SwingUtil.boxComponentWithJxLayer(lengthStepCaracteristicComboBox), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(stepLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table2.add(stepField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        addChildrenToTableScrollPane();
        addChildrenToActionPanel();
        addChildrenToMessagePanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(errorTable);
        
        // apply 12 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 46 property setters
        modePanel.setVerticalAlignment(SwingConstants.CENTER);
        lengthStepCaracteristicComboBox.setBeanType(Caracteristic.class);
        splitPane.setOrientation(JSplitPane.VERTICAL_SPLIT);
        configurationPanel.setBorder(new TitledBorder(null, _("tutti.legend.frequencyConfiguration")));
        simpleModeLabel.setHorizontalAlignment(JLabel.CENTER);
        minStepLabel.setLabelFor(minStepField);
        minStepField.setBean(model);
        minStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        minStepField.setNumberPattern(DECIMAL1_PATTERN);
        minStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        maxStepLabel.setLabelFor(maxStepField);
        maxStepField.setBean(model);
        maxStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        maxStepField.setNumberPattern(DECIMAL1_PATTERN);
        maxStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        generateButton.setIcon(SwingUtil.createActionIcon("generate"));
        rafaleStepLabel.setLabelFor(rafaleStepField);
        rafaleStepField.setModelType(Float.class);
        rafaleStepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        rafaleStepField.setNumberPattern(DECIMAL1_PATTERN);
        rafaleStepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        lengthStepCaracteristicLabel.setLabelFor(lengthStepCaracteristicComboBox);
        lengthStepCaracteristicComboBox.setBean(model);
        stepLabel.setLabelFor(stepField);
        stepField.setBean(model);
        stepField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        stepField.setNumberPattern(DECIMAL1_PATTERN);
        stepField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        table.setSelectionForeground(Color.BLACK);
        table.setSelectionBackground(null);
        cancelButton.setIcon(SwingUtil.createActionIcon("cancel"));
        saveButton.setIcon(SwingUtil.createActionIcon("save"));
        messagePanel.setBorder(BorderFactory.createTitledBorder(_("tutti.title.messages")));
        errorTable.setModel(errorTableModel);
        errorTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        errorTable.setAutoResizeMode(JTable.AUTO_RESIZE_SUBSEQUENT_COLUMNS);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createModeConfigurationLayout();
        createSplitPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createConfigurationPanel();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        createModePanel();
        createSimpleModeButton();
        createAutoGenModeButton();
        createRafaleModeButton();
        createModeConfigurationPanel();
        createSimpleModePanel();
        createSimpleModeLabel();
        createAutoGenModePanel();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createMinStepLabel();
        createMinStepField();
        createMaxStepLabel();
        createMaxStepField();
        // inline creation of $JPanel2
        $objectMap.put("$JPanel2", $JPanel2 = new JPanel());
        
        $JPanel2.setName("$JPanel2");
        $JPanel2.setLayout(new GridLayout(1, 0));
        createGenerateButton();
        createRafaleModePanel();
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        createRafaleStepLabel();
        createRafaleStepField();
        // inline creation of $Table2
        $objectMap.put("$Table2", $Table2 = new Table());
        
        $Table2.setName("$Table2");
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createLengthStepCaracteristicLabel();
        createLengthStepCaracteristicComboBox();
        createStepLabel();
        createStepField();
        createTableScrollPane();
        createTable();
        createActionPanel();
        createCancelButton();
        createSaveButton();
        createMessagePanel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createErrorTable();
        createMode();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 12 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 12 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_$JSCROLL_PANE0_COLUMN_HEADER_VIEW, true) {
        
            @Override
            public void applyDataBinding() {
                if (errorTable != null) {
                    errorTable.addPropertyChangeListener("tableHeader", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (errorTable != null) {
                    $JScrollPane0.setColumnHeaderView(errorTable.getTableHeader());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (errorTable != null) {
                    errorTable.removePropertyChangeListener("tableHeader", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MODE_CONFIGURATION_LAYOUT_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (mode != null) {
                    mode.addPropertyChangeListener("selectedValue", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (mode != null) {
                    modeConfigurationLayout.setSelected(String.valueOf(mode.getSelectedValue()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (mode != null) {
                    mode.removePropertyChangeListener("selectedValue", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SIMPLE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("simpleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    simpleModeButton.setSelected(model.isSimpleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("simpleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_AUTO_GEN_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("autoGenMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    autoGenModeButton.setSelected(model.isAutoGenMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("autoGenMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_RAFALE_MODE_BUTTON_SELECTED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("rafaleMode", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    rafaleModeButton.setSelected(model.isRafaleMode());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("rafaleMode", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MIN_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("minStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    minStepField.setModel(model.getMinStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("minStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MAX_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("maxStep", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    maxStepField.setModel(model.getMaxStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("maxStep", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_GENERATE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("canGenerate", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    generateButton.setEnabled(model.isCanGenerate());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("canGenerate", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_LENGTH_STEP_CARACTERISTIC_COMBO_BOX_SELECTED_ITEM, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    lengthStepCaracteristicComboBox.setSelectedItem(model.getLengthStepCaracteristic());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_STEP_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("step", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    stepField.setModel(model.getStep());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("step", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_TABLE_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    table.setEnabled(model.getLengthStepCaracteristic() != null);
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("lengthStepCaracteristic", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SAVE_BUTTON_ENABLED, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("valid", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    saveButton.setEnabled(model.isValid());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("valid", this);
                }
            }
        });
    }

}