package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.accidental.AccidentalBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.macrowaste.MacroWasteBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.plankton.PlanktonBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesBatchUI;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.JAXXValidator;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.TabInfo;
import jaxx.runtime.swing.TabInfoPropertyChangeListener;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.NumberEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import jaxx.runtime.validator.swing.SwingValidatorMessageTableModel;
import jaxx.runtime.validator.swing.SwingValidatorUtil;
import jaxx.runtime.validator.swing.meta.Validator;
import jaxx.runtime.validator.swing.meta.ValidatorField;
import jaxx.runtime.validator.swing.ui.ImageValidationUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static jaxx.runtime.SwingUtil.getStringValue;
import static org.nuiton.i18n.I18n._;

public class EditCatchesUI extends JPanel implements TuttiUI<EditCatchesUIModel, EditCatchesUIHandler>, JAXXObject, JAXXValidator {

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL = "benthosTotalSampleSortedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalSampleSortedWeightField.numberPattern";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "benthosTotalSortedWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalSortedWeightField.numberPattern";
    public static final String BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "benthosTotalUnsortedWeightField.text";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_MODEL = "benthosTotalWeightField.model";
    public static final String BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "benthosTotalWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL = "catchTotalRejectedWeightField.model";
    public static final String BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalRejectedWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_MODEL = "catchTotalSortedCarousselWeightField.model";
    public static final String BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalSortedCarousselWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_MODEL = "catchTotalSortedTremisWeightField.model";
    public static final String BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalSortedTremisWeightField.numberPattern";
    public static final String BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "catchTotalUnsortedWeightField.text";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL = "catchTotalWeightField.model";
    public static final String BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "catchTotalWeightField.numberPattern";
    public static final String BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_MODEL = "macroWasteTotalWeightField.model";
    public static final String BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "macroWasteTotalWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSampleSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSampleSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL = "speciesTotalSortedWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalSortedWeightField.numberPattern";
    public static final String BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT = "speciesTotalUnsortedWeightField.text";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_MODEL = "speciesTotalWeightField.model";
    public static final String BINDING_SPECIES_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN = "speciesTotalWeightField.numberPattern";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "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";
    private static final Log log = LogFactory.getLog(EditCatchesUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected TabInfo accidentalTab;
    protected AccidentalBatchUI accidentalTabContent;
    protected JXTitledPanel accidentalTabFishingOperationReminderLabel;
    protected TabInfo benthosTab;
    protected BenthosBatchUI benthosTabContent;
    protected JXTitledPanel benthosTabFishingOperationReminderLabel;
    protected Table benthosTable;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSampleSortedWeight",  editorName = "benthosTotalSampleSortedWeightField")
    protected NumberEditor benthosTotalSampleSortedWeightField;
    protected JLabel benthosTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalSortedWeight",  editorName = "benthosTotalSortedWeightField")
    protected NumberEditor benthosTotalSortedWeightField;
    protected JLabel benthosTotalSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "benthosTotalUnsortedWeight",  editorName = "benthosTotalUnsortedWeightField")
    protected JTextField benthosTotalUnsortedWeightField;
    protected JLabel benthosTotalUnsortedWeightLabel;
    protected NumberEditor benthosTotalWeightField;
    protected JLabel benthosTotalWeightLabel;
    protected Table catchTable;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalRejectedWeight",  editorName = "catchTotalRejectedWeightField")
    protected NumberEditor catchTotalRejectedWeightField;
    protected JLabel catchTotalRejectedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalSortedCarousselWeight",  editorName = "catchTotalSortedCarousselWeightField")
    protected NumberEditor catchTotalSortedCarousselWeightField;
    protected JLabel catchTotalSortedCarousselWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalSortedTremisWeight",  editorName = "catchTotalSortedTremisWeightField")
    protected NumberEditor catchTotalSortedTremisWeightField;
    protected JLabel catchTotalSortedTremisWeightLabel;
    protected JTextField catchTotalUnsortedWeightField;
    protected JLabel catchTotalUnsortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "catchTotalWeight",  editorName = "catchTotalWeightField")
    protected NumberEditor catchTotalWeightField;
    protected JLabel catchTotalWeightLabel;
    protected TabInfo catchesCaracteristicsTab;
    protected JXTitledPanel catchesCaracteristicsTabPane;
    protected JScrollPane catchesCaracteristicsTabScrollPane;
    protected Table catchesForm;
    protected SwingValidatorMessageTableModel errorTableModel;
    protected EditCatchesUIHandler handler;
    protected EditCatchesUI homePanel = this;
    protected JButton importPupitriButton;
    protected TabInfo macroWasteTab;
    protected MacroWasteBatchUI macroWasteTabContent;
    protected JXTitledPanel macroWasteTabFishingOperationReminderLabel;
    protected Table macroWasteTable;
    @ValidatorField( validatorId = "validator",  propertyName = "macroWasteTotalWeight",  editorName = "macroWasteTotalWeightField")
    protected NumberEditor macroWasteTotalWeightField;
    protected JLabel macroWasteTotalWeightLabel;
    protected EditCatchesUIModel model;
    protected TabInfo observationIndividuelTab;
    protected JXTitledPanel observationTabFishingOperationReminderLabel;
    protected TabInfo planktonTab;
    protected PlanktonBatchUI planktonTabContent;
    protected JXTitledPanel planktonTabFishingOperationReminderLabel;
    protected TabInfo speciesTab;
    protected SpeciesBatchUI speciesTabContent;
    protected JXTitledPanel speciesTabFishingOperationReminderLabel;
    protected Table speciesTable;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSampleSortedWeight",  editorName = "speciesTotalSampleSortedWeightField")
    protected NumberEditor speciesTotalSampleSortedWeightField;
    protected JLabel speciesTotalSampleSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalSortedWeight",  editorName = "speciesTotalSortedWeightField")
    protected NumberEditor speciesTotalSortedWeightField;
    protected JLabel speciesTotalSortedWeightLabel;
    @ValidatorField( validatorId = "validator",  propertyName = "speciesTotalUnsortedWeight",  editorName = "speciesTotalUnsortedWeightField")
    protected JTextField speciesTotalUnsortedWeightField;
    protected JLabel speciesTotalUnsortedWeightLabel;
    protected NumberEditor speciesTotalWeightField;
    protected JLabel speciesTotalWeightLabel;
    protected JTabbedPane tabPane;
    @Validator( validatorId = "validator")
    protected SwingValidator<EditCatchesUIModel> validator;
    protected List<String> validatorIds = new ArrayList<String>();

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private JPanel $JPanel0;
    private JPanel $JPanel1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    protected void $afterCompleteSetup() { handler.afterInitUI(); }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EditCatchesUI(FishingOperationsUI parentUI) {
        JAXXUtil.initContext(this, parentUI);
            EditCatchesUIHandler handler = new EditCatchesUIHandler(parentUI, this);
            setContextValue(handler);
            handler.beforeInitUI();
            $initialize();
    }

    public EditCatchesUI(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI(boolean param0) {
        super(param0);
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EditCatchesUI() {
        $initialize();
    }

    public EditCatchesUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*-------------------- JAXXValidator implementation  --------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public SwingValidator<?> getValidator(String validatorId) {
        return (SwingValidator<?>) (validatorIds.contains(validatorId) ? getObjectById(validatorId) : null);
    }

    @Override
    public List<String> getValidatorIds() {
        return validatorIds;
    }

    @Override
    public void registerValidatorFields() {
        SwingValidatorUtil.detectValidatorFields(this);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__importPupitriButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importPupitri();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public TabInfo getAccidentalTab() {
        return accidentalTab;
    }

    public AccidentalBatchUI getAccidentalTabContent() {
        return accidentalTabContent;
    }

    public JXTitledPanel getAccidentalTabFishingOperationReminderLabel() {
        return accidentalTabFishingOperationReminderLabel;
    }

    public TabInfo getBenthosTab() {
        return benthosTab;
    }

    public BenthosBatchUI getBenthosTabContent() {
        return benthosTabContent;
    }

    public JXTitledPanel getBenthosTabFishingOperationReminderLabel() {
        return benthosTabFishingOperationReminderLabel;
    }

    public Table getBenthosTable() {
        return benthosTable;
    }

    public NumberEditor getBenthosTotalSampleSortedWeightField() {
        return benthosTotalSampleSortedWeightField;
    }

    public JLabel getBenthosTotalSampleSortedWeightLabel() {
        return benthosTotalSampleSortedWeightLabel;
    }

    public NumberEditor getBenthosTotalSortedWeightField() {
        return benthosTotalSortedWeightField;
    }

    public JLabel getBenthosTotalSortedWeightLabel() {
        return benthosTotalSortedWeightLabel;
    }

    public JTextField getBenthosTotalUnsortedWeightField() {
        return benthosTotalUnsortedWeightField;
    }

    public JLabel getBenthosTotalUnsortedWeightLabel() {
        return benthosTotalUnsortedWeightLabel;
    }

    public NumberEditor getBenthosTotalWeightField() {
        return benthosTotalWeightField;
    }

    public JLabel getBenthosTotalWeightLabel() {
        return benthosTotalWeightLabel;
    }

    public Table getCatchTable() {
        return catchTable;
    }

    public NumberEditor getCatchTotalRejectedWeightField() {
        return catchTotalRejectedWeightField;
    }

    public JLabel getCatchTotalRejectedWeightLabel() {
        return catchTotalRejectedWeightLabel;
    }

    public NumberEditor getCatchTotalSortedCarousselWeightField() {
        return catchTotalSortedCarousselWeightField;
    }

    public JLabel getCatchTotalSortedCarousselWeightLabel() {
        return catchTotalSortedCarousselWeightLabel;
    }

    public NumberEditor getCatchTotalSortedTremisWeightField() {
        return catchTotalSortedTremisWeightField;
    }

    public JLabel getCatchTotalSortedTremisWeightLabel() {
        return catchTotalSortedTremisWeightLabel;
    }

    public JTextField getCatchTotalUnsortedWeightField() {
        return catchTotalUnsortedWeightField;
    }

    public JLabel getCatchTotalUnsortedWeightLabel() {
        return catchTotalUnsortedWeightLabel;
    }

    public NumberEditor getCatchTotalWeightField() {
        return catchTotalWeightField;
    }

    public JLabel getCatchTotalWeightLabel() {
        return catchTotalWeightLabel;
    }

    public TabInfo getCatchesCaracteristicsTab() {
        return catchesCaracteristicsTab;
    }

    public JXTitledPanel getCatchesCaracteristicsTabPane() {
        return catchesCaracteristicsTabPane;
    }

    public JScrollPane getCatchesCaracteristicsTabScrollPane() {
        return catchesCaracteristicsTabScrollPane;
    }

    public Table getCatchesForm() {
        return catchesForm;
    }

    public SwingValidatorMessageTableModel getErrorTableModel() {
        return errorTableModel;
    }

    public EditCatchesUIHandler getHandler() {
        return handler;
    }

    public JButton getImportPupitriButton() {
        return importPupitriButton;
    }

    public TabInfo getMacroWasteTab() {
        return macroWasteTab;
    }

    public MacroWasteBatchUI getMacroWasteTabContent() {
        return macroWasteTabContent;
    }

    public JXTitledPanel getMacroWasteTabFishingOperationReminderLabel() {
        return macroWasteTabFishingOperationReminderLabel;
    }

    public Table getMacroWasteTable() {
        return macroWasteTable;
    }

    public NumberEditor getMacroWasteTotalWeightField() {
        return macroWasteTotalWeightField;
    }

    public JLabel getMacroWasteTotalWeightLabel() {
        return macroWasteTotalWeightLabel;
    }

    public EditCatchesUIModel getModel() {
        return model;
    }

    public TabInfo getObservationIndividuelTab() {
        return observationIndividuelTab;
    }

    public JXTitledPanel getObservationTabFishingOperationReminderLabel() {
        return observationTabFishingOperationReminderLabel;
    }

    public TabInfo getPlanktonTab() {
        return planktonTab;
    }

    public PlanktonBatchUI getPlanktonTabContent() {
        return planktonTabContent;
    }

    public JXTitledPanel getPlanktonTabFishingOperationReminderLabel() {
        return planktonTabFishingOperationReminderLabel;
    }

    public TabInfo getSpeciesTab() {
        return speciesTab;
    }

    public SpeciesBatchUI getSpeciesTabContent() {
        return speciesTabContent;
    }

    public JXTitledPanel getSpeciesTabFishingOperationReminderLabel() {
        return speciesTabFishingOperationReminderLabel;
    }

    public Table getSpeciesTable() {
        return speciesTable;
    }

    public NumberEditor getSpeciesTotalSampleSortedWeightField() {
        return speciesTotalSampleSortedWeightField;
    }

    public JLabel getSpeciesTotalSampleSortedWeightLabel() {
        return speciesTotalSampleSortedWeightLabel;
    }

    public NumberEditor getSpeciesTotalSortedWeightField() {
        return speciesTotalSortedWeightField;
    }

    public JLabel getSpeciesTotalSortedWeightLabel() {
        return speciesTotalSortedWeightLabel;
    }

    public JTextField getSpeciesTotalUnsortedWeightField() {
        return speciesTotalUnsortedWeightField;
    }

    public JLabel getSpeciesTotalUnsortedWeightLabel() {
        return speciesTotalUnsortedWeightLabel;
    }

    public NumberEditor getSpeciesTotalWeightField() {
        return speciesTotalWeightField;
    }

    public JLabel getSpeciesTotalWeightLabel() {
        return speciesTotalWeightLabel;
    }

    public JTabbedPane getTabPane() {
        return tabPane;
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return validator;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAccidentalTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        accidentalTabFishingOperationReminderLabel.add(accidentalTabContent);
    }

    protected void addChildrenToBenthosTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTabFishingOperationReminderLabel.add(benthosTabContent);
    }

    protected void addChildrenToBenthosTable() {
        if (!allComponentsCreated) {
            return;
        }
        benthosTable.add(benthosTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalSampleSortedWeightField), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(benthosTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        benthosTable.add(SwingUtil.boxComponentWithJxLayer(benthosTotalUnsortedWeightField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchTable() {
        if (!allComponentsCreated) {
            return;
        }
        catchTable.add(catchTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedTremisWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalSortedTremisWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalSortedCarousselWeightLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalSortedCarousselWeightField), new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalRejectedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(SwingUtil.boxComponentWithJxLayer(catchTotalRejectedWeightField), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchTable.add(catchTotalUnsortedWeightField, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToCatchesCaracteristicsTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabPane.add(catchesCaracteristicsTabScrollPane);
    }

    protected void addChildrenToCatchesCaracteristicsTabScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        catchesCaracteristicsTabScrollPane.getViewport().add($JPanel0);
    }

    protected void addChildrenToCatchesForm() {
        if (!allComponentsCreated) {
            return;
        }
        catchesForm.add(catchTable, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(speciesTable, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(benthosTable, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add(macroWasteTable, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        catchesForm.add($JPanel1, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToHomePanel() {
        if (!allComponentsCreated) {
            return;
        }
        add(tabPane, BorderLayout.CENTER);
    }

    protected void addChildrenToMacroWasteTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        macroWasteTabFishingOperationReminderLabel.add(macroWasteTabContent);
    }

    protected void addChildrenToMacroWasteTable() {
        if (!allComponentsCreated) {
            return;
        }
        macroWasteTable.add(macroWasteTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        macroWasteTable.add(SwingUtil.boxComponentWithJxLayer(macroWasteTotalWeightField), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToObservationTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        observationTabFishingOperationReminderLabel.add($JLabel0);
    }

    protected void addChildrenToPlanktonTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        planktonTabFishingOperationReminderLabel.add(planktonTabContent);
    }

    protected void addChildrenToSpeciesTabFishingOperationReminderLabel() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTabFishingOperationReminderLabel.add(speciesTabContent);
    }

    protected void addChildrenToSpeciesTable() {
        if (!allComponentsCreated) {
            return;
        }
        speciesTable.add(speciesTotalWeightLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalWeightField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSortedWeightLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSortedWeightField), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalSampleSortedWeightLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalSampleSortedWeightField), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(speciesTotalUnsortedWeightLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        speciesTable.add(SwingUtil.boxComponentWithJxLayer(speciesTotalUnsortedWeightField), new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTabPane() {
        if (!allComponentsCreated) {
            return;
        }
        tabPane.add(catchesCaracteristicsTabPane);
        tabPane.add(speciesTabFishingOperationReminderLabel);
        tabPane.add(benthosTabFishingOperationReminderLabel);
        tabPane.add(planktonTabFishingOperationReminderLabel);
        tabPane.add(macroWasteTabFishingOperationReminderLabel);
        tabPane.add(accidentalTabFishingOperationReminderLabel);
        tabPane.add(observationTabFishingOperationReminderLabel);
        catchesCaracteristicsTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 0));
        tabPane.setTitleAt(0, _("tutti.label.tab.catchesCaracteristics"));
        speciesTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 1));
        tabPane.setTitleAt(1, _("tutti.label.tab.species"));
        benthosTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 2));
        tabPane.setTitleAt(2, _("tutti.label.tab.benthos"));
        planktonTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 3));
        tabPane.setTitleAt(3, _("tutti.label.tab.plancton"));
        macroWasteTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 4));
        tabPane.setTitleAt(4, _("tutti.label.tab.macroDechet"));
        accidentalTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 5));
        tabPane.setTitleAt(5, _("tutti.label.tab.accidentel"));
        observationIndividuelTab.addPropertyChangeListener(new TabInfoPropertyChangeListener(tabPane, 6));
        tabPane.setTitleAt(6, _("tutti.label.tab.observationIndividuel"));
    }

    protected void addChildrenToValidator() {
        if (!allComponentsCreated) {
            return;
        }
        validator.setErrorTableModel(errorTableModel);
        validator.setUiClass(ImageValidationUI.class);
        validator.setBean(model);
    }

    protected void createAccidentalTab() {
        $objectMap.put("accidentalTab", accidentalTab = new TabInfo());
        
        accidentalTab.setTitle(_("tutti.label.tab.accidentel"));
    }

    protected void createAccidentalTabContent() {
        $objectMap.put("accidentalTabContent", accidentalTabContent = new AccidentalBatchUI(this));
        
        accidentalTabContent.setName("accidentalTabContent");
    }

    protected void createAccidentalTabFishingOperationReminderLabel() {
        $objectMap.put("accidentalTabFishingOperationReminderLabel", accidentalTabFishingOperationReminderLabel = new JXTitledPanel());
        
        accidentalTabFishingOperationReminderLabel.setName("accidentalTabFishingOperationReminderLabel");
    }

    protected void createBenthosTab() {
        $objectMap.put("benthosTab", benthosTab = new TabInfo());
        
        benthosTab.setTitle(_("tutti.label.tab.benthos"));
    }

    protected void createBenthosTabContent() {
        $objectMap.put("benthosTabContent", benthosTabContent = new BenthosBatchUI(this));
        
        benthosTabContent.setName("benthosTabContent");
    }

    protected void createBenthosTabFishingOperationReminderLabel() {
        $objectMap.put("benthosTabFishingOperationReminderLabel", benthosTabFishingOperationReminderLabel = new JXTitledPanel());
        
        benthosTabFishingOperationReminderLabel.setName("benthosTabFishingOperationReminderLabel");
    }

    protected void createBenthosTable() {
        $objectMap.put("benthosTable", benthosTable = new Table());
        
        benthosTable.setName("benthosTable");
    }

    protected void createBenthosTotalSampleSortedWeightField() {
        $objectMap.put("benthosTotalSampleSortedWeightField", benthosTotalSampleSortedWeightField = new NumberEditor(this));
        
        benthosTotalSampleSortedWeightField.setName("benthosTotalSampleSortedWeightField");
        benthosTotalSampleSortedWeightField.setProperty("benthosTotalSampleSortedWeight");
        benthosTotalSampleSortedWeightField.setUseFloat(false);
        benthosTotalSampleSortedWeightField.setShowReset(true);
    }

    protected void createBenthosTotalSampleSortedWeightLabel() {
        $objectMap.put("benthosTotalSampleSortedWeightLabel", benthosTotalSampleSortedWeightLabel = new JLabel());
        
        benthosTotalSampleSortedWeightLabel.setName("benthosTotalSampleSortedWeightLabel");
        benthosTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.benthosTotalSampleSortedWeight"));
    }

    protected void createBenthosTotalSortedWeightField() {
        $objectMap.put("benthosTotalSortedWeightField", benthosTotalSortedWeightField = new NumberEditor(this));
        
        benthosTotalSortedWeightField.setName("benthosTotalSortedWeightField");
        benthosTotalSortedWeightField.setProperty("benthosTotalSortedWeight");
        benthosTotalSortedWeightField.setUseFloat(false);
        benthosTotalSortedWeightField.setShowReset(true);
    }

    protected void createBenthosTotalSortedWeightLabel() {
        $objectMap.put("benthosTotalSortedWeightLabel", benthosTotalSortedWeightLabel = new JLabel());
        
        benthosTotalSortedWeightLabel.setName("benthosTotalSortedWeightLabel");
        benthosTotalSortedWeightLabel.setText(_("tutti.label.catches.benthosTotalSortedWeight"));
    }

    protected void createBenthosTotalUnsortedWeightField() {
        $objectMap.put("benthosTotalUnsortedWeightField", benthosTotalUnsortedWeightField = new JTextField());
        
        benthosTotalUnsortedWeightField.setName("benthosTotalUnsortedWeightField");
        benthosTotalUnsortedWeightField.setColumns(15);
        benthosTotalUnsortedWeightField.setEditable(false);
    }

    protected void createBenthosTotalUnsortedWeightLabel() {
        $objectMap.put("benthosTotalUnsortedWeightLabel", benthosTotalUnsortedWeightLabel = new JLabel());
        
        benthosTotalUnsortedWeightLabel.setName("benthosTotalUnsortedWeightLabel");
        benthosTotalUnsortedWeightLabel.setText(_("tutti.label.catches.benthosTotalUnsortedWeight"));
    }

    protected void createBenthosTotalWeightField() {
        $objectMap.put("benthosTotalWeightField", benthosTotalWeightField = new NumberEditor(this));
        
        benthosTotalWeightField.setName("benthosTotalWeightField");
        benthosTotalWeightField.setProperty("benthosTotalWeight");
        benthosTotalWeightField.setUseFloat(false);
        benthosTotalWeightField.setShowReset(true);
    }

    protected void createBenthosTotalWeightLabel() {
        $objectMap.put("benthosTotalWeightLabel", benthosTotalWeightLabel = new JLabel());
        
        benthosTotalWeightLabel.setName("benthosTotalWeightLabel");
        benthosTotalWeightLabel.setText(_("tutti.label.catches.benthosTotalWeight"));
    }

    protected void createCatchTable() {
        $objectMap.put("catchTable", catchTable = new Table());
        
        catchTable.setName("catchTable");
    }

    protected void createCatchTotalRejectedWeightField() {
        $objectMap.put("catchTotalRejectedWeightField", catchTotalRejectedWeightField = new NumberEditor(this));
        
        catchTotalRejectedWeightField.setName("catchTotalRejectedWeightField");
        catchTotalRejectedWeightField.setProperty("catchTotalRejectedWeight");
        catchTotalRejectedWeightField.setUseFloat(false);
        catchTotalRejectedWeightField.setShowReset(true);
    }

    protected void createCatchTotalRejectedWeightLabel() {
        $objectMap.put("catchTotalRejectedWeightLabel", catchTotalRejectedWeightLabel = new JLabel());
        
        catchTotalRejectedWeightLabel.setName("catchTotalRejectedWeightLabel");
        catchTotalRejectedWeightLabel.setText(_("tutti.label.catches.catchTotalRejectedWeight"));
    }

    protected void createCatchTotalSortedCarousselWeightField() {
        $objectMap.put("catchTotalSortedCarousselWeightField", catchTotalSortedCarousselWeightField = new NumberEditor(this));
        
        catchTotalSortedCarousselWeightField.setName("catchTotalSortedCarousselWeightField");
        catchTotalSortedCarousselWeightField.setProperty("catchTotalSortedCarousselWeight");
        catchTotalSortedCarousselWeightField.setUseFloat(false);
        catchTotalSortedCarousselWeightField.setShowReset(true);
    }

    protected void createCatchTotalSortedCarousselWeightLabel() {
        $objectMap.put("catchTotalSortedCarousselWeightLabel", catchTotalSortedCarousselWeightLabel = new JLabel());
        
        catchTotalSortedCarousselWeightLabel.setName("catchTotalSortedCarousselWeightLabel");
        catchTotalSortedCarousselWeightLabel.setText(_("tutti.label.catches.catchTotalSortedCarousselWeight"));
    }

    protected void createCatchTotalSortedTremisWeightField() {
        $objectMap.put("catchTotalSortedTremisWeightField", catchTotalSortedTremisWeightField = new NumberEditor(this));
        
        catchTotalSortedTremisWeightField.setName("catchTotalSortedTremisWeightField");
        catchTotalSortedTremisWeightField.setProperty("catchTotalSortedTremisWeight");
        catchTotalSortedTremisWeightField.setUseFloat(false);
        catchTotalSortedTremisWeightField.setShowReset(true);
    }

    protected void createCatchTotalSortedTremisWeightLabel() {
        $objectMap.put("catchTotalSortedTremisWeightLabel", catchTotalSortedTremisWeightLabel = new JLabel());
        
        catchTotalSortedTremisWeightLabel.setName("catchTotalSortedTremisWeightLabel");
        catchTotalSortedTremisWeightLabel.setText(_("tutti.label.catches.catchTotalSortedTremisWeight"));
    }

    protected void createCatchTotalUnsortedWeightField() {
        $objectMap.put("catchTotalUnsortedWeightField", catchTotalUnsortedWeightField = new JTextField());
        
        catchTotalUnsortedWeightField.setName("catchTotalUnsortedWeightField");
        catchTotalUnsortedWeightField.setColumns(15);
        catchTotalUnsortedWeightField.setEditable(false);
    }

    protected void createCatchTotalUnsortedWeightLabel() {
        $objectMap.put("catchTotalUnsortedWeightLabel", catchTotalUnsortedWeightLabel = new JLabel());
        
        catchTotalUnsortedWeightLabel.setName("catchTotalUnsortedWeightLabel");
        catchTotalUnsortedWeightLabel.setText(_("tutti.label.catches.catchTotalUnsortedWeight"));
    }

    protected void createCatchTotalWeightField() {
        $objectMap.put("catchTotalWeightField", catchTotalWeightField = new NumberEditor(this));
        
        catchTotalWeightField.setName("catchTotalWeightField");
        catchTotalWeightField.setProperty("catchTotalWeight");
        catchTotalWeightField.setUseFloat(false);
        catchTotalWeightField.setShowReset(true);
    }

    protected void createCatchTotalWeightLabel() {
        $objectMap.put("catchTotalWeightLabel", catchTotalWeightLabel = new JLabel());
        
        catchTotalWeightLabel.setName("catchTotalWeightLabel");
        catchTotalWeightLabel.setText(_("tutti.label.catches.catchTotalWeight"));
    }

    protected void createCatchesCaracteristicsTab() {
        $objectMap.put("catchesCaracteristicsTab", catchesCaracteristicsTab = new TabInfo());
        
        catchesCaracteristicsTab.setTitle(_("tutti.label.tab.catchesCaracteristics"));
    }

    protected void createCatchesCaracteristicsTabPane() {
        $objectMap.put("catchesCaracteristicsTabPane", catchesCaracteristicsTabPane = new JXTitledPanel());
        
        catchesCaracteristicsTabPane.setName("catchesCaracteristicsTabPane");
    }

    protected void createCatchesCaracteristicsTabScrollPane() {
        $objectMap.put("catchesCaracteristicsTabScrollPane", catchesCaracteristicsTabScrollPane = new JScrollPane());
        
        catchesCaracteristicsTabScrollPane.setName("catchesCaracteristicsTabScrollPane");
    }

    protected void createCatchesForm() {
        $objectMap.put("catchesForm", catchesForm = new Table());
        
        catchesForm.setName("catchesForm");
    }

    protected void createErrorTableModel() {
        $objectMap.put("errorTableModel", errorTableModel = new SwingValidatorMessageTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = getContextValue(EditCatchesUIHandler.class));
    }

    protected void createImportPupitriButton() {
        $objectMap.put("importPupitriButton", importPupitriButton = new JButton());
        
        importPupitriButton.setName("importPupitriButton");
        importPupitriButton.setText(_("tutti.action.pupitri-import"));
        importPupitriButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importPupitriButton"));
    }

    protected void createMacroWasteTab() {
        $objectMap.put("macroWasteTab", macroWasteTab = new TabInfo());
        
        macroWasteTab.setTitle(_("tutti.label.tab.macroDechet"));
    }

    protected void createMacroWasteTabContent() {
        $objectMap.put("macroWasteTabContent", macroWasteTabContent = new MacroWasteBatchUI(this));
        
        macroWasteTabContent.setName("macroWasteTabContent");
    }

    protected void createMacroWasteTabFishingOperationReminderLabel() {
        $objectMap.put("macroWasteTabFishingOperationReminderLabel", macroWasteTabFishingOperationReminderLabel = new JXTitledPanel());
        
        macroWasteTabFishingOperationReminderLabel.setName("macroWasteTabFishingOperationReminderLabel");
    }

    protected void createMacroWasteTable() {
        $objectMap.put("macroWasteTable", macroWasteTable = new Table());
        
        macroWasteTable.setName("macroWasteTable");
    }

    protected void createMacroWasteTotalWeightField() {
        $objectMap.put("macroWasteTotalWeightField", macroWasteTotalWeightField = new NumberEditor(this));
        
        macroWasteTotalWeightField.setName("macroWasteTotalWeightField");
        macroWasteTotalWeightField.setProperty("macroWasteTotalWeight");
        macroWasteTotalWeightField.setUseFloat(false);
        macroWasteTotalWeightField.setShowReset(true);
    }

    protected void createMacroWasteTotalWeightLabel() {
        $objectMap.put("macroWasteTotalWeightLabel", macroWasteTotalWeightLabel = new JLabel());
        
        macroWasteTotalWeightLabel.setName("macroWasteTotalWeightLabel");
        macroWasteTotalWeightLabel.setText(_("tutti.label.catches.macroWasteTotalWeight"));
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(EditCatchesUIModel.class));
    }

    protected void createObservationIndividuelTab() {
        $objectMap.put("observationIndividuelTab", observationIndividuelTab = new TabInfo());
        
        observationIndividuelTab.setTitle(_("tutti.label.tab.observationIndividuel"));
    }

    protected void createObservationTabFishingOperationReminderLabel() {
        $objectMap.put("observationTabFishingOperationReminderLabel", observationTabFishingOperationReminderLabel = new JXTitledPanel());
        
        observationTabFishingOperationReminderLabel.setName("observationTabFishingOperationReminderLabel");
    }

    protected void createPlanktonTab() {
        $objectMap.put("planktonTab", planktonTab = new TabInfo());
        
        planktonTab.setTitle(_("tutti.label.tab.plancton"));
    }

    protected void createPlanktonTabContent() {
        $objectMap.put("planktonTabContent", planktonTabContent = new PlanktonBatchUI(this));
        
        planktonTabContent.setName("planktonTabContent");
    }

    protected void createPlanktonTabFishingOperationReminderLabel() {
        $objectMap.put("planktonTabFishingOperationReminderLabel", planktonTabFishingOperationReminderLabel = new JXTitledPanel());
        
        planktonTabFishingOperationReminderLabel.setName("planktonTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTab() {
        $objectMap.put("speciesTab", speciesTab = new TabInfo());
        
        speciesTab.setTitle(_("tutti.label.tab.species"));
    }

    protected void createSpeciesTabContent() {
        $objectMap.put("speciesTabContent", speciesTabContent = new SpeciesBatchUI(this));
        
        speciesTabContent.setName("speciesTabContent");
    }

    protected void createSpeciesTabFishingOperationReminderLabel() {
        $objectMap.put("speciesTabFishingOperationReminderLabel", speciesTabFishingOperationReminderLabel = new JXTitledPanel());
        
        speciesTabFishingOperationReminderLabel.setName("speciesTabFishingOperationReminderLabel");
    }

    protected void createSpeciesTable() {
        $objectMap.put("speciesTable", speciesTable = new Table());
        
        speciesTable.setName("speciesTable");
    }

    protected void createSpeciesTotalSampleSortedWeightField() {
        $objectMap.put("speciesTotalSampleSortedWeightField", speciesTotalSampleSortedWeightField = new NumberEditor(this));
        
        speciesTotalSampleSortedWeightField.setName("speciesTotalSampleSortedWeightField");
        speciesTotalSampleSortedWeightField.setProperty("speciesTotalSampleSortedWeight");
        speciesTotalSampleSortedWeightField.setUseFloat(false);
        speciesTotalSampleSortedWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalSampleSortedWeightLabel() {
        $objectMap.put("speciesTotalSampleSortedWeightLabel", speciesTotalSampleSortedWeightLabel = new JLabel());
        
        speciesTotalSampleSortedWeightLabel.setName("speciesTotalSampleSortedWeightLabel");
        speciesTotalSampleSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSampleSortedWeight"));
    }

    protected void createSpeciesTotalSortedWeightField() {
        $objectMap.put("speciesTotalSortedWeightField", speciesTotalSortedWeightField = new NumberEditor(this));
        
        speciesTotalSortedWeightField.setName("speciesTotalSortedWeightField");
        speciesTotalSortedWeightField.setProperty("speciesTotalSortedWeight");
        speciesTotalSortedWeightField.setUseFloat(false);
        speciesTotalSortedWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalSortedWeightLabel() {
        $objectMap.put("speciesTotalSortedWeightLabel", speciesTotalSortedWeightLabel = new JLabel());
        
        speciesTotalSortedWeightLabel.setName("speciesTotalSortedWeightLabel");
        speciesTotalSortedWeightLabel.setText(_("tutti.label.catches.speciesTotalSortedWeight"));
    }

    protected void createSpeciesTotalUnsortedWeightField() {
        $objectMap.put("speciesTotalUnsortedWeightField", speciesTotalUnsortedWeightField = new JTextField());
        
        speciesTotalUnsortedWeightField.setName("speciesTotalUnsortedWeightField");
        speciesTotalUnsortedWeightField.setColumns(15);
        speciesTotalUnsortedWeightField.setEditable(false);
    }

    protected void createSpeciesTotalUnsortedWeightLabel() {
        $objectMap.put("speciesTotalUnsortedWeightLabel", speciesTotalUnsortedWeightLabel = new JLabel());
        
        speciesTotalUnsortedWeightLabel.setName("speciesTotalUnsortedWeightLabel");
        speciesTotalUnsortedWeightLabel.setText(_("tutti.label.catches.speciesTotalUnsortedWeight"));
    }

    protected void createSpeciesTotalWeightField() {
        $objectMap.put("speciesTotalWeightField", speciesTotalWeightField = new NumberEditor(this));
        
        speciesTotalWeightField.setName("speciesTotalWeightField");
        speciesTotalWeightField.setProperty("speciesTotalWeight");
        speciesTotalWeightField.setUseFloat(false);
        speciesTotalWeightField.setShowReset(true);
    }

    protected void createSpeciesTotalWeightLabel() {
        $objectMap.put("speciesTotalWeightLabel", speciesTotalWeightLabel = new JLabel());
        
        speciesTotalWeightLabel.setName("speciesTotalWeightLabel");
        speciesTotalWeightLabel.setText(_("tutti.label.catches.speciesTotalWeight"));
    }

    protected void createTabPane() {
        $objectMap.put("tabPane", tabPane = new JTabbedPane());
        
        tabPane.setName("tabPane");
    }

    protected void createValidator() {
        $objectMap.put("validator", validator = SwingValidator.newValidator(EditCatchesUIModel.class, null));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToHomePanel();
        addChildrenToValidator();
        addChildrenToTabPane();
        addChildrenToCatchesCaracteristicsTabPane();
        addChildrenToCatchesCaracteristicsTabScrollPane();
        // inline complete setup of $JPanel0
        $JPanel0.add(catchesForm, BorderLayout.NORTH);
        addChildrenToCatchesForm();
        addChildrenToCatchTable();
        addChildrenToSpeciesTable();
        addChildrenToBenthosTable();
        addChildrenToMacroWasteTable();
        // inline complete setup of $JPanel1
        $JPanel1.add(importPupitriButton);
        addChildrenToSpeciesTabFishingOperationReminderLabel();
        addChildrenToBenthosTabFishingOperationReminderLabel();
        addChildrenToPlanktonTabFishingOperationReminderLabel();
        addChildrenToMacroWasteTabFishingOperationReminderLabel();
        addChildrenToAccidentalTabFishingOperationReminderLabel();
        addChildrenToObservationTabFishingOperationReminderLabel();
        
        // apply 25 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 57 property setters
        $JLabel0.setHorizontalAlignment(JLabel.CENTER);
        catchTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.total")));
        catchTotalWeightLabel.setLabelFor(catchTotalWeightField);
        catchTotalWeightField.setBean(model);
        catchTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalSortedTremisWeightLabel.setLabelFor(catchTotalSortedTremisWeightField);
        catchTotalSortedTremisWeightField.setBean(model);
        catchTotalSortedTremisWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalSortedTremisWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalSortedCarousselWeightLabel.setLabelFor(catchTotalSortedCarousselWeightField);
        catchTotalSortedCarousselWeightField.setBean(model);
        catchTotalSortedCarousselWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalSortedCarousselWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalRejectedWeightLabel.setLabelFor(catchTotalRejectedWeightField);
        catchTotalRejectedWeightField.setBean(model);
        catchTotalRejectedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        catchTotalRejectedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        catchTotalUnsortedWeightLabel.setLabelFor(catchTotalUnsortedWeightField);
        speciesTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.species")));
        speciesTotalWeightLabel.setLabelFor(speciesTotalWeightField);
        speciesTotalWeightField.setBean(model);
        speciesTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSortedWeightLabel.setLabelFor(speciesTotalSortedWeightField);
        speciesTotalSortedWeightField.setBean(model);
        speciesTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalSampleSortedWeightLabel.setLabelFor(speciesTotalSampleSortedWeightField);
        speciesTotalSampleSortedWeightField.setBean(model);
        speciesTotalSampleSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        speciesTotalSampleSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        speciesTotalUnsortedWeightLabel.setLabelFor(speciesTotalUnsortedWeightField);
        benthosTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.benthos")));
        benthosTotalWeightLabel.setLabelFor(benthosTotalWeightField);
        benthosTotalWeightField.setBean(model);
        benthosTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSortedWeightLabel.setLabelFor(benthosTotalSortedWeightField);
        benthosTotalSortedWeightField.setBean(model);
        benthosTotalSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalSampleSortedWeightLabel.setLabelFor(benthosTotalSampleSortedWeightField);
        benthosTotalSampleSortedWeightField.setBean(model);
        benthosTotalSampleSortedWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        benthosTotalSampleSortedWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        benthosTotalUnsortedWeightLabel.setLabelFor(benthosTotalUnsortedWeightField);
        macroWasteTable.setBorder(BorderFactory.createTitledBorder(_("tutti.legend.catch.macroWaste")));
        macroWasteTotalWeightLabel.setLabelFor(macroWasteTotalWeightField);
        macroWasteTotalWeightField.setBean(model);
        macroWasteTotalWeightField.setAutoPopup(handler.getConfig().isAutoPopupNumberEditor());
        macroWasteTotalWeightField.setShowPopupButton(handler.getConfig().isShowNumberEditorButton());
        importPupitriButton.setIcon(SwingUtil.createActionIcon("pupitri-import"));
        observationIndividuelTab.setEnabled(false);
        // late initializer
        // register 1 validator(s)
        validatorIds = SwingValidatorUtil.detectValidators(this);
        SwingValidatorUtil.installUI(this);
        
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("homePanel", homePanel);
        createHandler();
        createModel();
        createErrorTableModel();
        createValidator();
        createTabPane();
        createCatchesCaracteristicsTabPane();
        createCatchesCaracteristicsTabScrollPane();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new BorderLayout());
        createCatchesForm();
        createCatchTable();
        createCatchTotalWeightLabel();
        createCatchTotalWeightField();
        createCatchTotalSortedTremisWeightLabel();
        createCatchTotalSortedTremisWeightField();
        createCatchTotalSortedCarousselWeightLabel();
        createCatchTotalSortedCarousselWeightField();
        createCatchTotalRejectedWeightLabel();
        createCatchTotalRejectedWeightField();
        createCatchTotalUnsortedWeightLabel();
        createCatchTotalUnsortedWeightField();
        createSpeciesTable();
        createSpeciesTotalWeightLabel();
        createSpeciesTotalWeightField();
        createSpeciesTotalSortedWeightLabel();
        createSpeciesTotalSortedWeightField();
        createSpeciesTotalSampleSortedWeightLabel();
        createSpeciesTotalSampleSortedWeightField();
        createSpeciesTotalUnsortedWeightLabel();
        createSpeciesTotalUnsortedWeightField();
        createBenthosTable();
        createBenthosTotalWeightLabel();
        createBenthosTotalWeightField();
        createBenthosTotalSortedWeightLabel();
        createBenthosTotalSortedWeightField();
        createBenthosTotalSampleSortedWeightLabel();
        createBenthosTotalSampleSortedWeightField();
        createBenthosTotalUnsortedWeightLabel();
        createBenthosTotalUnsortedWeightField();
        createMacroWasteTable();
        createMacroWasteTotalWeightLabel();
        createMacroWasteTotalWeightField();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new GridLayout(1,0));
        createImportPupitriButton();
        createSpeciesTabFishingOperationReminderLabel();
        createSpeciesTabContent();
        createBenthosTabFishingOperationReminderLabel();
        createBenthosTabContent();
        createPlanktonTabFishingOperationReminderLabel();
        createPlanktonTabContent();
        createMacroWasteTabFishingOperationReminderLabel();
        createMacroWasteTabContent();
        createAccidentalTabFishingOperationReminderLabel();
        createAccidentalTabContent();
        createObservationTabFishingOperationReminderLabel();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("tutti.to.be.done"));
        createCatchesCaracteristicsTab();
        createSpeciesTab();
        createBenthosTab();
        createPlanktonTab();
        createMacroWasteTab();
        createAccidentalTab();
        createObservationIndividuelTab();
        // inline creation of homePanel
        setName("homePanel");
        setLayout(new BorderLayout());
        
        // registers 25 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 25 data bindings
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalWeightField.setModel(model.getCatchTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedTremisWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalSortedTremisWeightField.setModel(model.getCatchTotalSortedTremisWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedTremisWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_SORTED_TREMIS_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalSortedTremisWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalSortedCarousselWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalSortedCarousselWeightField.setModel(model.getCatchTotalSortedCarousselWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalSortedCarousselWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_SORTED_CAROUSSEL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalSortedCarousselWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    catchTotalRejectedWeightField.setModel(model.getCatchTotalRejectedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalRejectedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CATCH_TOTAL_REJECTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                catchTotalRejectedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_CATCH_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("catchTotalUnsortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(catchTotalUnsortedWeightField, getStringValue(model.getCatchTotalUnsortedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("catchTotalUnsortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalWeightField.setModel(model.getSpeciesTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSortedWeightField.setModel(model.getSpeciesTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalSampleSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    speciesTotalSampleSortedWeightField.setModel(model.getSpeciesTotalSampleSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalSampleSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_SPECIES_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                speciesTotalSampleSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_SPECIES_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("speciesTotalUnsortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(speciesTotalUnsortedWeightField, getStringValue(model.getSpeciesTotalUnsortedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("speciesTotalUnsortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalWeightField.setModel(model.getBenthosTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSortedWeightField.setModel(model.getBenthosTotalSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalSampleSortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    benthosTotalSampleSortedWeightField.setModel(model.getBenthosTotalSampleSortedWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalSampleSortedWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BENTHOS_TOTAL_SAMPLE_SORTED_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                benthosTotalSampleSortedWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_BENTHOS_TOTAL_UNSORTED_WEIGHT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("benthosTotalUnsortedWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    SwingUtil.setText(benthosTotalUnsortedWeightField, getStringValue(model.getBenthosTotalUnsortedWeight()));
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("benthosTotalUnsortedWeight", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_MODEL, true) {
        
            @Override
            public void applyDataBinding() {
                if (model != null) {
                    model.addPropertyChangeListener("macroWasteTotalWeight", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (model != null) {
                    macroWasteTotalWeightField.setModel(model.getMacroWasteTotalWeight());
                }
            }
        
            @Override
            public void removeDataBinding() {
                if (model != null) {
                    model.removePropertyChangeListener("macroWasteTotalWeight", this);
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_MACRO_WASTE_TOTAL_WEIGHT_FIELD_NUMBER_PATTERN, true ,"INT_6_DIGITS_PATTERN") {
        
            @Override
            public void processDataBinding() {
                macroWasteTotalWeightField.setNumberPattern(INT_6_DIGITS_PATTERN);
            }
        });
    }

}