package fr.ifremer.tutti.ui.swing.content.operation;

/*
 * #%L
 * Tutti :: UI
 * $Id: EditFishingOperationUIModel.java 146 2013-01-02 18:51:13Z kmorin $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.2.5/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/EditFishingOperationUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.referential.FishingOperationLocation;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import fr.ird.type.SexagecimalPosition;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.util.Date;
import java.util.List;

/**
 * Model for UI {@link EditFishingOperationUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class EditFishingOperationUIModel extends AbstractTuttiBeanUIModel<FishingOperation, EditFishingOperationUIModel> {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_PERSISTED = "persisted";

    public static final String PROPERTY_EMPTY = "empty";

    public static final String PROPERTY_STATION_NUMBER = "stationNumber";

    public static final String PROPERTY_FISHING_OPERATION_NUMBER = "fishingOperationNumber";

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_STRATA = "strata";

    public static final String PROPERTY_SUB_STRATA = "subStrata";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE = "gearShootingStartLatitude";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE = "gearShootingStartLongitude";

    public static final String PROPERTY_GEAR_SHOOTING_START_DATE = "gearShootingStartDate";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE = "gearShootingEndLatitude";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE = "gearShootingEndLongitude";

    public static final String PROPERTY_GEAR_SHOOTING_END_DATE = "gearShootingEndDate";

    public static final String PROPERTY_FISHING_OPERATION_RECTILIGNE = "fishingOperationRectiligne";

    public static final String PROPERTY_DISTANCE_CHALUTEE = "distanceChalutee";

    public static final String PROPERTY_DUREE = "duree";

    public static final String PROPERTY_FISHING_OPERATION_VALID = "fishingOperationValid";

    public static final String PROPERTY_LOCATION = "location";

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_SAISISSEUR = "saisisseur";

    /**
     * Flag when there is no fishing operation selected.
     *
     * @since 0.2
     */
    protected boolean empty;

    protected Cruise cruise;

    protected String stationNumber;

    protected Integer fishingOperationNumber;

    protected Date date;

    protected FishingOperationLocation strata;

    protected FishingOperationLocation subStrata;

    protected SexagecimalPosition gearShootingStartLatitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingStartLongitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingEndLatitudeAsSexagecimal;

    protected SexagecimalPosition gearShootingEndLongitudeAsSexagecimal;

    protected boolean useSexagecimalFormat;

    protected Float gearShootingStartLatitude;

    protected Float gearShootingStartLongitude;

    protected Date gearShootingStartDate;

    protected Integer gearShootingStartTime;

    protected Float gearShootingEndLatitude;

    protected Float gearShootingEndLongitude;

    protected Date gearShootingEndDate;

    protected Integer gearShootingEndTime;

    protected boolean fishingOperationRectiligne;

    protected Float distanceChalutee;

    protected Float duree;

    protected Boolean fishingOperationValid;

    protected FishingOperationLocation location;

    protected String comment;

    protected List<Person> saisisseur;

    protected FishingOperation fishingOperation;

    protected static Binder<EditFishingOperationUIModel, FishingOperation> toBeanBinder =
            BinderFactory.newBinder(EditFishingOperationUIModel.class,
                                    FishingOperation.class);

    protected static Binder<FishingOperation, EditFishingOperationUIModel> fromBeanBinder =
            BinderFactory.newBinder(FishingOperation.class, EditFishingOperationUIModel.class);

    public EditFishingOperationUIModel() {
        super(FishingOperation.class, fromBeanBinder, toBeanBinder);
    }

    public FishingOperation getFishingOperation() {
        return fishingOperation;
    }

    public void setFishingOperation(FishingOperation fishingOperation) {
        this.fishingOperation = fishingOperation;
        firePropertyChange(PROPERTY_PERSISTED, null, isPersisted());
    }

    public boolean isPersisted() {
        return fishingOperation != null && !TuttiEntities.isNew(fishingOperation);
    }

    public boolean isEmpty() {
        return empty;
    }

    public void setEmpty(boolean empty) {
        Object oldValue = isEmpty();
        this.empty = empty;
        firePropertyChange(PROPERTY_EMPTY, oldValue, empty);
    }

    public Cruise getCruise() {
        return cruise;
    }

    public void setCruise(Cruise cruise) {
        this.cruise = cruise;
    }

    public String getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        Object oldValue = getStationNumber();
        this.stationNumber = stationNumber;
        firePropertyChange(PROPERTY_STATION_NUMBER, oldValue, stationNumber);
    }

    public Integer getFishingOperationNumber() {
        return fishingOperationNumber;
    }

    public void setFishingOperationNumber(Integer fishingOperationNumber) {
        Object oldValue = getFishingOperationNumber();
        this.fishingOperationNumber = fishingOperationNumber;
        firePropertyChange(PROPERTY_FISHING_OPERATION_NUMBER, oldValue, fishingOperationNumber);
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Object oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public FishingOperationLocation getStrata() {
        return strata;
    }

    public void setStrata(FishingOperationLocation strata) {
        Object oldValue = getStrata();
        this.strata = strata;
        firePropertyChange(PROPERTY_STRATA, oldValue, strata);
    }

    public FishingOperationLocation getSubStrata() {
        return subStrata;
    }

    public void setSubStrata(FishingOperationLocation subStrata) {
        Object oldValue = getSubStrata();
        this.subStrata = subStrata;
        firePropertyChange(PROPERTY_SUB_STRATA, oldValue, subStrata);
    }

    public Float getGearShootingStartLatitude() {
        return gearShootingStartLatitude;
    }

    public void setGearShootingStartLatitude(Float gearShootingStartLatitude) {
        Object oldValue = getGearShootingStartLatitude();
        this.gearShootingStartLatitude = gearShootingStartLatitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE, oldValue, gearShootingStartLatitude);
    }

    public Float getGearShootingStartLongitude() {
        return gearShootingStartLongitude;
    }

    public void setGearShootingStartLongitude(Float gearShootingStartLongitude) {
        Object oldValue = getGearShootingStartLongitude();
        this.gearShootingStartLongitude = gearShootingStartLongitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE, oldValue, gearShootingStartLongitude);
    }

    public Date getGearShootingStartDate() {
        return gearShootingStartDate;
    }

    public void setGearShootingStartDate(Date gearShootingStartDate) {
        Object oldValue = getGearShootingStartDate();
        this.gearShootingStartDate = gearShootingStartDate;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_DATE, oldValue, gearShootingStartDate);
    }

    public Float getGearShootingEndLatitude() {
        return gearShootingEndLatitude;
    }

    public void setGearShootingEndLatitude(Float gearShootingEndLatitude) {
        Object oldValue = getGearShootingEndLatitude();
        this.gearShootingEndLatitude = gearShootingEndLatitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE, oldValue, gearShootingEndLatitude);
    }

    public Float getGearShootingEndLongitude() {
        return gearShootingEndLongitude;
    }

    public void setGearShootingEndLongitude(Float gearShootingEndLongitude) {
        Object oldValue = getGearShootingEndLongitude();
        this.gearShootingEndLongitude = gearShootingEndLongitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE, oldValue, gearShootingEndLongitude);
    }

    public Date getGearShootingEndDate() {
        return gearShootingEndDate;
    }

    public void setGearShootingEndDate(Date gearShootingEndDate) {
        Object oldValue = getGearShootingEndDate();
        this.gearShootingEndDate = gearShootingEndDate;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_DATE, oldValue, gearShootingEndDate);
    }

    public boolean isFishingOperationRectiligne() {
        return fishingOperationRectiligne;
    }

    public void setFishingOperationRectiligne(boolean fishingOperationRectiligne) {
        Object oldValue = isFishingOperationRectiligne();
        this.fishingOperationRectiligne = fishingOperationRectiligne;
        firePropertyChange(PROPERTY_FISHING_OPERATION_RECTILIGNE, oldValue, fishingOperationRectiligne);
    }

    public Float getDistanceChalutee() {
        return distanceChalutee;
    }

    public void setDistanceChalutee(Float distanceChalutee) {
        Object oldValue = getDistanceChalutee();
        this.distanceChalutee = distanceChalutee;
        firePropertyChange(PROPERTY_DISTANCE_CHALUTEE, oldValue, distanceChalutee);
    }

    public Float getDuree() {
        return duree;
    }

    public void setDuree(Float duree) {
        Object oldValue = getDuree();
        this.duree = duree;
        firePropertyChange(PROPERTY_DUREE, oldValue, duree);
    }

    public Boolean getFishingOperationValid() {
        return fishingOperationValid;
    }

    public void setFishingOperationValid(Boolean fishingOperationValid) {
        Object oldValue = getFishingOperationValid();
        this.fishingOperationValid = fishingOperationValid;
        firePropertyChange(PROPERTY_FISHING_OPERATION_VALID, oldValue, fishingOperationValid);
    }

    public FishingOperationLocation getLocation() {
        return location;
    }

    public void setLocation(FishingOperationLocation location) {
        Object oldValue = getLocation();
        this.location = location;
        firePropertyChange(PROPERTY_LOCATION, oldValue, location);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<Person> getSaisisseur() {
        return saisisseur;
    }

    public void setSaisisseur(List<Person> saisisseur) {
        this.saisisseur = saisisseur;
        firePropertyChange(PROPERTY_SAISISSEUR, null, saisisseur);
    }

    @Override
    protected FishingOperation newEntity() {
        return fishingOperation;
    }
}