package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: TraitTabUIModel.java 15 2012-11-24 13:10:24Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/catches/TraitTabUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.BeaufortScaleBean;
import fr.ifremer.tutti.persistence.entities.CampaignBean;
import fr.ifremer.tutti.persistence.entities.SeaStateBean;
import fr.ifremer.tutti.persistence.entities.StrataBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import fr.ifremer.tutti.persistence.entities.UserBean;
import fr.ifremer.tutti.ui.swing.AbstractTuttiBeanUIModel;
import org.nuiton.util.beans.BinderFactory;

import java.util.Date;
import java.util.List;

/**
 * Model for UI {@link TraitTabUI}.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class TraitTabUIModel extends AbstractTuttiBeanUIModel {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_EMPTY = "empty";

    public static final String PROPERTY_STATION_NUMBER = "stationNumber";

    public static final String PROPERTY_TRAIT_NUMBER = "traitNumber";

    public static final String PROPERTY_DATE = "date";

    public static final String PROPERTY_STRATA = "strata";

    public static final String PROPERTY_GEAR_SHOOTING_START_LATITUDE = "gearShootingStartLatitude";

    public static final String PROPERTY_GEAR_SHOOTING_START_LONGITUDE = "gearShootingStartLongitude";

    public static final String PROPERTY_GEAR_SHOOTING_START_TIME = "gearShootingStartTime";

    public static final String PROPERTY_GEAR_SHOOTING_START_DEPTH = "gearShootingStartDepth";

    public static final String PROPERTY_GEAR_SHOOTING_END_LATITUDE = "gearShootingEndLatitude";

    public static final String PROPERTY_GEAR_SHOOTING_END_LONGITUDE = "gearShootingEndLongitude";

    public static final String PROPERTY_GEAR_SHOOTING_END_TIME = "gearShootingEndTime";

    public static final String PROPERTY_GEAR_SHOOTING_END_DEPTH = "gearShootingEndDepth";

    public static final String PROPERTY_BEAUFORT_SCALE = "beaufortScale";

    public static final String PROPERTY_WIND_DIRECTION = "windDirection";

    public static final String PROPERTY_SEA_STATE = "seaState";

    public static final String PROPERTY_OUVERTURE_HORIZONTALE = "ouvertureHorizontale";

    public static final String PROPERTY_OUVERTURE_VERTICALE = "ouvertureVerticale";

    public static final String PROPERTY_GEOMETRIE_MESUREE = "geometrieMesuree";

    public static final String PROPERTY_LONGUEUR_FUNES = "longueurFunes";

    public static final String PROPERTY_LONGUEUR_BRAS = "longueurBras";

    public static final String PROPERTY_SYSTEME_FERMETURE_CUL = "systemeFermetureCul";

    public static final String PROPERTY_TRAIT_RECTILIGNE = "traitRectiligne";

    public static final String PROPERTY_DISTANCE_CHALUTEE = "distanceChalutee";

    public static final String PROPERTY_DUREE = "duree";

    public static final String PROPERTY_TRAIT_VALID = "traitValid";

    public static final String PROPERTY_LOCALITE = "localite";

    public static final String PROPERTY_COMMENT = "comment";

    public static final String PROPERTY_SAISISSEUR = "saisisseur";

    public static final String PROPERTY_GEAR_SHOOTING_START_SURFACE_TEMPERATURE = "gearShootingStartSurfaceTemperature";

    public static final String PROPERTY_GEAR_SHOOTING_END_SURFACE_TEMPERATURE = "gearShootingEndSurfaceTemperature";

    public static final String PROPERTY_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE = "gearShootingStartBottomTemperature";

    public static final String PROPERTY_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE = "gearShootingEndBottomTemperature";

    public static final String PROPERTY_AVERAGE_BOTTOM_TEMPERATURE = "averageBottomTemperature";

    public static final String PROPERTY_GEAR_SHOOTING_START_SURFACE_SALINITY = "gearShootingStartSurfaceSalinity";

    public static final String PROPERTY_GEAR_SHOOTING_END_SURFACE_SALINITY = "gearShootingEndSurfaceSalinity";

    public static final String PROPERTY_GEAR_SHOOTING_START_BOTTOM_SALINITY = "gearShootingStartBottomSalinity";

    public static final String PROPERTY_GEAR_SHOOTING_END_BOTTOM_SALINITY = "gearShootingEndBottomSalinity";

    public static final String PROPERTY_AVERAGE_BOTTOM_SALINITY = "averageBottomSalinity";

    protected boolean empty;

    protected CampaignBean campaign;

    protected Integer stationNumber;

    protected Integer traitNumber;

    protected Date date;

    protected StrataBean strata;

    protected Float gearShootingStartLatitude;

    protected Float gearShootingStartLongitude;

    protected Date gearShootingStartTime;

    protected Float gearShootingStartDepth;

    protected Float gearShootingEndLatitude;

    protected Float gearShootingEndLongitude;

    protected Date gearShootingEndTime;

    protected Float gearShootingEndDepth;

    protected BeaufortScaleBean beaufortScale;

    protected Integer windDirection;

    protected SeaStateBean seaState;

    protected Float ouvertureHorizontale;

    protected Float ouvertureVerticale;

    protected boolean geometrieMesuree;

    protected Float longueurFunes;

    protected Float longueurBras;

    protected boolean systemeFermetureCul;

    protected boolean traitRectiligne;

    protected Float distanceChalutee;

    protected Float duree;

    protected boolean traitValid;

    protected String localite;

    protected String comment;

    protected List<UserBean> saisisseur;

    protected Float gearShootingStartSurfaceTemperature;

    protected Float gearShootingEndSurfaceTemperature;

    protected Float gearShootingStartBottomTemperature;

    protected Float gearShootingEndBottomTemperature;

    protected Float averageBottomTemperature;

    protected Float gearShootingStartSurfaceSalinity;

    protected Float gearShootingEndSurfaceSalinity;

    protected Float gearShootingStartBottomSalinity;

    protected Float gearShootingEndBottomSalinity;

    protected Float averageBottomSalinity;

    public boolean isEmpty() {
        return empty;
    }

    public void setEmpty(boolean empty) {
        Object oldValue = isEmpty();
        this.empty = empty;
        firePropertyChange(PROPERTY_EMPTY, oldValue, empty);
    }

    public CampaignBean getCampaign() {
        return campaign;
    }

    public void setCampaign(CampaignBean campaign) {
        this.campaign = campaign;
    }

    public Integer getStationNumber() {
        return stationNumber;
    }

    public void setStationNumber(Integer stationNumber) {
        Object oldValue = getStationNumber();
        this.stationNumber = stationNumber;
        firePropertyChange(PROPERTY_STATION_NUMBER, oldValue, stationNumber);
    }

    public Integer getTraitNumber() {
        return traitNumber;
    }

    public void setTraitNumber(Integer traitNumber) {
        Object oldValue = getTraitNumber();
        this.traitNumber = traitNumber;
        firePropertyChange(PROPERTY_TRAIT_NUMBER, oldValue, traitNumber);
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        Object oldValue = getDate();
        this.date = date;
        firePropertyChange(PROPERTY_DATE, oldValue, date);
    }

    public StrataBean getStrata() {
        return strata;
    }

    public void setStrata(StrataBean strata) {
        Object oldValue = getStrata();
        this.strata = strata;
        firePropertyChange(PROPERTY_STRATA, oldValue, strata);
    }

    public Float getGearShootingStartLatitude() {
        return gearShootingStartLatitude;
    }

    public void setGearShootingStartLatitude(Float gearShootingStartLatitude) {
        Object oldValue = getGearShootingStartLatitude();
        this.gearShootingStartLatitude = gearShootingStartLatitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LATITUDE, oldValue, gearShootingStartLatitude);
    }

    public Float getGearShootingStartLongitude() {
        return gearShootingStartLongitude;
    }

    public void setGearShootingStartLongitude(Float gearShootingStartLongitude) {
        Object oldValue = getGearShootingStartLongitude();
        this.gearShootingStartLongitude = gearShootingStartLongitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_LONGITUDE, oldValue, gearShootingStartLongitude);
    }

    public Date getGearShootingStartTime() {
        return gearShootingStartTime;
    }

    public void setGearShootingStartTime(Date gearShootingStartTime) {
        Object oldValue = getGearShootingStartTime();
        this.gearShootingStartTime = gearShootingStartTime;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_TIME, oldValue, gearShootingStartTime);
    }

    public Float getGearShootingStartDepth() {
        return gearShootingStartDepth;
    }

    public void setGearShootingStartDepth(Float gearShootingStartDepth) {
        Object oldValue = getGearShootingStartDepth();
        this.gearShootingStartDepth = gearShootingStartDepth;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_DEPTH, oldValue, gearShootingStartDepth);
    }

    public Float getGearShootingEndLatitude() {
        return gearShootingEndLatitude;
    }

    public void setGearShootingEndLatitude(Float gearShootingEndLatitude) {
        Object oldValue = getGearShootingEndLatitude();
        this.gearShootingEndLatitude = gearShootingEndLatitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LATITUDE, oldValue, gearShootingEndLatitude);
    }

    public Float getGearShootingEndLongitude() {
        return gearShootingEndLongitude;
    }

    public void setGearShootingEndLongitude(Float gearShootingEndLongitude) {
        Object oldValue = getGearShootingEndLongitude();
        this.gearShootingEndLongitude = gearShootingEndLongitude;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_LONGITUDE, oldValue, gearShootingEndLongitude);
    }

    public Date getGearShootingEndTime() {
        return gearShootingEndTime;
    }

    public void setGearShootingEndTime(Date gearShootingEndTime) {
        Object oldValue = getGearShootingEndTime();
        this.gearShootingEndTime = gearShootingEndTime;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_TIME, oldValue, gearShootingEndTime);
    }

    public Float getGearShootingEndDepth() {
        return gearShootingEndDepth;
    }

    public void setGearShootingEndDepth(Float gearShootingEndDepth) {
        Object oldValue = getGearShootingEndDepth();
        this.gearShootingEndDepth = gearShootingEndDepth;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_DEPTH, oldValue, gearShootingEndDepth);
    }

    public BeaufortScaleBean getBeaufortScale() {
        return beaufortScale;
    }

    public void setBeaufortScale(BeaufortScaleBean beaufortScale) {
        Object oldValue = getBeaufortScale();
        this.beaufortScale = beaufortScale;
        firePropertyChange(PROPERTY_BEAUFORT_SCALE, oldValue, beaufortScale);
    }

    public Integer getWindDirection() {
        return windDirection;
    }

    public void setWindDirection(Integer windDirection) {
        Object oldValue = getWindDirection();
        this.windDirection = windDirection;
        firePropertyChange(PROPERTY_WIND_DIRECTION, oldValue, windDirection);
    }

    public SeaStateBean getSeaState() {
        return seaState;
    }

    public void setSeaState(SeaStateBean seaState) {
        Object oldValue = getSeaState();
        this.seaState = seaState;
        firePropertyChange(PROPERTY_SEA_STATE, oldValue, seaState);
    }

    public Float getOuvertureHorizontale() {
        return ouvertureHorizontale;
    }

    public void setOuvertureHorizontale(Float ouvertureHorizontale) {
        Object oldValue = getOuvertureHorizontale();
        this.ouvertureHorizontale = ouvertureHorizontale;
        firePropertyChange(PROPERTY_OUVERTURE_HORIZONTALE, oldValue, ouvertureHorizontale);
    }

    public Float getOuvertureVerticale() {
        return ouvertureVerticale;
    }

    public void setOuvertureVerticale(Float ouvertureVerticale) {
        Object oldValue = getOuvertureVerticale();
        this.ouvertureVerticale = ouvertureVerticale;
        firePropertyChange(PROPERTY_OUVERTURE_VERTICALE, oldValue, ouvertureVerticale);
    }

    public boolean isGeometrieMesuree() {
        return geometrieMesuree;
    }

    public void setGeometrieMesuree(boolean geometrieMesuree) {
        Object oldValue = isGeometrieMesuree();
        this.geometrieMesuree = geometrieMesuree;
        firePropertyChange(PROPERTY_GEOMETRIE_MESUREE, oldValue, geometrieMesuree);
    }

    public Float getLongueurFunes() {
        return longueurFunes;
    }

    public void setLongueurFunes(Float longueurFunes) {
        Object oldValue = getLongueurFunes();
        this.longueurFunes = longueurFunes;
        firePropertyChange(PROPERTY_LONGUEUR_FUNES, oldValue, longueurFunes);
    }

    public Float getLongueurBras() {
        return longueurBras;
    }

    public void setLongueurBras(Float longueurBras) {
        Object oldValue = getLongueurBras();
        this.longueurBras = longueurBras;
        firePropertyChange(PROPERTY_LONGUEUR_BRAS, oldValue, longueurBras);
    }

    public boolean isSystemeFermetureCul() {
        return systemeFermetureCul;
    }

    public void setSystemeFermetureCul(boolean systemeFermetureCul) {
        Object oldValue = isSystemeFermetureCul();
        this.systemeFermetureCul = systemeFermetureCul;
        firePropertyChange(PROPERTY_SYSTEME_FERMETURE_CUL, oldValue, systemeFermetureCul);
    }

    public boolean isTraitRectiligne() {
        return traitRectiligne;
    }

    public void setTraitRectiligne(boolean traitRectiligne) {
        Object oldValue = isTraitRectiligne();
        this.traitRectiligne = traitRectiligne;
        firePropertyChange(PROPERTY_TRAIT_RECTILIGNE, oldValue, traitRectiligne);
    }

    public Float getDistanceChalutee() {
        return distanceChalutee;
    }

    public void setDistanceChalutee(Float distanceChalutee) {
        Object oldValue = getDistanceChalutee();
        this.distanceChalutee = distanceChalutee;
        firePropertyChange(PROPERTY_DISTANCE_CHALUTEE, oldValue, distanceChalutee);
    }

    public Float getDuree() {
        return duree;
    }

    public void setDuree(Float duree) {
        Object oldValue = getDuree();
        this.duree = duree;
        firePropertyChange(PROPERTY_DUREE, oldValue, duree);
    }

    public boolean isTraitValid() {
        return traitValid;
    }

    public void setTraitValid(boolean traitValid) {
        Object oldValue = isTraitValid();
        this.traitValid = traitValid;
        firePropertyChange(PROPERTY_TRAIT_VALID, oldValue, traitValid);
    }

    public String getLocalite() {
        return localite;
    }

    public void setLocalite(String localite) {
        Object oldValue = getLocalite();
        this.localite = localite;
        firePropertyChange(PROPERTY_LOCALITE, oldValue, localite);
    }

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        Object oldValue = getComment();
        this.comment = comment;
        firePropertyChange(PROPERTY_COMMENT, oldValue, comment);
    }

    public List<UserBean> getSaisisseur() {
        return saisisseur;
    }

    public void setSaisisseur(List<UserBean> saisisseur) {
        this.saisisseur = saisisseur;
        firePropertyChange(PROPERTY_SAISISSEUR, null, saisisseur);
    }

    public Float getGearShootingStartSurfaceTemperature() {
        return gearShootingStartSurfaceTemperature;
    }

    public void setGearShootingStartSurfaceTemperature(Float gearShootingStartSurfaceTemperature) {
        Object oldValue = getGearShootingStartSurfaceTemperature();
        this.gearShootingStartSurfaceTemperature = gearShootingStartSurfaceTemperature;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_SURFACE_TEMPERATURE, oldValue, gearShootingStartSurfaceTemperature);
    }

    public Float getGearShootingEndSurfaceTemperature() {
        return gearShootingEndSurfaceTemperature;
    }

    public void setGearShootingEndSurfaceTemperature(Float gearShootingEndSurfaceTemperature) {
        Object oldValue = getGearShootingEndSurfaceTemperature();
        this.gearShootingEndSurfaceTemperature = gearShootingEndSurfaceTemperature;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_SURFACE_TEMPERATURE, oldValue, gearShootingEndSurfaceTemperature);
    }

    public Float getGearShootingStartBottomTemperature() {
        return gearShootingStartBottomTemperature;
    }

    public void setGearShootingStartBottomTemperature(Float gearShootingStartBottomTemperature) {
        Object oldValue = getGearShootingStartBottomTemperature();
        this.gearShootingStartBottomTemperature = gearShootingStartBottomTemperature;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_BOTTOM_TEMPERATURE, oldValue, gearShootingStartBottomTemperature);
    }

    public Float getGearShootingEndBottomTemperature() {
        return gearShootingEndBottomTemperature;
    }

    public void setGearShootingEndBottomTemperature(Float gearShootingEndBottomTemperature) {
        Object oldValue = getGearShootingEndBottomTemperature();
        this.gearShootingEndBottomTemperature = gearShootingEndBottomTemperature;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_BOTTOM_TEMPERATURE, oldValue, gearShootingEndBottomTemperature);
    }

    public Float getAverageBottomTemperature() {
        return averageBottomTemperature;
    }

    public void setAverageBottomTemperature(Float averageBottomTemperature) {
        Object oldValue = getAverageBottomTemperature();
        this.averageBottomTemperature = averageBottomTemperature;
        firePropertyChange(PROPERTY_AVERAGE_BOTTOM_TEMPERATURE, oldValue, averageBottomTemperature);
    }

    public Float getGearShootingStartSurfaceSalinity() {
        return gearShootingStartSurfaceSalinity;
    }

    public void setGearShootingStartSurfaceSalinity(Float gearShootingStartSurfaceSalinity) {
        Object oldValue = getGearShootingStartSurfaceSalinity();
        this.gearShootingStartSurfaceSalinity = gearShootingStartSurfaceSalinity;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_SURFACE_SALINITY, oldValue, gearShootingStartSurfaceSalinity);
    }

    public Float getGearShootingEndSurfaceSalinity() {
        return gearShootingEndSurfaceSalinity;
    }

    public void setGearShootingEndSurfaceSalinity(Float gearShootingEndSurfaceSalinity) {
        Object oldValue = getGearShootingEndSurfaceSalinity();
        this.gearShootingEndSurfaceSalinity = gearShootingEndSurfaceSalinity;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_SURFACE_SALINITY, oldValue, gearShootingEndSurfaceSalinity);
    }

    public Float getGearShootingStartBottomSalinity() {
        return gearShootingStartBottomSalinity;
    }

    public void setGearShootingStartBottomSalinity(Float gearShootingStartBottomSalinity) {
        Object oldValue = getGearShootingStartBottomSalinity();
        this.gearShootingStartBottomSalinity = gearShootingStartBottomSalinity;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_START_BOTTOM_SALINITY, oldValue, gearShootingStartBottomSalinity);
    }

    public Float getGearShootingEndBottomSalinity() {
        return gearShootingEndBottomSalinity;
    }

    public void setGearShootingEndBottomSalinity(Float gearShootingEndBottomSalinity) {
        Object oldValue = getGearShootingEndBottomSalinity();
        this.gearShootingEndBottomSalinity = gearShootingEndBottomSalinity;
        firePropertyChange(PROPERTY_GEAR_SHOOTING_END_BOTTOM_SALINITY, oldValue, gearShootingEndBottomSalinity);
    }

    public Float getAverageBottomSalinity() {
        return averageBottomSalinity;
    }

    public void setAverageBottomSalinity(Float averageBottomSalinity) {
        Object oldValue = getAverageBottomSalinity();
        this.averageBottomSalinity = averageBottomSalinity;
        firePropertyChange(PROPERTY_AVERAGE_BOTTOM_SALINITY, oldValue, averageBottomSalinity);
    }

    public void fromBean(TraitBean bean) {
        BinderFactory.newBinder(TraitBean.class,
                                TraitTabUIModel.class).copy(bean, this);
    }

    public TraitBean toBean() {
        TraitBean result = new TraitBean();
        BinderFactory.newBinder(TraitTabUIModel.class,
                                TraitBean.class).copy(this, result);
        return result;
    }
}