package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosTableModel.java 20 2012-11-26 10:27:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/catches/BenthosTableModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.CatchBean;

import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class BenthosTableModel extends AbstractTableModel {

    private static final long serialVersionUID = 1L;

    protected List<CatchBean> data;

    protected final TableColumnModel columnModel;

    public BenthosTableModel(TableColumnModel columnModel) {
        this.columnModel = columnModel;
    }

    public void setData(List<CatchBean> data) {
        if (data == null) {
            data = Lists.newArrayList();
            data.add(new CatchBean());
        }
        this.data = data;
        fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return data == null ? 0 : data.size();
    }

    @Override
    public int getColumnCount() {
        return columnModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }
}