package fr.ifremer.tutti.ui.swing.content.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: BenthosTabUIModel.java 20 2012-11-26 10:27:11Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-0.1/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/catches/BenthosTabUIModel.java $
 * %%
 * Copyright (C) 2012 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.CatchBean;
import fr.ifremer.tutti.persistence.entities.TraitBean;
import org.jdesktop.beans.AbstractSerializableBean;
import org.nuiton.util.beans.BinderFactory;

import java.util.List;

/**
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class BenthosTabUIModel extends AbstractSerializableBean {

    private static final long serialVersionUID = 1L;

    public static final String PROPERTY_TOTAL_WEIGHT = "totalWeight";

    public static final String PROPERTY_SAMPLE_TOTAL_WEIGHT = "sampleTotalWeight";

    public static final String PROPERTY_CATCHES = "catches";

    protected Float totalWeight;

    protected Float sampleTotalWeight;

    protected List<CatchBean> catches;

    public Float getTotalWeight() {
        return totalWeight;
    }

    public void setTotalWeight(Float totalWeight) {
        Object oldValue = getTotalWeight();
        this.totalWeight = totalWeight;
        firePropertyChange(PROPERTY_TOTAL_WEIGHT, oldValue, totalWeight);
    }

    public Float getSampleTotalWeight() {
        return sampleTotalWeight;
    }

    public void setSampleTotalWeight(Float sampleTotalWeight) {
        Object oldValue = getSampleTotalWeight();
        this.sampleTotalWeight = sampleTotalWeight;
        firePropertyChange(PROPERTY_SAMPLE_TOTAL_WEIGHT, oldValue, sampleTotalWeight);
    }

    public List<CatchBean> getCatches() {
        return catches;
    }

    public void setCatches(List<CatchBean> catches) {
        Object oldValue = getCatches();
        this.catches = catches;
        firePropertyChange(PROPERTY_CATCHES, oldValue, catches);
    }

    public void fromBean(TraitBean bean) {
        BinderFactory.newBinder(TraitBean.class,
                                BenthosTabUIModel.class).copy(bean, this);
    }

    public TraitBean toBean() {
        TraitBean result = new TraitBean();
        BinderFactory.newBinder(BenthosTabUIModel.class,
                                TraitBean.class).copy(this, result);
        return result;
    }
}