/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.nuiton.topia.persistence.TopiaEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuiviObsmerPropertyChangeListener
implements PropertyChangeListener {
    private static final Logger log = LoggerFactory.getLogger(SuiviObsmerPropertyChangeListener.class);
    private Map<String, Object> data;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("property change : old = " + evt.getOldValue() + " _ new = " + evt.getNewValue());
        }
        TopiaEntity entity = (TopiaEntity)evt.getSource();
        this.getData().put(entity.getTopiaId(), entity);
    }

    protected Map<String, Object> getData() {
        if (this.data == null) {
            this.data = new HashMap();
        }
        return this.data;
    }

    public boolean hasChanged(String topiaId) {
        if (log.isTraceEnabled()) {
            log.trace("data size : " + this.getData().size());
        }
        return this.getData().containsKey(topiaId);
    }

    public void reset() {
        this.data = null;
    }
}

