/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerBusinessException;
import fr.ifremer.suiviobsmer.SuiviObsmerContext;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.ContactFilter;
import fr.ifremer.suiviobsmer.bean.ContactFilterImpl;
import fr.ifremer.suiviobsmer.bean.ContactState;
import fr.ifremer.suiviobsmer.bean.ImportResults;
import fr.ifremer.suiviobsmer.entity.Boat;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.SampleRow;
import fr.ifremer.suiviobsmer.entity.WaoUser;
import fr.ifremer.suiviobsmer.services.ServiceBoat;
import fr.ifremer.suiviobsmer.services.ServiceContact;
import fr.ifremer.suiviobsmer.services.ServiceSampling;
import fr.ifremer.suiviobsmer.ui.base.AbstractFilteredPage;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import fr.ifremer.suiviobsmer.ui.data.BusinessUtils;
import fr.ifremer.suiviobsmer.ui.data.ContactDataSource;
import fr.ifremer.suiviobsmer.ui.services.ContactModelFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.corelib.components.Form;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.services.BeanModelSource;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.nuiton.util.DateUtils;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/contacts.css"})
public class Contacts
extends AbstractFilteredPage
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @SessionState
    @Property
    private WaoUser user;
    @Inject
    private ServiceContact serviceContact;
    @Inject
    private ServiceSampling serviceSampling;
    @Inject
    private ServiceBoat serviceBoat;
    @Persist
    private ContactFilter contactFilter;
    @InjectComponent
    private Zone filtersZone;
    @InjectComponent
    private Zone importExportZone;
    @Property
    private boolean filtersVisible;
    private boolean reset;
    @Property
    private ContactState stateFilter;
    @Property
    private UploadedFile contactsCsvFile;
    @Inject
    private BeanModelSource beanModelSource;
    @Inject
    private ComponentResources resources;
    @Inject
    private ContactModelFactory contactModelFactory;
    @Persist
    private ContactDataSource contacts;
    @Property
    private Contact contact;
    private BeanModel<Contact> contactModel;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<WaoUser> userSelectModel;
    @Property
    @Persist(value="flash")
    private String contactUserId;
    private ContactState contactState;
    private boolean even = true;
    private boolean edited;
    private boolean deleted;
    @Persist
    @Property
    private Contact contactEdited;
    @Persist
    private String oldComment;
    @Persist(value="flash")
    private String contactSelectedId;
    @InjectComponent
    private Form contactsForm;
    @InjectComponent
    private Zone gridZone;
    @InjectComponent
    private Field beginDate;
    @InjectComponent
    private Field endDate;
    @InjectComponent
    private Field nbObservants;
    @InjectComponent
    private Field comment;
    @InjectComponent
    private Field inputDate;

    public boolean isOnlyForAdmin() {
        return false;
    }

    @Log
    void setupRender() throws SuiviObsmerException {
        boolean companyFiltered;
        if (this.log.isDebugEnabled()) {
            this.log.debug("RESET DATA");
        }
        this.initSelectFilters(true, true);
        this.contacts = null;
        this.getContacts();
        String boatName = this.getFilter().getBoatName();
        boolean bl = companyFiltered = this.getFilter().getCompany() != null && this.user.getAdmin();
        if ((this.getContactFilter().isFiltered() || companyFiltered) && StringUtils.isEmpty((String)boatName)) {
            this.filtersVisible = true;
        }
        this.contactsForm.clearErrors();
    }

    public ContactFilter getContactFilter() throws SuiviObsmerException {
        if (this.contactFilter == null) {
            this.contactFilter = new ContactFilterImpl();
            Date fromDate = DateUtils.createDateAfterToday((int)0, (int)-3, (int)0);
            this.contactFilter.setFromDate(fromDate);
        }
        return this.contactFilter;
    }

    protected BoatFilter getFilter() throws SuiviObsmerException {
        return this.getContactFilter();
    }

    protected boolean getAvailableDataForFiltersOnly() {
        return true;
    }

    Object onActionFromShowFilters() {
        this.contactFilter = null;
        return this.filtersZone.getBody();
    }

    Object onActionFromShowImportExport() {
        return this.importExportZone.getBody();
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    @Log
    Object onSuccessFromFiltersForm() throws SuiviObsmerException {
        if (this.isEdited()) {
            return this.filtersZone.getBody();
        }
        if (this.reset) {
            this.contactFilter = null;
        }
        return this;
    }

    @Log
    void onSuccessFromImportContacts() throws SuiviObsmerException {
        try {
            ImportResults result = this.serviceContact.importContactCsv(this.user, this.contactsCsvFile.getStream());
            this.contacts = null;
            this.layout.getFeedBack().addInfo(result.getNbRowsImported() + " contacts import\u00e9s,  " + result.getNbRowsRefused() + " refus\u00e9s.");
            for (String error : result.getErrors()) {
                this.layout.getFeedBack().addInfo(error);
            }
        }
        catch (SuiviObsmerBusinessException eee) {
            this.layout.getFeedBack().addError(eee.getMessage());
        }
    }

    StreamResponse onActionFromExportShowContacts() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public ContactDataSource getContacts() throws SuiviObsmerException {
        if (this.contacts == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("Create DataSource");
            }
            this.contacts = new ContactDataSource(this.getContactFilter(), this.serviceContact);
        }
        return this.contacts;
    }

    public BeanModel<Contact> getContactModel() {
        if (this.contactModel == null) {
            this.contactModel = this.user.getAdmin() ? this.contactModelFactory.buildAdminContactModel(this.beanModelSource, this.resources) : this.contactModelFactory.buildContactModel(this.beanModelSource, this.resources);
        }
        return this.contactModel;
    }

    public ContactState getContactState() {
        if (this.contactState == null) {
            this.contactState = ContactState.createContactStateEnum((String)this.contactEdited.getState());
        }
        return this.contactState;
    }

    public GenericSelectModel<WaoUser> getUserSelectModel() {
        if (this.userSelectModel == null) {
            List users = this.user.getCompany().getWaoUser();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Nb users : " + users.size());
            }
            this.userSelectModel = new GenericSelectModel(users, WaoUser.class, "fullName", "id", this.propertyAccess);
        }
        return this.userSelectModel;
    }

    public void setContactState(ContactState contactState) {
        this.contactState = contactState;
    }

    public String getCommentDisplayed() {
        if (this.contact.getComment() != null && this.contact.getComment().length() > 20) {
            return this.contact.getComment().substring(0, 20) + "...";
        }
        return this.contact.getComment();
    }

    public String getCommentTooltip() {
        return this.contact.getComment().replaceAll("\n", "<br />").replaceAll("\r", "");
    }

    public String getSampleRowDescription() {
        return BusinessUtils.getTooltipSampleRow((SampleRow)this.contact.getSampleRow());
    }

    public String getBoatDescription() {
        return BusinessUtils.getTooltipBoat((Boat)this.contact.getBoat());
    }

    public String getTooltipExportFrom() throws SuiviObsmerException {
        if (this.getContactFilter().getFromDate() != null) {
            return "depuis le " + this.getDateFormat().format(this.getContactFilter().getFromDate());
        }
        return "";
    }

    public String getGridClass() {
        return this.user.getAdmin() ? "admin" : "user";
    }

    public String getRowClass() {
        String result = BusinessUtils.getContactStyle((Contact)this.contact, (boolean)this.user.getAdmin());
        if (this.contact.getTopiaId().equals(this.contactSelectedId)) {
            result = "selected";
        }
        return result;
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("dd/MM/yyyy");
    }

    public boolean isEditionMode() {
        return this.contactEdited != null && this.contact.equals(this.contactEdited);
    }

    public boolean isEmpty(Boolean validation) {
        return validation == null;
    }

    public void prepareContactEdited(String contactId) throws SuiviObsmerException {
        if (this.contactEdited == null) {
            this.contactEdited = (Contact)this.getContacts().get((Object)contactId);
        }
    }

    public boolean hasActions() {
        return !this.user.getAdmin() && this.contact.getValidationCompany() == null;
    }

    public boolean canValidate() {
        boolean boardingDone;
        if (this.isEditionMode()) {
            return false;
        }
        ContactState state = ContactState.createContactStateEnum((String)this.contact.getState());
        boolean bl = boardingDone = state.equals((Object)ContactState.BOARDING_DONE) && this.contact.getDataInputDate() != null;
        if (!this.user.getAdmin()) {
            return this.contact.getValidationCompany() == null && (state.isUnfinishedState() || boardingDone);
        }
        return this.contact.getValidationProgram() == null && BooleanUtils.isTrue((Boolean)this.contact.getValidationCompany());
    }

    public boolean canUnvalidate() {
        if (!this.user.getAdmin()) {
            return this.contact.getValidationCompany() != null && this.contact.getValidationProgram() == null;
        }
        return this.contact.getValidationProgram() != null;
    }

    void onSelectedFromAcceptContact(String contactId) throws SuiviObsmerException {
        this.prepareContactEdited(contactId);
        if (this.user.getAdmin()) {
            this.contactEdited.setValidationProgram(Boolean.TRUE);
        } else {
            this.contactEdited.getSampleRow().addRealTideTime(this.contactEdited);
            this.contactEdited.setValidationCompany(Boolean.TRUE);
        }
    }

    void onSelectedFromRefuseContact(String contactId) throws SuiviObsmerException {
        this.prepareContactEdited(contactId);
        if (this.user.getAdmin()) {
            this.contactEdited.getSampleRow().removeRealTideTime(this.contactEdited);
            this.contactEdited.setValidationProgram(Boolean.FALSE);
        } else {
            this.contactEdited.setValidationCompany(Boolean.FALSE);
        }
    }

    void onSelectedFromUnvalidateContact(String contactId) throws SuiviObsmerException {
        this.prepareContactEdited(contactId);
        if (this.user.getAdmin()) {
            if (BooleanUtils.isFalse((Boolean)this.contactEdited.getValidationProgram())) {
                this.contactEdited.getSampleRow().addRealTideTime(this.contactEdited);
            }
            this.contactEdited.setValidationProgram(null);
        } else {
            if (BooleanUtils.isTrue((Boolean)this.contactEdited.getValidationCompany())) {
                this.contactEdited.getSampleRow().removeRealTideTime(this.contactEdited);
            }
            this.contactEdited.setValidationCompany(null);
        }
    }

    void onSelectedFromEditContact(String contactId) throws SuiviObsmerException {
        this.prepareContactEdited(contactId);
        this.contactUserId = this.contactEdited.getObserver().getTopiaId();
        this.contactSelectedId = contactId;
        this.oldComment = this.contactEdited.getComment();
        this.edited = true;
    }

    void onSelectedFromDeleteContact(String contactId) throws SuiviObsmerException {
        this.prepareContactEdited(contactId);
        this.deleted = true;
    }

    void onSelectedFromSaveContact(String contactId) throws SuiviObsmerException {
        this.prepareContactEdited(contactId);
        this.contactEdited.setState(this.contactState.toString());
        WaoUser contactUser = (WaoUser)this.getUserSelectModel().findObject(this.contactUserId);
        this.contactEdited.setObserver(contactUser);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Comment : " + this.contactEdited.getComment());
        }
    }

    void onSelectedFromCancelEditContact() throws SuiviObsmerException {
        this.contactEdited = null;
        this.edited = true;
    }

    @Log
    void onValidateFormFromContactsForm() {
        this.contactsForm.clearErrors();
        if (!this.edited && this.contactState != null) {
            if (this.log.isInfoEnabled()) {
                this.log.info("For state : " + this.contactState);
            }
            Date begin = this.contactEdited.getTideBeginDate();
            Date end = this.contactEdited.getTideEndDate();
            Date input = this.contactEdited.getDataInputDate();
            SampleRow row = this.contactEdited.getSampleRow();
            if (begin != null && !row.isValid(begin)) {
                this.contactsForm.recordError(this.beginDate, "La date de d\u00e9but de la mar\u00e9e doit correspondre \u00e0 un mois valide (non vide) de la ligne " + row.getCode());
            }
            if (begin != null && end != null && end.before(begin)) {
                this.contactsForm.recordError(this.endDate, "La date de fin de la mar\u00e9e ne peut pas \u00eatre ant\u00e9rieure \u00e0 celle de d\u00e9but");
            }
            Date current = SuiviObsmerContext.getCurrentDate();
            if (end != null && end.after(current)) {
                this.contactsForm.recordError(this.endDate, "La date de fin de la mar\u00e9e ne peut pas \u00eatre post\u00e9rieure \u00e0 la date du jour");
            }
            if (end != null && input != null && end.after(input)) {
                this.contactsForm.recordError(this.inputDate, "La date de saisie des donn\u00e9es ne peut pas \u00eatre ant\u00e9rieure \u00e0 la date de fin de la mar\u00e9e");
            }
            if (input != null && input.after(current)) {
                this.contactsForm.recordError(this.inputDate, "La date de saisie des donn\u00e9es ne peut pas \u00eatre post\u00e9rieure \u00e0 la date du jour");
            }
            if (this.contactState.isUnfinishedState()) {
                if (this.oldComment != null && StringUtils.isNotEmpty((String)this.contactEdited.getComment()) && !this.oldComment.equals(this.contactEdited.getComment())) {
                    this.contactEdited.setTideBeginDate(null);
                    this.contactEdited.setTideEndDate(null);
                    this.contactEdited.setNbObservants(0);
                    this.contactEdited.setMammalsCapture(false);
                    this.contactEdited.setMammalsObservation(false);
                    this.contactEdited.setDataInputDate(null);
                } else {
                    this.contactsForm.recordError(this.comment, "Vous devez ajouter un commentaire pour l'\u00e9tat '" + this.contactState + "'");
                }
            } else if (this.contactState.equals((Object)ContactState.BOARDING_DONE)) {
                if (begin == null) {
                    this.contactsForm.recordError(this.beginDate, "La date de d\u00e9but de mar\u00e9e est obligatoire pour l'\u00e9tat '" + this.contactState + "'");
                }
                if (end == null) {
                    this.contactsForm.recordError(this.endDate, "La date de fin de mar\u00e9e est obligatoire pour l'\u00e9tat '" + this.contactState + "'");
                }
                if (this.contactEdited.getNbObservants() == 0) {
                    this.contactsForm.recordError(this.nbObservants, "Il ne peut y avoir aucun observateur pour l'\u00e9tat '" + this.contactState + "'");
                }
            }
        }
    }

    @Log
    Object onSuccessFromContactsForm() {
        if (!this.edited) {
            try {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Contact save : " + this.contactEdited);
                }
                this.serviceContact.saveContact(this.contactEdited, this.deleted);
                this.contactSelectedId = this.contactEdited.getTopiaId();
                this.oldComment = null;
                this.contactEdited = null;
            }
            catch (SuiviObsmerException eee) {
                this.layout.getFeedBack().addError(eee.getMessage());
            }
        }
        return this;
    }

    @Log
    Object onFailureFromContactsForm() {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Contact can't be saved with errors");
        }
        this.edited = true;
        return this.contactsForm;
    }

    public void createNewContact(Boat boat, SampleRow sampleRow) throws SuiviObsmerException {
        this.contact = this.serviceContact.getNewContact(this.user, sampleRow, boat);
        this.serviceContact.saveContact(this.contact, Boolean.FALSE.booleanValue());
        this.contactSelectedId = this.contact.getTopiaId();
    }

    static /* synthetic */ WaoUser access$000(Contacts x0) {
        return x0.user;
    }

    static /* synthetic */ ServiceContact access$100(Contacts x0) {
        return x0.serviceContact;
    }
}

