/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.BoatFilter;
import fr.ifremer.suiviobsmer.bean.BoatFilterImpl;
import fr.ifremer.suiviobsmer.bean.SamplingFilter;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.services.ServiceSynthesis;
import fr.ifremer.suiviobsmer.ui.base.AbstractFilteredPage;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.data.BusinessUtils;
import fr.ifremer.suiviobsmer.ui.data.ChartUtils;
import java.util.HashMap;
import java.util.List;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.annotations.SessionState;
import org.apache.tapestry5.corelib.components.Zone;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.jfree.chart.JFreeChart;
import org.nuiton.util.PeriodDates;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/synthesis.css"})
public class Synthesis
extends AbstractFilteredPage
implements SuiviObsmerPage {
    @Inject
    private ServiceSynthesis serviceSynthesis;
    @Inject
    private Logger log;
    @SessionState
    @Property
    private User user;
    @Persist
    private BoatFilter dataSamplingFilter;
    @InjectComponent
    private Zone sampleRowZone;
    @InjectComponent
    private Zone observerZone;
    @Persist
    private ChartUtils.ChartType dataSamplingChartType;
    private boolean reset;

    public boolean isOnlyForAdmin() {
        return false;
    }

    void setupRender() throws SuiviObsmerException {
        this.initFilter();
    }

    public BoatFilter getFilter() throws SuiviObsmerException {
        if (this.dataSamplingFilter == null) {
            this.dataSamplingFilter = new BoatFilterImpl();
            if (!this.user.getAdmin()) {
                this.dataSamplingFilter.setCompany(this.user.getCompany());
            }
            PeriodDates period = PeriodDates.createMonthsPeriodFromToday((int)-12);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Period : " + period);
            }
            this.dataSamplingFilter.setPeriod(period);
        }
        return this.dataSamplingFilter;
    }

    protected void resetFilter() {
        this.dataSamplingFilter = null;
    }

    protected boolean getAvailableDataForFiltersOnly() {
        return false;
    }

    public JFreeChart getDataSamplingChart() throws SuiviObsmerException {
        if (this.log.isInfoEnabled()) {
            this.log.info("BUSINESS REQUEST [getDataSampling]");
        }
        List res = this.serviceSynthesis.getDataSampling((SamplingFilter)this.getFilter());
        HashMap data = new HashMap();
        data.put("Donn\u00e9es pr\u00e9vus", res.get(0));
        data.put("Donn\u00e9es r\u00e9els", res.get(1));
        String title = BusinessUtils.getDataSamplingTitle((SamplingFilter)this.getFilter());
        return ChartUtils.createCategoryChart((String)title, (String)"Nb mar\u00e9es", (ChartUtils.ChartType)this.getDataSamplingChartType(), data);
    }

    public ChartUtils.ChartType getDataSamplingChartType() {
        if (this.dataSamplingChartType == null) {
            this.dataSamplingChartType = ChartUtils.ChartType.BAR;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("ChartType : " + this.dataSamplingChartType);
        }
        return this.dataSamplingChartType;
    }

    void onActionFromSetDataSamplingChartBarType() {
        this.dataSamplingChartType = ChartUtils.ChartType.BAR;
    }

    void onActionFromSetDataSamplingChartAreaType() {
        this.dataSamplingChartType = ChartUtils.ChartType.AREA;
    }

    void onActionFromSetDataSamplingChartLineType() {
        this.dataSamplingChartType = ChartUtils.ChartType.LINE;
    }

    void onSelectedFromReset() {
        this.reset = true;
    }

    void onSuccessFromFiltersForm() {
        if (this.reset) {
            this.resetFilter();
        }
    }
}

