/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.pages;

import fr.ifremer.suiviobsmer.SuiviObsmerBusinessException;
import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.entity.Company;
import fr.ifremer.suiviobsmer.entity.CompanyImpl;
import fr.ifremer.suiviobsmer.entity.User;
import fr.ifremer.suiviobsmer.entity.UserImpl;
import fr.ifremer.suiviobsmer.services.ServiceReferential;
import fr.ifremer.suiviobsmer.services.ServiceUser;
import fr.ifremer.suiviobsmer.ui.base.GenericSelectModel;
import fr.ifremer.suiviobsmer.ui.base.SuiviObsmerPage;
import fr.ifremer.suiviobsmer.ui.components.Layout;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.annotations.IncludeStylesheet;
import org.apache.tapestry5.annotations.InjectComponent;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Persist;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.PropertyAccess;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

@IncludeStylesheet(value={"context:css/administration.css"})
public class Administration
implements SuiviObsmerPage {
    @Inject
    private Logger log;
    @InjectComponent
    private Layout layout;
    @Inject
    private ServiceUser serviceUser;
    @Inject
    private ServiceReferential serviceReferential;
    @Inject
    private TypeCoercer typeCoercer;
    @Property
    private String companyId;
    @Property
    private String userId;
    @Persist
    private List<Company> companies;
    @Inject
    private PropertyAccess propertyAccess;
    private GenericSelectModel<Company> companiesSelectModel;
    private Company company;
    private GenericSelectModel<User> usersSelectModel;
    @Persist
    private User user;
    @Property
    private boolean generatePassword;
    @Property
    private String password;
    private boolean addNewCompanySelected;
    private boolean addNewUserSelected;
    @Property
    private UploadedFile fishingZoneCsvFile;

    public boolean isOnlyForAdmin() {
        return true;
    }

    void setupRender() {
        this.companies = null;
        this.getCompanies();
        this.user = null;
    }

    void onActivate(EventContext ec) {
        if (ec.getCount() > 0) {
            this.companyId = (String)ec.get(String.class, 0);
            if (ec.getCount() > 1) {
                this.userId = (String)ec.get(String.class, 1);
            }
        }
    }

    Object[] onPassivate() {
        return new String[]{this.companyId, this.userId};
    }

    @Log
    void onSuccessFromImportFishingZones() {
        try {
            int result = this.serviceReferential.importFishingZoneCsv(this.fishingZoneCsvFile.getStream());
            this.layout.getFeedBack().addInfo(result + " zones de p\u00eache import\u00e9s");
        }
        catch (SuiviObsmerException eee) {
            this.layout.getFeedBack().addError(eee.getMessage());
        }
    }

    public List<Company> getCompanies() {
        if (this.companies == null) {
            try {
                if (this.log.isInfoEnabled()) {
                    this.log.info("BUSINESS REQUEST [getCompanies]");
                }
                this.companies = this.serviceUser.getCompanies(false);
            }
            catch (SuiviObsmerException suiviObsmerException) {
                // empty catch block
            }
        }
        return this.companies;
    }

    public GenericSelectModel<Company> getCompaniesSelectModel() {
        if (this.companiesSelectModel == null) {
            this.companiesSelectModel = new GenericSelectModel(this.getCompanies(), Company.class, "name", "id", this.propertyAccess);
        }
        return this.companiesSelectModel;
    }

    public Company getCompany() {
        if (this.company == null) {
            this.company = this.companyId != null ? (Company)this.getCompaniesSelectModel().findObject(this.companyId) : new CompanyImpl();
        }
        return this.company;
    }

    public boolean isUsersAvailable() {
        return !StringUtils.isEmpty((String)this.getCompany().getId()) && this.getCompany().getActive();
    }

    void onSelectedFromAddNewCompany() {
        this.addNewCompanySelected = true;
    }

    void onSuccessFromActionsForm() {
        if (this.addNewCompanySelected) {
            this.companyId = null;
        }
        this.userId = null;
        this.user = null;
    }

    void onSuccessFromCompany() throws SuiviObsmerException {
        this.serviceUser.createUpdateCompany(this.company);
        this.companyId = this.company.getId();
    }

    @Log
    public GenericSelectModel<User> getUsersSelectModel() {
        if (this.usersSelectModel == null) {
            List users = this.getCompany().getUser();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Nb users : " + users.size());
            }
            this.usersSelectModel = new GenericSelectModel(users, User.class, "fullName", "id", this.propertyAccess);
        }
        return this.usersSelectModel;
    }

    @Log
    public User getUser() {
        if (this.user == null) {
            if (this.userId != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("User exist in selectModel : " + this.userId);
                }
                this.user = (User)this.getUsersSelectModel().findObject(this.userId);
            } else {
                this.user = new UserImpl();
                this.generatePassword = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Set company for new user : " + this.getCompany().getName());
                }
                this.user.setCompany(this.getCompany());
            }
        }
        return this.user;
    }

    void onSelectedFromAddNewUser() {
        this.addNewUserSelected = true;
    }

    void onSuccessFromUserActionsForm() {
        if (this.addNewUserSelected) {
            this.userId = null;
        }
    }

    @Log
    void onSuccessFromUser() throws SuiviObsmerException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("User : " + this.user);
        }
        if (!StringUtils.isEmpty((String)this.password)) {
            this.user.setPassword(this.password);
            this.user.setPasswordChanged(true);
        }
        try {
            this.serviceUser.createUpdateUser(this.user, this.generatePassword);
            this.userId = this.user.getId();
        }
        catch (SuiviObsmerBusinessException eee) {
            this.layout.getFeedBack().addError(eee.getMessage());
        }
    }
}

