/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.data;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import fr.ifremer.suiviobsmer.bean.ContactFilter;
import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.services.ServiceContact;
import fr.ifremer.suiviobsmer.ui.data.AbstractMappedGridDataSource;
import java.util.Map;
import org.apache.tapestry5.grid.SortConstraint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContactDataSource
extends AbstractMappedGridDataSource<String, Contact> {
    private static Logger log = LoggerFactory.getLogger(ContactDataSource.class);
    private ContactFilter filter;
    private ServiceContact serviceContact;

    public ContactDataSource(ContactFilter filter, ServiceContact service) {
        this.filter = filter;
        this.serviceContact = service;
    }

    public Class<?> getRowType() {
        return Contact.class;
    }

    protected Map<String, Contact> execute(int startIndex, int endIndex, SortConstraint orderBy) throws SuiviObsmerException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [getContactsByFilter]");
        }
        this.filter.setStartIndex(Integer.valueOf(startIndex));
        this.filter.setEndIndex(Integer.valueOf(endIndex));
        return this.serviceContact.getContactsByFilter(this.filter);
    }

    protected int count() throws SuiviObsmerException {
        if (log.isInfoEnabled()) {
            log.info("BUSINESS REQUEST [countContactsByFilter]");
        }
        return this.serviceContact.countContactsByFilter(this.filter);
    }
}

