/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.mixins;

/**
 * PopupPageLink
 *
 * Created: 17 janv. 2010
 *
 * @author fdesbois
 * @version $Revision: 222 $
 *
 * Mise a jour: $Date: 2010-01-17 20:49:21 +0100 (dim., 17 janv. 2010) $
 * par : $Author$
 */
import org.apache.tapestry5.BindingConstants;

import org.apache.tapestry5.ClientElement;

import org.apache.tapestry5.ComponentResources;

import org.apache.tapestry5.Link;

import org.apache.tapestry5.RenderSupport;

import org.apache.tapestry5.annotations.Environmental;

import org.apache.tapestry5.annotations.IncludeJavaScriptLibrary;

import org.apache.tapestry5.annotations.InjectContainer;

import org.apache.tapestry5.annotations.Parameter;

import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.services.PageRenderLinkSource;

@IncludeJavaScriptLibrary("context:js/dialog.js")

public class PopupPageLink {

  @Inject

  private ComponentResources resources;

  @Environmental

  private RenderSupport renderSupport;

  @InjectContainer

  private ClientElement container;

  @Parameter(required = true, defaultPrefix = BindingConstants.LITERAL)

  private String page;



  @Parameter(defaultPrefix = BindingConstants.LITERAL, value="800")

  private String width;



  @Parameter(defaultPrefix = BindingConstants.LITERAL, value="600")

  private String height;

  @Parameter

  private Object[] context;

  @Inject
  private PageRenderLinkSource pageRender;

  void afterRender() {
         Link link = null;
         if (context != null) {
             link = pageRender.createPageRenderLinkWithContext(page, context);
         } else {
             link = pageRender.createPageRenderLink(page);
         }
//    Link link = null;
//    pageRender.createPageLink(page, true, context);

    renderSupport.addScript("new PopupPageLink('%s', '%s', %s, %s);", container.getClientId(), link, width, height);

  }

}
