/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.suiviobsmer.ui.data;

import fr.ifremer.suiviobsmer.ui.data.ChartUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.RectangleInsets;

public class ChartUtils {
    public static JFreeChart createCategoryChart(String title, String axisName, ChartType type, Map<String, SortedMap<Date, Integer>> input) {
        SimpleDateFormat format = new SimpleDateFormat("MM/yyyy");
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        int i = 0;
        for (Map.Entry<String, SortedMap<Date, Integer>> map : input.entrySet()) {
            for (Map.Entry<Date, Integer> data : map.getValue().entrySet()) {
                dataset.setValue((Number)data.getValue(), (Comparable)((Object)map.getKey()), (Comparable)((Object)format.format(data.getKey())));
            }
            ++i;
        }
        CategoryAxis categoryAxis = new CategoryAxis("Mois");
        categoryAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        NumberAxis valueAxis = new NumberAxis(axisName);
        AbstractCategoryItemRenderer renderer = type.createRenderer();
        renderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)new StandardCategoryItemLabelGenerator());
        renderer.setBaseItemLabelsVisible(Boolean.TRUE);
        CategoryPlot plot = new CategoryPlot((CategoryDataset)dataset, categoryAxis, (ValueAxis)valueAxis, (CategoryItemRenderer)renderer);
        plot.setOrientation(PlotOrientation.VERTICAL);
        plot.setAxisOffset(RectangleInsets.ZERO_INSETS);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, true);
    }
}

