/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.services;

import fr.ifremer.suiviobsmer.entity.Contact;
import fr.ifremer.suiviobsmer.entity.FishingZone;
import java.lang.annotation.Annotation;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.beaneditor.BeanModel;
import org.apache.tapestry5.beaneditor.RelativePosition;
import org.apache.tapestry5.services.BeanModelSource;

/**
 * ContactModelFactory
 *
 * Created: 18 nov. 2009
 *
 * @author fdesbois
 * @version $Revision: 185 $
 *
 * Mise a jour: $Date: 2010-01-12 15:33:15 +0100 (mar. 12 janv. 2010) $
 * par : $Author: fdesbois $
 */
public class ContactModelFactory {

    /**
     * @param beanModelSource used to construct BeanModel<Contact>
     * @param resources used to construct BeanModel<Contact>
     * @return BeanModel<Contact> with new params
     */
    public BeanModel<Contact> buildContactModel(BeanModelSource beanModelSource, ComponentResources resources) {
        BeanModel<Contact> contactModel = beanModelSource.createDisplayModel(Contact.class, resources.getMessages());

        // New properties for contactModel
        contactModel.add("createdBy", null);
        contactModel.add("sampleRow", getSampleRowPropertyConduit());
        contactModel.add("boat", getBoatPropertyConduit());
        contactModel.add("mammals", null);
        contactModel.add("validation", null);
        contactModel.add("actions", null);

        contactModel.include(
                    "createdBy",
                    "topiaCreateDate",
                    "sampleRow",
                    "boat",
                    "state",
                    "tideBeginDate",
                    "tideEndDate",
                    "nbObservants",
                    "mammals",
                    "dataInputDate",
                    "comment",
                    "validation",
                    "actions");
        
        return contactModel;
    }

    public BeanModel<Contact> buildAdminContactModel(BeanModelSource beanModelSource, ComponentResources resources) {
        BeanModel<Contact> contactModel = buildContactModel(beanModelSource, resources);
        contactModel.exclude("createdBy");
        contactModel.add(RelativePosition.AFTER,"topiaCreateDate", "observer", getUserPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "observer", "company", getCompanyPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "sampleRow", "program", getProgramPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "program", "professionCode", getProfessionCodePropertyConduit());
        contactModel.add(RelativePosition.AFTER, "professionCode", "professionLibelle", getProfessionLibellePropertyConduit());
        contactModel.add(RelativePosition.AFTER, "professionLibelle", "professionSpecies", getProfessionSpeciesPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "professionSpecies", "fishingZoneFacade", getFishingZoneFacadePropertyConduit());
        contactModel.add(RelativePosition.AFTER, "fishingZoneFacade", "fishingZoneSector", getFishingZoneSectorPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "fishingZoneSector", "fishingZoneDivision", getFishingZoneDivisionPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "boat", "boatImmatriculation", getBoatImmatriculationPropertyConduit());
        contactModel.add(RelativePosition.AFTER, "boatImmatriculation", "boatDistrictCode", getBoatDistrictCodePropertyConduit());
        return contactModel;
    }

    public PropertyConduit getUserPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getUser().getFullName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }
    
    public PropertyConduit getCompanyPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getUser().getCompany().getName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    } 
    
    public PropertyConduit getSampleRowPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getCode();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getBoatPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getBoat().getName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getProgramPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getProgramName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getProfessionCodePropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getProfession().getCode();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getProfessionLibellePropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getProfession().getLibelle();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getProfessionSpeciesPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getProfession().getSpecies();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getFishingZoneFacadePropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getFirstFishingZone().getFacadeName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getFishingZoneSectorPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getSampleRow().getFirstFishingZone().getSectorName();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getFishingZoneDivisionPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    String result = "";
                    for (FishingZone zone : contact.getSampleRow().getFishingZone()) {
                        result += zone.getDistrictCode() + " ";
                    }
                    return result;
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getBoatImmatriculationPropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getBoat().getImmatriculation();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }

    public PropertyConduit getBoatDistrictCodePropertyConduit() {
        return new PropertyConduit() {
                @Override
                public Object get(Object arg0) {
                    Contact contact = (Contact)arg0;
                    return contact.getBoat().getDistrictCode();
                }

                @Override
                public void set(Object arg0, Object arg1) {
                }

                @Override
                public Class getPropertyType() {
                    return String.class;
                }

                @Override
                public <T extends Annotation> T getAnnotation(Class<T> arg0) {
                    return null;
                }
            };
    }
}
