/*
 * *##% 
 * SuiviObsmer :: Web Interface
 * Copyright (C) 2009 - 2010 Ifremer
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * ##%*
 */

package fr.ifremer.suiviobsmer.ui.data;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * BoatInfosPropertyChangeListener
 *
 * Created: 18 nov. 2009
 *
 * @author fdesbois
 * @version $Revision$
 *
 * Mise a jour: $Date$
 * par : $Author$
 */
public class SuiviObsmerPropertyChangeListener implements PropertyChangeListener {

    private static final Logger log = LoggerFactory.getLogger(SuiviObsmerPropertyChangeListener.class);

    private boolean changed;

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (log.isDebugEnabled()) {
            log.debug("property change");
        }
        changed = true;
    }

    public boolean isChanged() {
        return changed;
    }

}
