/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.map.MapDataListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class MapDataProvider {
    protected Set<MapDataListener> mapDataListeners = new HashSet<MapDataListener>();

    public abstract float getMinLongitude();

    public abstract float getMaxLongitude();

    public abstract float getMinLatitude();

    public abstract float getMaxLatitude();

    public abstract float getCellLengthLongitude();

    public abstract float getCellLengthLatitude();

    public abstract List<String> getMapFilePath();

    public abstract List<Cell> findAllByCoordinates(float var1, float var2);

    public abstract List<Cell> getCell();

    void addProviderChangeListener(MapDataListener listener) {
        this.mapDataListeners.add(listener);
    }

    void removeProviderChangeListener(MapDataListener listener) {
        this.mapDataListeners.remove(listener);
    }

    public void regionChanged() {
        ArrayList<MapDataListener> listeners = new ArrayList<MapDataListener>(this.mapDataListeners);
        for (MapDataListener listener : listeners) {
            listener.regionChanged();
        }
    }
}

