/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.IsisMapBean;
import fr.ifremer.isisfish.map.MapDataListener;
import fr.ifremer.isisfish.map.MapDataProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.event.TopiaTransactionEvent;
import org.nuiton.topia.event.TopiaTransactionListener;
import org.nuiton.topia.persistence.TopiaEntity;

public class DatabaseDataProvider
extends MapDataProvider
implements TopiaTransactionListener {
    protected IsisMapBean isisMapBean;
    protected FisheryRegion fisheryRegion;

    public DatabaseDataProvider(IsisMapBean isisMapBean, FisheryRegion fisheryRegion) {
        this.isisMapBean = isisMapBean;
        this.fisheryRegion = fisheryRegion;
        fisheryRegion.getTopiaContext().addTopiaTransactionListener((TopiaTransactionListener)this);
    }

    @Override
    public float getMinLongitude() {
        return this.fisheryRegion.getMinLongitude();
    }

    @Override
    public float getMaxLongitude() {
        return this.fisheryRegion.getMaxLongitude();
    }

    @Override
    public float getMinLatitude() {
        return this.fisheryRegion.getMinLatitude();
    }

    @Override
    public float getMaxLatitude() {
        return this.fisheryRegion.getMaxLatitude();
    }

    @Override
    public float getCellLengthLongitude() {
        return this.fisheryRegion.getCellLengthLongitude();
    }

    @Override
    public float getCellLengthLatitude() {
        return this.fisheryRegion.getCellLengthLatitude();
    }

    @Override
    public List<Cell> getCell() {
        return this.fisheryRegion.getCell();
    }

    @Override
    public List<String> getMapFilePath() {
        return this.fisheryRegion.getMapFilePath();
    }

    @Override
    public List<Cell> findAllByCoordinates(float latitude, float longitude) {
        return this.getCellDAO().findAllByProperties("latitude", Float.valueOf(latitude), new Object[]{"longitude", Float.valueOf(longitude)});
    }

    protected TopiaContext getTopiaContext() {
        TopiaContext result = this.fisheryRegion.getTopiaContext();
        if (result == null) {
            throw new IsisFishRuntimeException("Can't get topiaContext from FisheryRegion");
        }
        return result;
    }

    protected CellDAO getCellDAO() throws TopiaException {
        return IsisFishDAOHelper.getCellDAO(this.getTopiaContext());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DatabaseDataProvider that = (DatabaseDataProvider)o;
        return Objects.equals(this.isisMapBean, that.isisMapBean) && Objects.equals(this.fisheryRegion, that.fisheryRegion);
    }

    public int hashCode() {
        return Objects.hash(this.isisMapBean, this.fisheryRegion);
    }

    public void commit(TopiaTransactionEvent event) {
        for (TopiaEntity e : event.getEntities()) {
            if ((!event.isModification(e) || !Cell.class.isAssignableFrom(e.getClass())) && !FisheryRegion.class.isAssignableFrom(e.getClass())) continue;
            this.fireEvent();
            break;
        }
    }

    private void fireEvent() {
        ArrayList listeners = new ArrayList(this.mapDataListeners);
        for (MapDataListener listener : listeners) {
            listener.regionChanged();
        }
    }

    public void rollback(TopiaTransactionEvent event) {
    }
}

