/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.StrategyMonthInfoAbstract;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;

public class StrategyMonthInfoImpl
extends StrategyMonthInfoAbstract {
    private static final long serialVersionUID = 4266095355294103240L;
    private static Log log = LogFactory.getLog(StrategyMonthInfoImpl.class);

    @Override
    public FisheryRegion getFisheryRegion() {
        try {
            FisheryRegion result = RegionStorage.getFisheryRegion(this.getTopiaContext());
            return result;
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't get fishery region", eee);
        }
    }

    @Override
    public List<Metier> getMetierWithProportion() {
        ArrayList<Metier> result;
        MatrixND mat = this.getProportionMetier();
        if (mat == null) {
            result = Collections.EMPTY_LIST;
        } else {
            result = new ArrayList<Metier>(mat.getDim(0));
            MatrixIterator i = mat.iteratorNotZero();
            while (i.next()) {
                result.add((Metier)i.getSemanticsCoordinates()[0]);
            }
        }
        return result;
    }

    @Override
    public double getProportionMetier(Metier metier) {
        int indice;
        double result = 0.0;
        MatrixND mat = super.getProportionMetier();
        if (mat != null && (indice = mat.getSemantic(0).indexOf(metier)) >= 0) {
            result = mat.getValue(indice);
        }
        return result;
    }

    @Override
    public void setProportionMetier(Metier metier, double value) {
        MatrixND mat = this.getProportionMetier();
        if (mat != null) {
            mat = mat.copy();
            mat.setValue((Object)metier, value);
            this.setProportionMetier(mat);
        } else {
            log.warn((Object)"Can't set proportion of metier, not enough information available");
        }
    }

    @Override
    public MatrixND getProportionMetier() {
        if (this.getStrategy() == null || this.getStrategy().getSetOfVessels() == null || this.getStrategy().getSetOfVessels().getPossibleMetiers() == null) {
            return null;
        }
        Collection<EffortDescription> efforts = this.getStrategy().getSetOfVessels().getPossibleMetiers();
        ArrayList<Metier> metiers = new ArrayList<Metier>(efforts.size());
        for (EffortDescription effort : efforts) {
            metiers.add(effort.getPossibleMetiers());
        }
        if (metiers.size() <= 0) {
            return null;
        }
        MatrixND result = super.getProportionMetier();
        if (result == null) {
            result = MatrixFactory.getInstance().create(I18n.t((String)"isisfish.strategyMonthInfo.proportion", (Object[])new Object[0]), new List[]{metiers}, new String[]{I18n.t((String)"isisfish.strategyMonthInfo.metier", (Object[])new Object[0])});
        } else if (!result.getSemantic(0).equals(metiers)) {
            MatrixND tmp = MatrixFactory.getInstance().create(I18n.t((String)"isisfish.strategyMonthInfo.proportion", (Object[])new Object[0]), new List[]{metiers}, new String[]{I18n.t((String)"isisfish.strategyMonthInfo.metier", (Object[])new Object[0])});
            tmp.pasteSemantics(result);
            result = tmp;
        }
        return result;
    }

    @Override
    public void setTripType(TripType value) {
        super.setTripType(value);
        this.computeNumberOfTrips();
    }

    @Override
    public void setMinInactivityDays(double value) {
        super.setMinInactivityDays(value);
        this.computeNumberOfTrips();
    }

    @Override
    public double getMinInactivityDays() {
        double result = this.getStrategy().isInactivityEquationUsed() ? this.getStrategy().getInactivityDays(this.getMonth()) : super.getMinInactivityDays();
        return result;
    }

    public void computeNumberOfTrips() {
        TripType tripType = this.getTripType();
        if (this.getStrategy() != null && this.getStrategy().isInactivityEquationUsed()) {
            double inactivity = this.getMinInactivityDays();
            if (tripType != null && tripType.getTripDuration() != null && inactivity >= 0.0) {
                int nbDayMonth = this.getMonth().getNumbersOfDays();
                double result = ((double)nbDayMonth - inactivity) / tripType.getTripDuration().getDay();
                this.setNumberOfTrips(result);
            }
        }
    }

    @Override
    public double getEffortNominalPerVessel(Month month) {
        Strategy strategy = this.getStrategy();
        if (strategy != null && strategy.isEffortEquationUsed()) {
            return strategy.getEffortNominalPerVessel(this.getMonth());
        }
        throw new IllegalStateException("Strategy %s is not configured to use effort equation".formatted(strategy.getName()));
    }

    @Override
    public String toString() {
        String result = I18n.t((String)"isisfish.strategyMonthInfo.toString", (Object[])new Object[]{this.getStrategy(), this.getMonth()});
        return result;
    }
}

