package fr.ifremer.isisfish.ui.logging.console;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class LogConsoleUI extends JFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWS08UQRBuVmB5KAiEh4oGEY2aOKvxZMAXqyuYRY1gJO7F3p1mt7F3uu3ugcGD8Sf4E/TuxcSbJ+PBswcvxr9gjAevxuqZfTjrMEycPcyjq+rr76uuqp0331GPkuj4JvY8S7qOpnVi3b6+vn63vEkq+gZRFUmF5hIFv64MypTQoN1aVxqdKBVNeK4RnsvzuuAOcf6Kni+iAaV3GFE1QrRGR8MRFaVyqy3zvCdc2URtkYpCffXzR+al/eJ1BiFPALsRkDKzV1RbSXcRZait0SjstIVzDDtVoCGpUwW+B8xanmGl7uA6eYqeo2wR9QosAUyj2eSSfQw/3hMa9c3dLkgAPK/RxQ1p0Q1J6gTuiqoNqmqWSy3Gq1XgYFW4ozgjVpFX88Hjg2UhfKhejbJza7jMDM5USLHaNrG+zXj2dwZcMK9D5rK/ZQJS97BDGICNGtleAyVYNU7DLd8BRrYIK2CNmUbjIe98jVSeLHLPeI50BNyUkkuzMhG29vvWh1g6uxqXnQ0eYQxwb5CyW93VuiZxhURYs3WiFK4SjSZCCtaIpwuUMDusuQcLwXY0Ggs5L7pac6fDUxJFtHk5FTb0Ql1wBimbDGGs+qsmzWH3LBy+9ist7H/TplBbTf8z7UwF8GUsOyUFOyxi2XHkijj2CqasxRVsEh0J1RL0pdXuy3bjdJVAqAvLUHylf1v5PpiCJp7qaGID6Ft/T4x9ef/tXaHZuZOw93ik61+DBzpKSC6I1NRsPRy0raspy61gMV+CLBAGU8ufStMRxFYbZiAH+42YcMuEW0tY1QCiJ/v1w8eJx5/3oUwBKohju4CN/zLq1zU42RpntieuXvMZ7d/ug+tBww2Ol+EdDvWAhhZsaI2ZMnVsSP8VD5IwHZGEFpNy/6dfY6tvrzUT0QXEDu3q3k5GzyPUSx1GHeIPscZ8ihxag0IR1+btORQ1mbrMfVQ05ssl/3o5Smm3hh6BObEQ7D6DNUzMsqsJaDVB130R5invY44nwBzUnLM1Kkz7Gael/4Uyy7diEKYSIaykRojjcDg1h2QIcRymU3NIhhDH4VhqDskQ4jjMpOawNwIMhxqh1VpcZc+m5pEMIS4XJxMoyRLHfEPYMTCnUxNJhvAsBuFsAil9BP5Km19Ju+CcS83kfOpsXExdGgbhD8HcZIboCwAA";
    private static final Log log = LogFactory.getLog(LogConsoleUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton apply;
    protected JEditorPane content;
    protected JCheckBox levelDebug;
    protected JCheckBox levelError;
    protected JCheckBox levelFatal;
    protected JCheckBox levelInfo;
    protected JCheckBox levelTrace;
    protected JCheckBox levelWarn;
    protected JTextField message;
    protected JButton reset;
    protected JScrollPane scroll;
    protected JScrollBar scrollbar;
    protected JButton sendMail;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private LogConsoleUI $JFrame0 = this;
    private JPanel $JPanel0;
    private Table $Table0;
    private Table $Table1;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LogConsoleUI() {
        $initialize();
    }

    public LogConsoleUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LogConsoleUI(GraphicsConfiguration param0) {
        super(param0);
        $initialize();
    }

    public LogConsoleUI(JAXXContext parentContext, GraphicsConfiguration param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LogConsoleUI(String param0) {
        super(param0);
        $initialize();
    }

    public LogConsoleUI(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LogConsoleUI(String param0, GraphicsConfiguration param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LogConsoleUI(JAXXContext parentContext, String param1, GraphicsConfiguration param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getApply() {
        return apply;
    }

    public JEditorPane getContent() {
        return content;
    }

    public JCheckBox getLevelDebug() {
        return levelDebug;
    }

    public JCheckBox getLevelError() {
        return levelError;
    }

    public JCheckBox getLevelFatal() {
        return levelFatal;
    }

    public JCheckBox getLevelInfo() {
        return levelInfo;
    }

    public JCheckBox getLevelTrace() {
        return levelTrace;
    }

    public JCheckBox getLevelWarn() {
        return levelWarn;
    }

    public JTextField getMessage() {
        return message;
    }

    public JButton getReset() {
        return reset;
    }

    public JScrollPane getScroll() {
        return scroll;
    }

    public JScrollBar getScrollbar() {
        return scrollbar;
    }

    public JButton getSendMail() {
        return sendMail;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    protected Table get$Table1() {
        return $Table1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToScroll() {
        if (!allComponentsCreated) {
            return;
        }
        scroll.getViewport().add(content);
    }

    protected void createApply() {
        $objectMap.put("apply", apply = new JButton());
        
        apply.setName("apply");
        apply.setText(t("isisfish.filter.apply"));
    }

    protected void createContent() {
        $objectMap.put("content", content = new JEditorPane());
        
        content.setName("content");
        content.setEditable(false);
    }

    protected void createLevelDebug() {
        $objectMap.put("levelDebug", levelDebug = new JCheckBox());
        
        levelDebug.setName("levelDebug");
        levelDebug.setText(t("isisfish.filter.log.levelDebug"));
        levelDebug.setToolTipText(t("isisfish.filter.log.tooltip.levelDebug"));
    }

    protected void createLevelError() {
        $objectMap.put("levelError", levelError = new JCheckBox());
        
        levelError.setName("levelError");
        levelError.setText(t("isisfish.filter.log.levelError"));
        levelError.setToolTipText(t("isisfish.filter.log.tooltip.levelError"));
    }

    protected void createLevelFatal() {
        $objectMap.put("levelFatal", levelFatal = new JCheckBox());
        
        levelFatal.setName("levelFatal");
        levelFatal.setText(t("isisfish.filter.log.levelFatal"));
        levelFatal.setToolTipText(t("isisfish.filter.log.tooltip.levelFatal"));
    }

    protected void createLevelInfo() {
        $objectMap.put("levelInfo", levelInfo = new JCheckBox());
        
        levelInfo.setName("levelInfo");
        levelInfo.setText(t("isisfish.filter.log.levelInfo"));
        levelInfo.setToolTipText(t("isisfish.filter.log.tooltip.levelInfo"));
    }

    protected void createLevelTrace() {
        $objectMap.put("levelTrace", levelTrace = new JCheckBox());
        
        levelTrace.setName("levelTrace");
        levelTrace.setText(t("isisfish.filter.log.levelTrace"));
        levelTrace.setToolTipText(t("isisfish.filter.log.tooltip.levelTrace"));
    }

    protected void createLevelWarn() {
        $objectMap.put("levelWarn", levelWarn = new JCheckBox());
        
        levelWarn.setName("levelWarn");
        levelWarn.setText(t("isisfish.filter.log.levelWarn"));
        levelWarn.setToolTipText(t("isisfish.filter.log.tooltip.levelWarn"));
    }

    protected void createMessage() {
        $objectMap.put("message", message = new JTextField());
        
        message.setName("message");
        message.setColumns(15);
        SwingUtil.setComponentHeight(message,20);
        message.setToolTipText(t("isisfish.filter.log.tooltip.message"));
    }

    protected void createReset() {
        $objectMap.put("reset", reset = new JButton());
        
        reset.setName("reset");
        reset.setEnabled(false);
        reset.setText(t("isisfish.filter.reset"));
    }

    protected void createScroll() {
        $objectMap.put("scroll", scroll = new JScrollPane());
        
        scroll.setName("scroll");
        SwingUtil.setComponentHeight(scroll,400);
    }

    protected void createScrollbar() {
        $objectMap.put("scrollbar", scrollbar = new JScrollBar());
        
        scrollbar.setName("scrollbar");
        SwingUtil.setComponentHeight(scrollbar,400);
    }

    protected void createSendMail() {
        $objectMap.put("sendMail", sendMail = new JButton());
        
        sendMail.setName("sendMail");
        sendMail.setText(t("isisfish.log.sendMail"));
        sendMail.setToolTipText(t("isisfish.log.tooltip.sendMail"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JFrame0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($Table1, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 0, 3, 0), 0, 0));
        $Table0.add(scrollbar, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(3, 0, 3, 0), 0, 0));
        $Table0.add(sendMail, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 3, new Insets(3, 0, 3, 0), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JPanel0, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 13, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(message, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(apply, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(reset, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(scroll, new GridBagConstraints(0, 2, 5, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(levelFatal);
        $JPanel0.add(levelError);
        $JPanel0.add(levelWarn);
        $JPanel0.add(levelInfo);
        $JPanel0.add(levelDebug);
        $JPanel0.add(levelTrace);
        addChildrenToScroll();
        // late initializer
        $JFrame0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JFrame0", $JFrame0);
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(0, 6, 2, 2));
        createLevelFatal();
        createLevelError();
        createLevelWarn();
        createLevelInfo();
        createLevelDebug();
        createLevelTrace();
        createMessage();
        createApply();
        createReset();
        createScroll();
        createContent();
        createScrollbar();
        createSendMail();
        // inline creation of $JFrame0
        setName("$JFrame0");
        
        $completeSetup();
    }

}