package fr.ifremer.isisfish.ui;

/*
 * #%L
 * ISIS-Fish
 * %%
 * Copyright (C) 1999 - 2015 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.StatusMessagePanel;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import static org.nuiton.i18n.I18n.t;

public class StatusBarUI extends Table implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI1TPW8TQRAdH7Edx3w6wQoiCEOMIppzekcQCLKSyIEIGymKG9a+tW+j9d2yu0eOBvET+AnQ0yDRUSEKagoaxF9AiIIWMXtn+2JyKLi4O+/Me/Nmdt6b75BVEq4dkDC0ZeBpNqT29p29vQfdA9rT96jqSSa0LyH+ZSywOlB0JudKw3KnaeC1Eby24Q+F71HvCLrehDmln3GqXEq1hivTiJ5StdYkXA9FIMesE1FprK9+/rBeOi9eWwChQHU5bKVyEirpZKYJFnM0lLDSU1LjxBugDMm8Aeo9Y842OFHqPhnSJ/Ac8k3ICSKRTMP1/2854ojwodCQr7ZJl9NVpOhLm/UlHVJ8K6b6TLl2wOyWJjpQd4l8tCVEBMwhzCWew6nUsHISbDPOTLBnhfQHkioVp2hYNK2FtjrETu3t3VEUoQZQmOCKnHQpH4NKU6CmCU2nz1bj01Xzf2E6tlCNaXawDhnQXeJhnoYbU3cVUx9PHFFJuDyVjktjJ0uT3GqmA1kZ4DE22jm+Zw8xFG/Y4l8bZgij6O/y/Jf33941xmtlYe2LqalHXIHXjXMWeEXMlD4X71SgGa/tEFHvQEFRjpaKLLOUIqw1CqM4rHfBwG0DtzeJcpEim//64WP58edTYDVgjvvEaRCTvwUF7eIFuj53QnF7PVJ0+nAWn+eNNg0zrOd7uAdrDtGk0mWeg4O+FeIIllJGMNHRLXz6Nd96uz4eQwZlXfpnejKK7D7kmMeZRyN/jayT6qeiUDRw/MQiaabJmHdZjBb6avRcTuuzqH2ft5lo0xAtWlqLRVSIRk93A02xZYNdiXoxXzcn1H8A5T4XzAgFAAA=";
    private static final Log log = LogFactory.getLog(StatusBarUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected StatusBarHandler handler;
    protected JLabel labelStatus;
    protected JProgressBar progressStatus;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JLabel $JLabel0;
    private StatusMessagePanel $StatusMessagePanel0;
    private StatusBarUI $Table0 = this;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    protected void $afterCompleteSetup() {
            handler.afterInit();
        }
        /**
         * Change status message and stop progress bar if running.
         *
         * @param message new message
         */
        public void setStatusMessage(String message) {
            setStatusMessage(message, false);
        }
    
        /**
         * Change status message and progress bar state.
         *
         * @param message new message
         */
        public void setStatusMessage(String message, boolean state) {
            // use a basic mode, swap indeterminate state
            // can't known real progression here
            progressStatus.setIndeterminate(state);
            labelStatus.setText(message);
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public StatusBarUI() {
        $initialize();
    }

    public StatusBarUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doMouseClicked__on__$JLabel0(MouseEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.screenshot();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public StatusBarHandler getHandler() {
        return handler;
    }

    public JLabel getLabelStatus() {
        return labelStatus;
    }

    public JProgressBar getProgressStatus() {
        return progressStatus;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected StatusMessagePanel get$StatusMessagePanel0() {
        return $StatusMessagePanel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createHandler() {
        $objectMap.put("handler", handler = new StatusBarHandler(this));
    }

    protected void createLabelStatus() {
        $objectMap.put("labelStatus", labelStatus = new JLabel());
        
        labelStatus.setName("labelStatus");
    }

    protected void createProgressStatus() {
        $objectMap.put("progressStatus", progressStatus = new JProgressBar());
        
        progressStatus.setName("progressStatus");
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $Table0
        add(progressStatus, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add(labelStatus, new GridBagConstraints(1, 0, 1, 1, 5.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        add($JLabel0, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        add($StatusMessagePanel0, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 1 property setters
        $JLabel0.setIcon(SwingUtil.createImageIcon("common/camera.png"));
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$Table0", $Table0);
        createHandler();
        createProgressStatus();
        createLabelStatus();
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setToolTipText(t("isisfish.status.screenshot"));
        $JLabel0.addMouseListener(JAXXUtil.getEventListener(MouseListener.class, "mouseClicked", this, "doMouseClicked__on__$JLabel0"));
        // inline creation of $StatusMessagePanel0
        $objectMap.put("$StatusMessagePanel0", $StatusMessagePanel0 = new StatusMessagePanel());
        
        $StatusMessagePanel0.setName("$StatusMessagePanel0");
        // inline creation of $Table0
        setName("$Table0");
        
        $completeSetup();
    }

}