/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.ui.input.PopulationBasicsUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class WizardGroupCreationUI
extends JPanel
implements JAXXObject {
    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWXz28bRRTHJyaJm6Q0JSFRK4IINKqqom5c57cSSkPAkGAaVAelECEx9o7tidazy+xssgkIKoS4goQAcaNcuPSCxI0T4sCZAxfEv4AQB66IN7OON2tP1haTw9qe995nvu/Nj315+Cca8Dl6eh+HocUDJmiDWFvr9+5tl/dJRbxI/AqnnnA5iv76Miizh0bs1rgv0JW9ogyfbYbPbrgNz2WEnYpeLaJhXxw5xK8TIgR6MhlR8f3ZUsu8GnoBP6G2ROmo3/z9V+Yz+/6DDEKhB+rWIJXpblFxJv1FlKG2QGMw0wGedTCrgQxOWQ30PirHNhzs+3dwg7yLPkDZIhr0MAeYQM/0nrJiqPjQE2jkkB5jbr/M3QB+5avcolVOGgQ+fepXqV+3AmpR5gXC2o1dNzjBgrrsjU3PU7BBgcZnSmquTUYFxQ49Jjwn0FWVfwUEUQeokRyrwzMVc1OaLqS65Lu7zHV3me/ustDdZbG7y1J3l+XuLittLo9rSpdr8zkfLfjrmBEHDsuY3Fah5R/CLrO21Kh0HGr5Z2d2cNkhsJKXEjs5ilA26XmlFXBuZquIy8TJtcPVqHS62vK9XCY1ytSOKhJWE/WdI49sys2mpjsVfBfb1H0Bxl2WREzpECU4IiVIX/pYSf+ndP7w81DUNwJ+oAtplkDtwmv6ZJXtWfmY67DldbYqhatqvUYEmkzkuUNCUaDEsfWsOQ0rCwdaouTPVX3YfIq8hRTbom66qBr5lGostcIKHbZlje2iqoZa92hNWql0xq9o4scbOKQN7KhV9c9EDJ0sVk7DaKY1p0mrFRev8k6nMa8xjqrE5E5sE6WJn9PET/jNjXwnaJQJ366qDNMo8xrKcE1G7cKrJVXAQlp2i2nGJY2xWc/5tHrGe2G/07iiMU7U4oNakKVN1qOTks9pKGNVecD0JdUgbupUKkRJkNTIvC6S4YP4HruWvGz7PU4OYD8nroTY+/3YkcE9Ib/fT44PVimDd7bOUsGsEt2/bZbRWvIyhG5Cc9PLJixSogoGLxSOnkj4QddkxV1T3Nb07aEBHsAw3Ol7nY3WXTBFLdalthZLApX138nx337844fCSV91Heae0Lqeaguh3/G46xEuqJx6NGqqAkGd2dewt7qHhnziQE+pesYpjbBS0wziYL7HZLglw61XsF8HxED2959+nnzn10dQpoCGHRfbBSz9N9GQqHOoguvYoff8baXo/OE5eF6U2mAtHHzkynfchTUbCzxdpsyGGt8KoQhTmiK0lJSHfvlnvPT97ZNC9IGwy2e6x8UYeAsNUuZQRlSLKRc+e0ZLOeL5JLDduEvU9Y198nPYa3YVn6rn552ZyuEv5OPLMJAfXynJ8tvXyjbTlQBnoe5yeuwygZ11h9ZYQ/W7Y2tROtNYQINcDgS5pZ/ieg9T9IvmYfr2/zNGyvHZSEHd6Klm3xkTHqYQcsYaeiOkacgba+iN8CCFsGiswZywbEx4zpiwbkzYMCa8ZLyam8YazAmvGhO2jQkl40ruGmswJ7xpTHjbmICNCcSYUDMmUOP90DDWYE5wjQm+MeHQmPBeD41EljD5f5OdgvnQWIg54aNeCH03UggfG2swJ3wChP8Aw9ApvHMWAAA=";
    private static final Log log = LogFactory.getLog(WizardGroupCreationUI.class);
    private static final long serialVersionUID = 1L;
    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();
    protected JRadioButton beginGroupLengthTypeGrowthCurve;
    protected JRadioButton beginGroupLengthTypeInput;
    protected JRadioButton beginGroupLengthTypeSameSize;
    protected JButton cancel;
    protected JTextField fieldNumberOfGroup;
    protected JTextField fieldStep;
    protected JButton finish;
    protected JTextField firstAge;
    protected JTextField firstInputLength;
    protected JTextField firstSizeLength;
    protected JAXXButtonGroup groupLengthType;
    protected JTextField groupWidth;
    protected JTextField growthCurveFirstGroup;
    protected JTextField lastAge;
    protected JTextField maximalGroupsLength;
    protected Table navButton;
    protected JButton next;
    protected JButton prev;
    protected JTextField sameSizeNumberOfGroup;
    protected WizardGroupCreationUI wizardGroup = this;
    protected JPanel wizardPanels;
    private JLabel $JLabel0;
    private JLabel $JLabel1;
    private JLabel $JLabel10;
    private JLabel $JLabel11;
    private JLabel $JLabel12;
    private JLabel $JLabel13;
    private JLabel $JLabel14;
    private JLabel $JLabel15;
    private JLabel $JLabel16;
    private JLabel $JLabel17;
    private JLabel $JLabel18;
    private JLabel $JLabel19;
    private JLabel $JLabel2;
    private JLabel $JLabel20;
    private JLabel $JLabel21;
    private JLabel $JLabel22;
    private JLabel $JLabel3;
    private JLabel $JLabel4;
    private JLabel $JLabel5;
    private JLabel $JLabel6;
    private JLabel $JLabel7;
    private JLabel $JLabel8;
    private JLabel $JLabel9;
    private Table $Table0;
    private Table $Table1;
    private Table $Table2;
    private Table $Table3;
    private Table $Table4;
    protected String current;
    protected boolean ageType;
    protected boolean inputType;
    protected boolean sameSizeType;
    protected boolean growthCurveType;
    protected double first;
    protected double last;
    protected String maxLength;
    protected int numberOfGroup;
    protected double groupSize;
    protected double step;
    protected PopulationBasicsUI popBasic;

    public void init(PopulationBasicsUI popBasic) {
        this.popBasic = popBasic;
    }

    public boolean isAgeType() {
        return this.ageType;
    }

    public void setAgeType(boolean ageType) {
        this.ageType = ageType;
    }

    public boolean isInputType() {
        return this.inputType;
    }

    public void setInputType(boolean inputType) {
        this.inputType = inputType;
    }

    public boolean isSameSizeType() {
        return this.sameSizeType;
    }

    public void setSameSizeType(boolean sameSizeType) {
        this.sameSizeType = sameSizeType;
    }

    public boolean isGrowthCurveType() {
        return this.growthCurveType;
    }

    public void setGrowthCurveType(boolean growthCurveType) {
        this.growthCurveType = growthCurveType;
    }

    public double getFirst() {
        return this.first;
    }

    public void setFirst(double first) {
        this.first = first;
    }

    public double getLast() {
        return this.last;
    }

    public void setLast(double last) {
        this.last = last;
    }

    public String getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(String maxLength) {
        this.maxLength = maxLength;
    }

    public int getNumberOfGroup() {
        return this.numberOfGroup;
    }

    public void setNumberOfGroup(int numberOfGroup) {
        this.numberOfGroup = numberOfGroup;
    }

    public double getGroupSize() {
        return this.groupSize;
    }

    public void setGroupSize(double groupSize) {
        this.groupSize = groupSize;
    }

    public double getStep() {
        return this.step;
    }

    public void setStep(double step) {
        this.step = step;
    }

    public void setCard(String name) {
        this.current = name;
        ((CardLayout)this.wizardPanels.getLayout()).show(this.wizardPanels, name);
    }

    protected void prev() {
        if (!this.isAgeType()) {
            this.setCard("beginGroupLength");
        }
        this.prev.setEnabled(false);
        this.next.setEnabled(true);
        this.finish.setEnabled(false);
    }

    protected void next() {
        if (!this.isAgeType()) {
            if (this.isInputType()) {
                this.setCard("endInputGroupLength");
            } else if (this.isSameSizeType()) {
                this.setCard("endSameSizeGroupLength");
            } else if (this.isGrowthCurveType()) {
                this.setCard("endGrowthCurveGroupLength");
            }
        }
        this.prev.setEnabled(true);
        this.next.setEnabled(false);
        this.finish.setEnabled(true);
    }

    protected void finish() {
        block18: {
            if (log.isDebugEnabled()) {
                log.debug((Object)"wizardGroupFinish called");
            }
            try {
                Population pop = this.popBasic.getBean();
                pop.clearPopulationGroup();
                TopiaContext isisContext = pop.getTopiaContext();
                PopulationGroupDAO populationGroupDAO = IsisFishDAOHelper.getPopulationGroupDAO(isisContext);
                if (this.isAgeType()) {
                    double ageFirst = this.getFirst();
                    double ageLast = this.getLast();
                    int id = 0;
                    while ((double)id + ageFirst <= ageLast) {
                        PopulationGroup group = (PopulationGroup)populationGroupDAO.create(new Object[0]);
                        group.setId(id);
                        group.setPopulation(pop);
                        group.setAge(ageFirst + (double)id);
                        pop.addPopulationGroup(group);
                        populationGroupDAO.update((TopiaEntity)group);
                        ++id;
                    }
                } else if (this.isInputType()) {
                    double minLength = this.getFirst();
                    String[] values = this.getMaxLength().split(";");
                    for (int i = 0; i < values.length; ++i) {
                        if ("".equals(values[i])) continue;
                        double length = Double.parseDouble(values[i]);
                        PopulationGroup group = (PopulationGroup)populationGroupDAO.create(new Object[0]);
                        group.setId(i);
                        group.setPopulation(pop);
                        group.setMinLength(minLength);
                        group.setMaxLength(length);
                        pop.addPopulationGroup(group);
                        populationGroupDAO.update((TopiaEntity)group);
                        minLength = length;
                    }
                } else if (this.isSameSizeType()) {
                    double minLength = this.getFirst();
                    int numberOfGroup = this.getNumberOfGroup();
                    double step = this.getGroupSize();
                    if (numberOfGroup < 0) {
                        // empty if block
                    }
                    if (step == 0.0) {
                        // empty if block
                    }
                    double maxLength = minLength;
                    for (int i = 0; i < numberOfGroup; ++i) {
                        maxLength = minLength + step;
                        PopulationGroup group = (PopulationGroup)populationGroupDAO.create(new Object[0]);
                        group.setId(i);
                        group.setPopulation(pop);
                        group.setMinLength(minLength);
                        group.setMaxLength(maxLength);
                        pop.addPopulationGroup(group);
                        populationGroupDAO.update((TopiaEntity)group);
                        minLength = maxLength;
                    }
                } else if (this.isGrowthCurveType()) {
                    double minLength = this.getFirst();
                    int numberOfGroup = this.getNumberOfGroup();
                    int step = (int)this.getStep();
                    Equation equation = pop.getGrowth();
                    if (equation == null) {
                        // empty if block
                    }
                    double deltat = -1.0;
                    double Lmin = minLength;
                    for (int i = 0; i < numberOfGroup; ++i) {
                        PopulationGroup group = (PopulationGroup)populationGroupDAO.create(new Object[0]);
                        group.setId(i);
                        group.setPopulation(pop);
                        group.setMinLength(Lmin);
                        group.setMaxLength(Lmin);
                        pop.addPopulationGroup(group);
                        if (deltat < 0.0) {
                            deltat = pop.getAge(minLength, group);
                        }
                        double Lmax = pop.getLength(deltat += (double)step, group);
                        group.setMaxLength(Lmax);
                        Lmin = Lmax;
                    }
                }
                this.popBasic.refresh();
                this.cancel();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block18;
                log.error((Object)"Can't create PopulationGroup", (Throwable)e);
            }
        }
    }

    protected void cancel() {
        this.getParentContainer(JFrame.class).dispose();
    }

    protected void refreshChoice() {
        this.setInputType(this.beginGroupLengthTypeInput.isSelected());
        this.setSameSizeType(this.beginGroupLengthTypeSameSize.isSelected());
        this.setGrowthCurveType(this.beginGroupLengthTypeGrowthCurve.isSelected());
    }

    protected void stepChanged() {
        if (!this.fieldStep.getText().equals("")) {
            this.setStep(Double.parseDouble(this.fieldStep.getText()));
        }
    }

    protected void firstAgeChanged() {
        if (!this.firstAge.getText().equals("")) {
            this.setFirst(Double.parseDouble(this.firstAge.getText()));
        }
    }

    protected void lastAgeChanged() {
        if (!this.lastAge.getText().equals("")) {
            this.setLast(Double.parseDouble(this.lastAge.getText()));
        }
    }

    protected void firstInputLengthChanged() {
        if (!this.firstInputLength.getText().equals("")) {
            this.setFirst(Double.parseDouble(this.firstInputLength.getText()));
        }
    }

    protected void maximalGroupsLengthChanged() {
        if (!this.maximalGroupsLength.getText().equals("")) {
            this.setMaxLength(this.maximalGroupsLength.getText());
        }
    }

    protected void firstSizeLengthChanged() {
        if (!this.firstSizeLength.getText().equals("")) {
            this.setFirst(Double.parseDouble(this.firstSizeLength.getText()));
        }
    }

    protected void sameSizeNumberOfGroupChanged() {
        if (!this.sameSizeNumberOfGroup.getText().equals("")) {
            this.setNumberOfGroup(Integer.parseInt(this.sameSizeNumberOfGroup.getText()));
        }
    }

    protected void groupWidthChanged() {
        if (!this.groupWidth.getText().equals("")) {
            this.setGroupSize(Double.parseDouble(this.groupWidth.getText()));
        }
    }

    protected void growthCurveFirstGroupChanged() {
        if (!this.growthCurveFirstGroup.getText().equals("")) {
            this.setFirst(Double.parseDouble(this.growthCurveFirstGroup.getText()));
        }
    }

    protected void fieldNumberOfGroupChanged() {
        if (!this.fieldNumberOfGroup.getText().equals("")) {
            this.setNumberOfGroup(Integer.parseInt(this.fieldNumberOfGroup.getText()));
        }
    }

    public WizardGroupCreationUI(LayoutManager param0, boolean param1) {
        super(param0, param1);
        this.$initialize();
    }

    public WizardGroupCreationUI(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1, param2);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public WizardGroupCreationUI() {
        this.$initialize();
    }

    public WizardGroupCreationUI(JAXXContext parentContext) {
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public WizardGroupCreationUI(LayoutManager param0) {
        super(param0);
        this.$initialize();
    }

    public WizardGroupCreationUI(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public WizardGroupCreationUI(boolean param0) {
        super(param0);
        this.$initialize();
    }

    public WizardGroupCreationUI(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext((JAXXObject)this, (JAXXContext)parentContext);
        this.$initialize();
    }

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor((String)$jaxxObjectDescriptor);
    }

    public void applyDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.getDataBinding($binding).applyDataBinding();
        }
        this.processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String, Object> get$objectMap() {
        return this.$objectMap;
    }

    public JAXXBinding getDataBinding(String bindingId) {
        return this.$bindings.get(bindingId);
    }

    public JAXXBinding[] getDataBindings() {
        return this.$bindings.values().toArray(new JAXXBinding[this.$bindings.size()]);
    }

    public Object getObjectById(String id) {
        return this.$objectMap.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && this.$activeBindings.contains($binding)) {
            return;
        }
        this.$activeBindings.add($binding);
        try {
            if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
                this.getDataBinding($binding).processDataBinding();
            }
        }
        finally {
            this.$activeBindings.remove($binding);
        }
    }

    public void processDataBinding(String $binding) {
        this.processDataBinding($binding, false);
    }

    public void registerDataBinding(JAXXBinding binding) {
        this.$bindings.put(binding.getId(), binding);
    }

    public void removeDataBinding(String $binding) {
        if (this.allComponentsCreated && this.$bindings.containsKey($binding)) {
            this.getDataBinding($binding).removeDataBinding();
        }
    }

    public <T> T getContextValue(Class<T> clazz) {
        return (T)this.delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return (T)this.delegateContext.getContextValue(clazz, name);
    }

    public JAXXContext getDelegateContext() {
        return this.delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)this, clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return (O)SwingUtil.getParentContainer((Object)source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        this.delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        this.delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        this.delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        this.delegateContext.setContextValue(o, name);
    }

    public void doActionPerformed__on__beginGroupLengthTypeGrowthCurve(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.refreshChoice();
    }

    public void doActionPerformed__on__beginGroupLengthTypeInput(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.refreshChoice();
    }

    public void doActionPerformed__on__beginGroupLengthTypeSameSize(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.refreshChoice();
    }

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.cancel();
    }

    public void doActionPerformed__on__finish(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.finish();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.next();
    }

    public void doActionPerformed__on__prev(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.prev();
    }

    public void doFocusLost__on__fieldNumberOfGroup(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.fieldNumberOfGroupChanged();
    }

    public void doFocusLost__on__fieldStep(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.stepChanged();
    }

    public void doFocusLost__on__firstAge(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.firstAgeChanged();
    }

    public void doFocusLost__on__firstInputLength(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.firstInputLengthChanged();
    }

    public void doFocusLost__on__firstSizeLength(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.firstSizeLengthChanged();
    }

    public void doFocusLost__on__groupWidth(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.groupWidthChanged();
    }

    public void doFocusLost__on__growthCurveFirstGroup(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.growthCurveFirstGroupChanged();
    }

    public void doFocusLost__on__lastAge(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.lastAgeChanged();
    }

    public void doFocusLost__on__maximalGroupsLength(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.maximalGroupsLengthChanged();
    }

    public void doFocusLost__on__sameSizeNumberOfGroup(FocusEvent event) {
        if (log.isDebugEnabled()) {
            log.debug((Object)event);
        }
        this.sameSizeNumberOfGroupChanged();
    }

    public JRadioButton getBeginGroupLengthTypeGrowthCurve() {
        return this.beginGroupLengthTypeGrowthCurve;
    }

    public JRadioButton getBeginGroupLengthTypeInput() {
        return this.beginGroupLengthTypeInput;
    }

    public JRadioButton getBeginGroupLengthTypeSameSize() {
        return this.beginGroupLengthTypeSameSize;
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public JTextField getFieldNumberOfGroup() {
        return this.fieldNumberOfGroup;
    }

    public JTextField getFieldStep() {
        return this.fieldStep;
    }

    public JButton getFinish() {
        return this.finish;
    }

    public JTextField getFirstAge() {
        return this.firstAge;
    }

    public JTextField getFirstInputLength() {
        return this.firstInputLength;
    }

    public JTextField getFirstSizeLength() {
        return this.firstSizeLength;
    }

    public JAXXButtonGroup getGroupLengthType() {
        return this.groupLengthType;
    }

    public JTextField getGroupWidth() {
        return this.groupWidth;
    }

    public JTextField getGrowthCurveFirstGroup() {
        return this.growthCurveFirstGroup;
    }

    public JTextField getLastAge() {
        return this.lastAge;
    }

    public JTextField getMaximalGroupsLength() {
        return this.maximalGroupsLength;
    }

    public Table getNavButton() {
        return this.navButton;
    }

    public JButton getNext() {
        return this.next;
    }

    public JButton getPrev() {
        return this.prev;
    }

    public JTextField getSameSizeNumberOfGroup() {
        return this.sameSizeNumberOfGroup;
    }

    public JPanel getWizardPanels() {
        return this.wizardPanels;
    }

    protected JLabel get$JLabel0() {
        return this.$JLabel0;
    }

    protected JLabel get$JLabel1() {
        return this.$JLabel1;
    }

    protected JLabel get$JLabel10() {
        return this.$JLabel10;
    }

    protected JLabel get$JLabel11() {
        return this.$JLabel11;
    }

    protected JLabel get$JLabel12() {
        return this.$JLabel12;
    }

    protected JLabel get$JLabel13() {
        return this.$JLabel13;
    }

    protected JLabel get$JLabel14() {
        return this.$JLabel14;
    }

    protected JLabel get$JLabel15() {
        return this.$JLabel15;
    }

    protected JLabel get$JLabel16() {
        return this.$JLabel16;
    }

    protected JLabel get$JLabel17() {
        return this.$JLabel17;
    }

    protected JLabel get$JLabel18() {
        return this.$JLabel18;
    }

    protected JLabel get$JLabel19() {
        return this.$JLabel19;
    }

    protected JLabel get$JLabel2() {
        return this.$JLabel2;
    }

    protected JLabel get$JLabel20() {
        return this.$JLabel20;
    }

    protected JLabel get$JLabel21() {
        return this.$JLabel21;
    }

    protected JLabel get$JLabel22() {
        return this.$JLabel22;
    }

    protected JLabel get$JLabel3() {
        return this.$JLabel3;
    }

    protected JLabel get$JLabel4() {
        return this.$JLabel4;
    }

    protected JLabel get$JLabel5() {
        return this.$JLabel5;
    }

    protected JLabel get$JLabel6() {
        return this.$JLabel6;
    }

    protected JLabel get$JLabel7() {
        return this.$JLabel7;
    }

    protected JLabel get$JLabel8() {
        return this.$JLabel8;
    }

    protected JLabel get$JLabel9() {
        return this.$JLabel9;
    }

    protected Table get$Table0() {
        return this.$Table0;
    }

    protected Table get$Table1() {
        return this.$Table1;
    }

    protected Table get$Table2() {
        return this.$Table2;
    }

    protected Table get$Table3() {
        return this.$Table3;
    }

    protected Table get$Table4() {
        return this.$Table4;
    }

    protected void addChildrenToBeginGroupLengthTypeGrowthCurve() {
        if (!this.allComponentsCreated) {
            return;
        }
        JAXXButtonGroup $buttonGroup = this.groupLengthType;
        this.beginGroupLengthTypeGrowthCurve.putClientProperty("$buttonGroup", $buttonGroup);
        $buttonGroup.add(this.beginGroupLengthTypeGrowthCurve);
    }

    protected void addChildrenToBeginGroupLengthTypeInput() {
        if (!this.allComponentsCreated) {
            return;
        }
        JAXXButtonGroup $buttonGroup = this.groupLengthType;
        this.beginGroupLengthTypeInput.putClientProperty("$buttonGroup", $buttonGroup);
        $buttonGroup.add(this.beginGroupLengthTypeInput);
    }

    protected void addChildrenToBeginGroupLengthTypeSameSize() {
        if (!this.allComponentsCreated) {
            return;
        }
        JAXXButtonGroup $buttonGroup = this.groupLengthType;
        this.beginGroupLengthTypeSameSize.putClientProperty("$buttonGroup", $buttonGroup);
        $buttonGroup.add(this.beginGroupLengthTypeSameSize);
    }

    protected void addChildrenToNavButton() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.navButton.add((Component)this.prev, (Object)new GridBagConstraints(0, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.navButton.add((Component)this.next, (Object)new GridBagConstraints(1, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.navButton.add((Component)this.finish, (Object)new GridBagConstraints(2, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.navButton.add((Component)this.cancel, (Object)new GridBagConstraints(3, 0, 1, 1, 0.2, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToWizardGroup() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.add((Component)this.wizardPanels, "Center");
        this.add((Component)this.navButton, "South");
    }

    protected void addChildrenToWizardPanels() {
        if (!this.allComponentsCreated) {
            return;
        }
        this.wizardPanels.add((Component)this.$Table0, "beginGroupLength");
        this.wizardPanels.add((Component)this.$Table1, "singleGroupAge");
        this.wizardPanels.add((Component)this.$Table2, "endInputGroupLength");
        this.wizardPanels.add((Component)this.$Table3, "endSameSizeGroupLength");
        this.wizardPanels.add((Component)this.$Table4, "endGrowthCurveGroupLength");
    }

    protected void createBeginGroupLengthTypeGrowthCurve() {
        this.beginGroupLengthTypeGrowthCurve = new JRadioButton();
        this.$objectMap.put("beginGroupLengthTypeGrowthCurve", this.beginGroupLengthTypeGrowthCurve);
        this.beginGroupLengthTypeGrowthCurve.setName("beginGroupLengthTypeGrowthCurve");
        this.beginGroupLengthTypeGrowthCurve.setText(I18n.t((String)"isisfish.wizardGroupCreation.computedGrowthCurve", (Object[])new Object[0]));
        this.beginGroupLengthTypeGrowthCurve.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__beginGroupLengthTypeGrowthCurve"));
    }

    protected void createBeginGroupLengthTypeInput() {
        this.beginGroupLengthTypeInput = new JRadioButton();
        this.$objectMap.put("beginGroupLengthTypeInput", this.beginGroupLengthTypeInput);
        this.beginGroupLengthTypeInput.setName("beginGroupLengthTypeInput");
        this.beginGroupLengthTypeInput.setText(I18n.t((String)"isisfish.wizardGroupCreation.allValues", (Object[])new Object[0]));
        this.beginGroupLengthTypeInput.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__beginGroupLengthTypeInput"));
    }

    protected void createBeginGroupLengthTypeSameSize() {
        this.beginGroupLengthTypeSameSize = new JRadioButton();
        this.$objectMap.put("beginGroupLengthTypeSameSize", this.beginGroupLengthTypeSameSize);
        this.beginGroupLengthTypeSameSize.setName("beginGroupLengthTypeSameSize");
        this.beginGroupLengthTypeSameSize.setText(I18n.t((String)"isisfish.wizardGroupCreation.allGroupsSameSize", (Object[])new Object[0]));
        this.beginGroupLengthTypeSameSize.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__beginGroupLengthTypeSameSize"));
    }

    protected void createCancel() {
        this.cancel = new JButton();
        this.$objectMap.put("cancel", this.cancel);
        this.cancel.setName("cancel");
        this.cancel.setText(I18n.t((String)"isisfish.common.cancel", (Object[])new Object[0]));
        this.cancel.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__cancel"));
    }

    protected void createFieldNumberOfGroup() {
        this.fieldNumberOfGroup = new JTextField();
        this.$objectMap.put("fieldNumberOfGroup", this.fieldNumberOfGroup);
        this.fieldNumberOfGroup.setName("fieldNumberOfGroup");
        this.fieldNumberOfGroup.setColumns(15);
        this.fieldNumberOfGroup.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__fieldNumberOfGroup"));
    }

    protected void createFieldStep() {
        this.fieldStep = new JTextField();
        this.$objectMap.put("fieldStep", this.fieldStep);
        this.fieldStep.setName("fieldStep");
        this.fieldStep.setColumns(15);
        this.fieldStep.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__fieldStep"));
    }

    protected void createFinish() {
        this.finish = new JButton();
        this.$objectMap.put("finish", this.finish);
        this.finish.setName("finish");
        this.finish.setEnabled(false);
        this.finish.setText(I18n.t((String)"isisfish.common.finish", (Object[])new Object[0]));
        this.finish.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__finish"));
    }

    protected void createFirstAge() {
        this.firstAge = new JTextField();
        this.$objectMap.put("firstAge", this.firstAge);
        this.firstAge.setName("firstAge");
        this.firstAge.setColumns(15);
        this.firstAge.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__firstAge"));
    }

    protected void createFirstInputLength() {
        this.firstInputLength = new JTextField();
        this.$objectMap.put("firstInputLength", this.firstInputLength);
        this.firstInputLength.setName("firstInputLength");
        this.firstInputLength.setColumns(15);
        this.firstInputLength.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__firstInputLength"));
    }

    protected void createFirstSizeLength() {
        this.firstSizeLength = new JTextField();
        this.$objectMap.put("firstSizeLength", this.firstSizeLength);
        this.firstSizeLength.setName("firstSizeLength");
        this.firstSizeLength.setColumns(15);
        this.firstSizeLength.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__firstSizeLength"));
    }

    protected void createGroupLengthType() {
        this.groupLengthType = new JAXXButtonGroup();
        this.$objectMap.put("groupLengthType", this.groupLengthType);
    }

    protected void createGroupWidth() {
        this.groupWidth = new JTextField();
        this.$objectMap.put("groupWidth", this.groupWidth);
        this.groupWidth.setName("groupWidth");
        this.groupWidth.setColumns(15);
        this.groupWidth.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__groupWidth"));
    }

    protected void createGrowthCurveFirstGroup() {
        this.growthCurveFirstGroup = new JTextField();
        this.$objectMap.put("growthCurveFirstGroup", this.growthCurveFirstGroup);
        this.growthCurveFirstGroup.setName("growthCurveFirstGroup");
        this.growthCurveFirstGroup.setColumns(15);
        this.growthCurveFirstGroup.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__growthCurveFirstGroup"));
    }

    protected void createLastAge() {
        this.lastAge = new JTextField();
        this.$objectMap.put("lastAge", this.lastAge);
        this.lastAge.setName("lastAge");
        this.lastAge.setColumns(15);
        this.lastAge.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__lastAge"));
    }

    protected void createMaximalGroupsLength() {
        this.maximalGroupsLength = new JTextField();
        this.$objectMap.put("maximalGroupsLength", this.maximalGroupsLength);
        this.maximalGroupsLength.setName("maximalGroupsLength");
        this.maximalGroupsLength.setColumns(15);
        this.maximalGroupsLength.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__maximalGroupsLength"));
    }

    protected void createNavButton() {
        this.navButton = new Table();
        this.$objectMap.put("navButton", this.navButton);
        this.navButton.setName("navButton");
    }

    protected void createNext() {
        this.next = new JButton();
        this.$objectMap.put("next", this.next);
        this.next.setName("next");
        this.next.setText(I18n.t((String)"isisfish.common.next", (Object[])new Object[0]));
        this.next.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__next"));
    }

    protected void createPrev() {
        this.prev = new JButton();
        this.$objectMap.put("prev", this.prev);
        this.prev.setName("prev");
        this.prev.setEnabled(false);
        this.prev.setText(I18n.t((String)"isisfish.common.prev", (Object[])new Object[0]));
        this.prev.addActionListener((ActionListener)JAXXUtil.getEventListener(ActionListener.class, (String)"actionPerformed", (Object)this, (String)"doActionPerformed__on__prev"));
    }

    protected void createSameSizeNumberOfGroup() {
        this.sameSizeNumberOfGroup = new JTextField();
        this.$objectMap.put("sameSizeNumberOfGroup", this.sameSizeNumberOfGroup);
        this.sameSizeNumberOfGroup.setName("sameSizeNumberOfGroup");
        this.sameSizeNumberOfGroup.setColumns(15);
        this.sameSizeNumberOfGroup.addFocusListener((FocusListener)JAXXUtil.getEventListener(FocusListener.class, (String)"focusLost", (Object)this, (String)"doFocusLost__on__sameSizeNumberOfGroup"));
    }

    protected void createWizardPanels() {
        this.wizardPanels = new JPanel();
        this.$objectMap.put("wizardPanels", this.wizardPanels);
        this.wizardPanels.setName("wizardPanels");
        this.wizardPanels.setLayout(new CardLayout());
    }

    private void $completeSetup() {
        this.allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.addChildrenToWizardGroup();
        this.addChildrenToWizardPanels();
        this.$Table0.add((Component)this.$JLabel0, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.beginGroupLengthTypeInput, (Object)new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.beginGroupLengthTypeSameSize, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table0.add((Component)this.beginGroupLengthTypeGrowthCurve, (Object)new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.addChildrenToBeginGroupLengthTypeInput();
        this.addChildrenToBeginGroupLengthTypeSameSize();
        this.addChildrenToBeginGroupLengthTypeGrowthCurve();
        this.$Table1.add((Component)this.$JLabel1, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JLabel2, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.firstAge, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JLabel3, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.lastAge, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JLabel4, (Object)new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JLabel5, (Object)new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table1.add((Component)this.$JLabel6, (Object)new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel7, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel8, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.firstInputLength, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel9, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.maximalGroupsLength, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table2.add((Component)this.$JLabel10, (Object)new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.$JLabel11, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.$JLabel12, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.firstSizeLength, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.$JLabel13, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.sameSizeNumberOfGroup, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.$JLabel14, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.groupWidth, (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.$JLabel15, (Object)new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.$JLabel16, (Object)new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table3.add((Component)this.$JLabel17, (Object)new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.$JLabel18, (Object)new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.$JLabel19, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.growthCurveFirstGroup, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.$JLabel20, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.fieldNumberOfGroup, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.$JLabel21, (Object)new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.fieldStep, (Object)new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.$Table4.add((Component)this.$JLabel22, (Object)new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.addChildrenToNavButton();
    }

    private void $initialize() {
        if (this.allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        this.$objectMap.put("wizardGroup", this.wizardGroup);
        this.current = null;
        this.ageType = false;
        this.inputType = false;
        this.sameSizeType = false;
        this.growthCurveType = false;
        this.first = 0.0;
        this.last = 0.0;
        this.maxLength = "";
        this.numberOfGroup = 0;
        this.groupSize = 0.0;
        this.step = 1.0;
        this.createWizardPanels();
        this.$Table0 = new Table();
        this.$objectMap.put("$Table0", this.$Table0);
        this.$Table0.setName("$Table0");
        this.$JLabel0 = new JLabel();
        this.$objectMap.put("$JLabel0", this.$JLabel0);
        this.$JLabel0.setName("$JLabel0");
        this.$JLabel0.setHorizontalAlignment(0);
        this.$JLabel0.setText(I18n.t((String)"isisfish.wizardGroupCreation.selectGroupLengthType", (Object[])new Object[0]));
        this.createBeginGroupLengthTypeInput();
        this.createBeginGroupLengthTypeSameSize();
        this.createBeginGroupLengthTypeGrowthCurve();
        this.$Table1 = new Table();
        this.$objectMap.put("$Table1", this.$Table1);
        this.$Table1.setName("$Table1");
        this.$JLabel1 = new JLabel();
        this.$objectMap.put("$JLabel1", this.$JLabel1);
        this.$JLabel1.setName("$JLabel1");
        this.$JLabel1.setHorizontalAlignment(0);
        this.$JLabel1.setText(I18n.t((String)"isisfish.wizardGroupCreation.populationCharacteristics", (Object[])new Object[0]));
        this.$JLabel2 = new JLabel();
        this.$objectMap.put("$JLabel2", this.$JLabel2);
        this.$JLabel2.setName("$JLabel2");
        this.$JLabel2.setText(I18n.t((String)"isisfish.wizardGroupCreation.firstAge", (Object[])new Object[0]));
        this.createFirstAge();
        this.$JLabel3 = new JLabel();
        this.$objectMap.put("$JLabel3", this.$JLabel3);
        this.$JLabel3.setName("$JLabel3");
        this.$JLabel3.setText(I18n.t((String)"isisfish.wizardGroupCreation.lastAge", (Object[])new Object[0]));
        this.createLastAge();
        this.$JLabel4 = new JLabel();
        this.$objectMap.put("$JLabel4", this.$JLabel4);
        this.$JLabel4.setName("$JLabel4");
        this.$JLabel4.setText(I18n.t((String)"isisfish.wizardGroupCreation.firstAgeHelp", (Object[])new Object[0]));
        this.$JLabel5 = new JLabel();
        this.$objectMap.put("$JLabel5", this.$JLabel5);
        this.$JLabel5.setName("$JLabel5");
        this.$JLabel5.setText(I18n.t((String)"isisfish.wizardGroupCreation.lastAgeHelp", (Object[])new Object[0]));
        this.$JLabel6 = new JLabel();
        this.$objectMap.put("$JLabel6", this.$JLabel6);
        this.$JLabel6.setName("$JLabel6");
        this.$JLabel6.setText(I18n.t((String)"isisfish.wizardGroupCreation.gapBetweenGroupsHelp", (Object[])new Object[0]));
        this.$Table2 = new Table();
        this.$objectMap.put("$Table2", this.$Table2);
        this.$Table2.setName("$Table2");
        this.$JLabel7 = new JLabel();
        this.$objectMap.put("$JLabel7", this.$JLabel7);
        this.$JLabel7.setName("$JLabel7");
        this.$JLabel7.setHorizontalAlignment(0);
        this.$JLabel7.setText(I18n.t((String)"isisfish.wizardGroupCreation.populationCharacteristics", (Object[])new Object[0]));
        this.$JLabel8 = new JLabel();
        this.$objectMap.put("$JLabel8", this.$JLabel8);
        this.$JLabel8.setName("$JLabel8");
        this.$JLabel8.setText(I18n.t((String)"isisfish.wizardGroupCreation.firstLength", (Object[])new Object[0]));
        this.createFirstInputLength();
        this.$JLabel9 = new JLabel();
        this.$objectMap.put("$JLabel9", this.$JLabel9);
        this.$JLabel9.setName("$JLabel9");
        this.$JLabel9.setText(I18n.t((String)"isisfish.wizardGroupCreation.maxGroupsLength", (Object[])new Object[0]));
        this.createMaximalGroupsLength();
        this.$JLabel10 = new JLabel();
        this.$objectMap.put("$JLabel10", this.$JLabel10);
        this.$JLabel10.setName("$JLabel10");
        this.$JLabel10.setText(I18n.t((String)"isisfish.wizardGroupCreation.maxGroupsLengthHelp", (Object[])new Object[0]));
        this.$Table3 = new Table();
        this.$objectMap.put("$Table3", this.$Table3);
        this.$Table3.setName("$Table3");
        this.$JLabel11 = new JLabel();
        this.$objectMap.put("$JLabel11", this.$JLabel11);
        this.$JLabel11.setName("$JLabel11");
        this.$JLabel11.setHorizontalAlignment(0);
        this.$JLabel11.setText(I18n.t((String)"isisfish.wizardGroupCreation.populationCharacteristics", (Object[])new Object[0]));
        this.$JLabel12 = new JLabel();
        this.$objectMap.put("$JLabel12", this.$JLabel12);
        this.$JLabel12.setName("$JLabel12");
        this.$JLabel12.setText(I18n.t((String)"isisfish.wizardGroupCreation.firstLength", (Object[])new Object[0]));
        this.createFirstSizeLength();
        this.$JLabel13 = new JLabel();
        this.$objectMap.put("$JLabel13", this.$JLabel13);
        this.$JLabel13.setName("$JLabel13");
        this.$JLabel13.setText(I18n.t((String)"isisfish.wizardGroupCreation.numberGroup", (Object[])new Object[0]));
        this.createSameSizeNumberOfGroup();
        this.$JLabel14 = new JLabel();
        this.$objectMap.put("$JLabel14", this.$JLabel14);
        this.$JLabel14.setName("$JLabel14");
        this.$JLabel14.setText(I18n.t((String)"isisfish.wizardGroupCreation.groupWidth", (Object[])new Object[0]));
        this.createGroupWidth();
        this.$JLabel15 = new JLabel();
        this.$objectMap.put("$JLabel15", this.$JLabel15);
        this.$JLabel15.setName("$JLabel15");
        this.$JLabel15.setText(I18n.t((String)"isisfish.wizardGroupCreation.firstLengthHelp", (Object[])new Object[0]));
        this.$JLabel16 = new JLabel();
        this.$objectMap.put("$JLabel16", this.$JLabel16);
        this.$JLabel16.setName("$JLabel16");
        this.$JLabel16.setText(I18n.t((String)"isisfish.wizardGroupCreation.numberGroupHelp", (Object[])new Object[0]));
        this.$JLabel17 = new JLabel();
        this.$objectMap.put("$JLabel17", this.$JLabel17);
        this.$JLabel17.setName("$JLabel17");
        this.$JLabel17.setText(I18n.t((String)"isisfish.wizardGroupCreation.groupWidthHelp", (Object[])new Object[0]));
        this.$Table4 = new Table();
        this.$objectMap.put("$Table4", this.$Table4);
        this.$Table4.setName("$Table4");
        this.$JLabel18 = new JLabel();
        this.$objectMap.put("$JLabel18", this.$JLabel18);
        this.$JLabel18.setName("$JLabel18");
        this.$JLabel18.setHorizontalAlignment(0);
        this.$JLabel18.setText(I18n.t((String)"isisfish.wizardGroupCreation.populationCharacteristics", (Object[])new Object[0]));
        this.$JLabel19 = new JLabel();
        this.$objectMap.put("$JLabel19", this.$JLabel19);
        this.$JLabel19.setName("$JLabel19");
        this.$JLabel19.setText(I18n.t((String)"isisfish.wizardGroupCreation.firstGroup", (Object[])new Object[0]));
        this.createGrowthCurveFirstGroup();
        this.$JLabel20 = new JLabel();
        this.$objectMap.put("$JLabel20", this.$JLabel20);
        this.$JLabel20.setName("$JLabel20");
        this.$JLabel20.setText(I18n.t((String)"isisfish.wizardGroupCreation.numberGroups", (Object[])new Object[0]));
        this.createFieldNumberOfGroup();
        this.$JLabel21 = new JLabel();
        this.$objectMap.put("$JLabel21", this.$JLabel21);
        this.$JLabel21.setName("$JLabel21");
        this.$JLabel21.setText(I18n.t((String)"isisfish.wizardGroupCreation.timeStep", (Object[])new Object[0]));
        this.createFieldStep();
        this.$JLabel22 = new JLabel();
        this.$objectMap.put("$JLabel22", this.$JLabel22);
        this.$JLabel22.setName("$JLabel22");
        this.$JLabel22.setText(I18n.t((String)"isisfish.wizardGroupCreation.undefinedGrowthEquation", (Object[])new Object[0]));
        this.createNavButton();
        this.createPrev();
        this.createNext();
        this.createFinish();
        this.createCancel();
        this.createGroupLengthType();
        this.setName("wizardGroup");
        this.setLayout(new BorderLayout());
        this.$completeSetup();
    }
}

