/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.launcher;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.launcher.SimulationItem;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.util.ssh.InvalidPassphraseException;
import fr.ifremer.isisfish.util.ssh.ProgressMonitor;
import fr.ifremer.isisfish.util.ssh.SSHAgent;
import fr.ifremer.isisfish.util.ssh.SSHException;
import fr.ifremer.isisfish.util.ssh.SSHUserInfo;
import fr.ifremer.isisfish.util.ssh.SSHUtils;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.MD5InputStream;
import org.nuiton.util.StringUtil;
import org.nuiton.util.ZipUtil;

public class SSHSimulatorLauncher
implements SimulatorLauncher {
    protected static Log log = LogFactory.getLog(SSHSimulatorLauncher.class);
    protected Configuration freemarkerConfiguration;
    protected static final String QSUB_SCRIPT_TEMPLATE = "templates/ssh/qsub-script.ftl";
    protected static Session sshSession;
    protected static Session sshSftpSession;

    public SSHSimulatorLauncher() {
        this.initFreemarker();
    }

    protected void initFreemarker() {
        this.freemarkerConfiguration = new Configuration();
        this.freemarkerConfiguration.setDefaultEncoding("utf-8");
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(SSHSimulatorLauncher.class, "/");
        this.freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
    }

    protected void message(SimulationControl control, String message) {
        if (log.isInfoEnabled()) {
            log.info((Object)message);
        }
        if (control != null) {
            control.setText(message);
        }
    }

    @Override
    public int maxSimulationThread() {
        int maxSimulationThread = IsisFish.config.getSimulatorSshMaxThreads();
        if (maxSimulationThread <= 0) {
            maxSimulationThread = 1;
        }
        return maxSimulationThread;
    }

    @Override
    public int getCheckProgressionInterval() {
        int interval = IsisFish.config.getSimulatorSshControlCheckInterval();
        return interval;
    }

    public String toString() {
        return I18n.t((String)"isisfish.simulator.launcher.remote", (Object[])new Object[0]);
    }

    @Override
    public void simulationStopRequest(SimulationJob job) throws RemoteException {
        try {
            this.getSSHSession();
        }
        catch (JSchException e) {
            throw new RemoteException("Can't connect", e);
        }
        SimulationItem simulationItem = job.getItem();
        if (simulationItem.isStandaloneSimulation()) {
            try {
                this.sendStopSimulationRequest(sshSession, simulationItem.getControl().getId());
            }
            catch (SSHException e) {
                throw new RemoteException("Can't connect", e);
            }
        }
        if (simulationItem.isLastSimulation()) {
            String simulationid = simulationItem.getControl().getId();
            String shortSimulationId = simulationid.substring(0, simulationid.lastIndexOf(95));
            try {
                this.sendStopSimulationRequest(sshSession, shortSimulationId);
            }
            catch (SSHException e) {
                throw new RemoteException("Can't connect", e);
            }
        }
    }

    @Override
    public void simulate(SimulationService simulationService, SimulationItem simulationItem) throws RemoteException {
        SimulationControl control = simulationItem.getControl();
        File simulationZip = simulationItem.getSimulationZip();
        String simulationPrescript = simulationItem.getGeneratedPrescriptContent();
        if (StringUtils.isBlank((CharSequence)IsisFish.config.getSimulatorSshUsername())) {
            throw new RemoteException("Username is empty");
        }
        try {
            String simulationid = control.getId();
            this.message(control, I18n.t((String)"isisfish.simulation.remote.message.connection", (Object[])new Object[0]));
            Session sshSession = this.getSSHSession();
            this.message(control, I18n.t((String)"isisfish.simulation.remote.message.upload", (Object[])new Object[0]));
            String simulationRemotePath = this.uploadSimulationIfNecessary(sshSession, simulationItem, simulationid, simulationZip);
            String remoteResultZip = this.getRemoteResultArchivePath(simulationid);
            this.message(control, I18n.t((String)"isisfish.simulation.remote.message.waitingstart", (Object[])new Object[0]));
            String simulationPreScriptPath = this.uploadPreScriptIfNecessary(sshSession, control.getId(), simulationPrescript);
            this.startSimulation(simulationItem, simulationid, simulationRemotePath, remoteResultZip, simulationPreScriptPath);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"isisfish.error.simulation.remote.global", (Object[])new Object[0]));
            }
            throw new RemoteException(I18n.t((String)"isisfish.error.simulation.remote.global", (Object[])new Object[0]), e);
        }
    }

    @Override
    public SimulationStorage getSimulationStorage(SimulationService simulationService, SimulationControl control) throws RemoteException {
        String simulationId = control.getId();
        SimulationStorage simulationStorage = SimulationStorage.getSimulation(simulationId);
        return simulationStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateControl(SimulationService simulationService, SimulationControl control) throws RemoteException {
        block34: {
            try {
                this.getSSHSession();
            }
            catch (JSchException e) {
                throw new RemoteException("Can't connect", e);
            }
            try {
                SimulationControl simulationControl;
                block32: {
                    block31: {
                        try {
                            File controlFile = this.downloadSimulationFile(sshSession, control.getId(), "control");
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Control have been downloaded : " + controlFile.getAbsolutePath()));
                            }
                            SimulationControl simulationControl2 = control;
                            synchronized (simulationControl2) {
                                SimulationStorage.readControl(controlFile, control, "stop");
                            }
                            controlFile.delete();
                        }
                        catch (SSHException e) {
                            if (!log.isDebugEnabled()) break block31;
                            log.debug((Object)I18n.t((String)"Remote control file doesn't exists %s", (Object[])new Object[]{e.getMessage()}));
                        }
                    }
                    try {
                        File resultArchiveFile;
                        File md5ControlFile = this.downloadResultsMD5File(sshSession, control.getId());
                        if (md5ControlFile == null) break block32;
                        control.setText(I18n.t((String)"isisfish.simulation.remote.message.downloadresults", (Object[])new Object[0]));
                        String md5sum = FileUtils.readFileToString((File)md5ControlFile);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("MD5 Control file have been downloaded : " + md5ControlFile.getAbsolutePath()));
                        }
                        if ((resultArchiveFile = this.downloadResultsArchive(sshSession, control, md5sum)) != null) {
                            ZipUtil.uncompressFiltred((File)resultArchiveFile, (File)SimulationStorage.getSimulationDirectory(), (String[])new String[0]);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Simulation imported : " + resultArchiveFile.getAbsolutePath()));
                            }
                            resultArchiveFile.delete();
                            simulationControl = control;
                            synchronized (simulationControl) {
                                SimulationStorage.readControl(control.getId(), control, "stop");
                            }
                            this.clearSimulationFiles(sshSession, control);
                        } else if (log.isWarnEnabled()) {
                            log.warn((Object)"Simulation zip download failed");
                        }
                        md5ControlFile.delete();
                    }
                    catch (SSHException e) {
                        if (!log.isDebugEnabled()) break block32;
                        log.debug((Object)I18n.t((String)"Can't download archive : %s", (Object[])new Object[]{e.getMessage()}));
                    }
                }
                try {
                    File infoFile = this.downloadSimulationFile(sshSession, control.getId(), "information");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Information have been downloaded : " + infoFile.getAbsolutePath()));
                    }
                    Properties infoProperties = new Properties();
                    try (FileInputStream isInfoFile = new FileInputStream(infoFile);){
                        infoProperties.load(isInfoFile);
                    }
                    if (!StringUtils.isEmpty((CharSequence)infoProperties.getProperty("exception"))) {
                        simulationControl = control;
                        synchronized (simulationControl) {
                            control.setStopSimulationRequest(true);
                        }
                    }
                    infoFile.delete();
                }
                catch (SSHException e) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)I18n.t((String)"Remote information file doesn't exists %s", (Object[])new Object[]{e.getMessage()}));
                    }
                }
            }
            catch (IOException e) {
                if (!log.isErrorEnabled()) break block34;
                log.error((Object)I18n.t((String)"Can't download file", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    protected synchronized Session getSSHSession() throws JSchException {
        if (sshSession == null || !sshSession.isConnected()) {
            sshSession = this.openSSHSession();
        }
        return sshSession;
    }

    protected Session openSSHSession() throws JSchException {
        SSHUserInfo ui;
        Session session;
        File sshKey;
        boolean sshKeyUsed;
        block13: {
            JSch jsch = new JSch();
            String host = IsisFish.config.getSimulatorSshServer();
            String username = IsisFish.config.getSimulatorSshUsername();
            int port = 22;
            if (host.indexOf(58) > 0) {
                block12: {
                    String sPort = host.substring(host.indexOf(58) + 1);
                    try {
                        port = Integer.parseInt(sPort);
                    }
                    catch (NumberFormatException e) {
                        if (!log.isWarnEnabled()) break block12;
                        log.warn((Object)I18n.t((String)"isisfish.error.simulation.remote.wrongportvalue", (Object[])new Object[]{sPort}));
                    }
                }
                host = host.substring(0, host.indexOf(58));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"Try to log on %s@%s:%d", (Object[])new Object[]{username, host, port}));
            }
            sshKeyUsed = false;
            sshKey = IsisFish.config.getSSHPrivateKeyFilePath();
            if (sshKey.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"Ssh key found '%s' will be used to connect to", (Object[])new Object[]{sshKey.getAbsoluteFile(), host}));
                }
                jsch.addIdentity(sshKey.getAbsolutePath());
                sshKeyUsed = true;
            } else if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"Can't read ssh key : %s", (Object[])new Object[]{sshKey}));
            }
            session = jsch.getSession(username, host, port);
            ui = new SSHUserInfo();
            if (sshKeyUsed) {
                String passphrase = null;
                try {
                    passphrase = SSHAgent.getAgent().getPassphrase(sshKey);
                    ui.setPassphrase(passphrase);
                }
                catch (InvalidPassphraseException e) {
                    if (!log.isWarnEnabled()) break block13;
                    log.warn((Object)"Can't key passphrase for key", (Throwable)e);
                }
            }
        }
        session.setUserInfo((UserInfo)ui);
        session.connect(20000);
        if (session.isConnected() && sshKeyUsed && ui.getPassword() != null) {
            this.putSshKeyOnRemoteServer(session, sshKey);
        }
        return session;
    }

    protected void closeSSHSession(Session session) {
        if (session != null) {
            session.disconnect();
        }
    }

    protected void putSshKeyOnRemoteServer(Session session, File sshKey) throws JSchException {
        block7: {
            File publicKey = new File(sshKey.getAbsoluteFile() + ".pub");
            String command = "test -d .ssh||mkdir .ssh;echo \"%s\" >> .ssh/authorized_keys";
            try {
                List contents = FileUtils.readLines((File)publicKey);
                if (contents != null && contents.size() == 1) {
                    command = String.format(command, contents.get(0));
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Add key on remote authorized keys");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("command is : " + command));
                    }
                    SSHUtils.exec(session, command);
                }
            }
            catch (IOException e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)I18n.t((String)"Error while uploading public key to remote serveur authorized_keys", (Object[])new Object[0]), (Throwable)e);
                }
            }
            catch (SSHException e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)I18n.t((String)"Error while uploading public key to remote serveur authorized_keys", (Object[])new Object[0]), (Throwable)e);
            }
        }
    }

    protected String uploadSimulationIfNecessary(Session session, SimulationItem simulationItem, String simulationid, File simulationFile) throws SSHException {
        String remoteTemp = this.getRemoteTempDirectory();
        String remotePath = null;
        if (!simulationItem.isStandaloneSimulationZip()) {
            String shortSimulationId = simulationid.substring(0, simulationid.lastIndexOf(95));
            String shortSimulationZip = "simulation-" + shortSimulationId + "-preparation.zip";
            remotePath = remoteTemp + shortSimulationZip;
            if (simulationItem.getSimulationNumber() == 0) {
                this.uploadSimulation(session, remoteTemp, remotePath, simulationFile);
            }
        } else {
            String simulationZip = "simulation-" + simulationid + "-preparation.zip";
            remotePath = remoteTemp + simulationZip;
            this.uploadSimulation(session, remoteTemp, remotePath, simulationFile);
        }
        return remotePath;
    }

    protected void uploadSimulation(Session session, String remoteDirectory, String remoteSimulationZipPath, File simulationFile) throws SSHException {
        int exit;
        String command = "test -d \"" + remoteDirectory + "\"||mkdir -p \"" + remoteDirectory + "\"";
        if (log.isInfoEnabled()) {
            log.info((Object)("Creating remote temp directory (if not exists) " + remoteDirectory));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Executing command : " + command));
            }
        }
        if ((exit = SSHUtils.exec(session, command)) != 0) {
            throw new SSHException(I18n.t((String)"Command '%s' fail to execute", (Object[])new Object[]{command}));
        }
        SSHUtils.scpTo(session, simulationFile, remoteSimulationZipPath);
    }

    protected File downloadResultsArchive(Session session, SimulationControl simulationControl, String md5sum) throws SSHException, IOException {
        String localMd5;
        File localFile = File.createTempFile("simulation-results", ".zip");
        localFile.deleteOnExit();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Downloading results in " + localFile.getAbsolutePath()));
        }
        String simulationId = simulationControl.getId();
        String remoteFile = this.getRemoteResultArchivePath(simulationId);
        try {
            ControlProgressMonitor progress = new ControlProgressMonitor(simulationControl);
            SSHUtils.scpFrom(session, remoteFile, localFile, progress);
        }
        catch (SSHException e) {
            localFile.delete();
            throw e;
        }
        if (!StringUtils.isEmpty((CharSequence)md5sum) && !(localMd5 = StringUtil.asHex((byte[])MD5InputStream.hash((InputStream)new BufferedInputStream(new FileInputStream(localFile))))).equals(md5sum)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Warning md5 checksum failed (got " + localMd5 + ", expected : " + md5sum + ")"));
            }
            localFile.delete();
            localFile = null;
        }
        return localFile;
    }

    protected File downloadSimulationFile(Session sshSession, String simulationId, String fileName) throws IOException, SSHException {
        File localFile = null;
        String remoteFile = IsisFish.config.getSimulatorSshDataPath();
        remoteFile = remoteFile + "/simulations";
        remoteFile = remoteFile + "/" + simulationId;
        remoteFile = remoteFile + "/" + fileName;
        localFile = File.createTempFile(simulationId, fileName);
        try {
            SSHUtils.scpFrom(sshSession, remoteFile, localFile);
        }
        catch (SSHException e) {
            localFile.delete();
            throw e;
        }
        return localFile;
    }

    protected File downloadResultsMD5File(Session sshSession, String simulationId) throws IOException, SSHException {
        String remoteFile = this.getRemoteResultArchivePath(simulationId) + ".md5";
        File localFile = File.createTempFile(simulationId, ".md5");
        try {
            SSHUtils.scpFrom(sshSession, remoteFile, localFile);
        }
        catch (SSHException e) {
            localFile.delete();
            throw e;
        }
        return localFile;
    }

    protected void clearSimulationFiles(Session session, SimulationControl control) throws IOException, SSHException {
        control.setText(I18n.t((String)"isisfish.simulation.remote.message.deletingfiles", (Object[])new Object[0]));
        String simulationId = control.getId();
        String command = "rm -f \"" + this.getRemoteTempDirectory() + "simulation-" + simulationId + "-\"*";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deleting simulation files with command : " + command));
        }
        SSHUtils.exec(session, command);
    }

    protected String uploadSimulationScript(Session session, String simulationid, File simulationScript) throws SSHException {
        String remotePath = this.getRemoteTempDirectory();
        remotePath = remotePath + "simulation-" + simulationid + "-script.seq";
        SSHUtils.scpTo(session, simulationScript, remotePath);
        return remotePath;
    }

    protected String getRemoteResultArchivePath(String simulationId) {
        String remotePath = this.getRemoteTempDirectory();
        remotePath = remotePath + "simulation-" + simulationId + "-result.zip";
        return remotePath;
    }

    protected String uploadPreScriptIfNecessary(Session session, String simulationId, String simulationPreScript) throws SSHException, IOException {
        if (StringUtils.isEmpty((CharSequence)simulationPreScript)) {
            return null;
        }
        File tempPreScriptFile = File.createTempFile("simulation-" + simulationId + "-prescript", ".bsh");
        tempPreScriptFile.deleteOnExit();
        FileUtils.writeStringToFile((File)tempPreScriptFile, (String)simulationPreScript, (String)"utf-8");
        String remotePath = this.getRemoteTempDirectory();
        remotePath = remotePath + "simulation-" + simulationId + "-prescript.bsh";
        SSHUtils.scpTo(session, tempPreScriptFile, remotePath);
        return remotePath;
    }

    protected void startSimulation(SimulationItem simulationItem, String simulationid, String simulationRemoteZipPath, String remoteResultZip, String simulationPreScriptPath) throws Exception {
        if (simulationItem.isStandaloneSimulation()) {
            File simulationPSBScript = this.getLaunchSimulationScriptFile(simulationid, simulationRemoteZipPath, true, remoteResultZip, simulationPreScriptPath, false);
            String scriptRemotePath = this.uploadSimulationScript(sshSession, simulationid, simulationPSBScript);
            simulationPSBScript.delete();
            this.sendStartSimulationRequest(sshSession, simulationid, scriptRemotePath, -1);
        } else if (simulationItem.isLastSimulation()) {
            String shortSimulationId = simulationid.substring(0, simulationid.lastIndexOf(95));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Last simulation start requested, send multijob start request for " + shortSimulationId));
            }
            File simulationPSBScript = this.getLaunchSimulationScriptFile(shortSimulationId, simulationRemoteZipPath, simulationItem.isStandaloneSimulationZip(), remoteResultZip, simulationPreScriptPath, true);
            String scriptRemotePath = this.uploadSimulationScript(sshSession, shortSimulationId, simulationPSBScript);
            simulationPSBScript.delete();
            this.sendStartSimulationRequest(sshSession, shortSimulationId, scriptRemotePath, simulationItem.getSimulationNumber());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"Current simulation is not last simulation in pool, skip start");
        }
    }

    protected File getLaunchSimulationScriptFile(String simuationId, String simulationZip, boolean standaloneZip, String simulationResultZip, String preScriptPath, boolean multipleSimulationScript) throws IOException {
        File tempScript = File.createTempFile("simulation-" + simuationId + "-script", ".seq");
        tempScript.deleteOnExit();
        String fileContent = this.getSimulationScriptLaunchContent(QSUB_SCRIPT_TEMPLATE, simuationId, simulationZip, standaloneZip, simulationResultZip, preScriptPath, multipleSimulationScript);
        FileUtils.writeStringToFile((File)tempScript, (String)fileContent, (String)"utf-8");
        return tempScript;
    }

    protected String getSimulationScriptLaunchContent(String templateName, String simuationId, String simulationZip, boolean standaloneZip, String simulationZipResult, String preScriptPath, boolean multipleSimulationScript) throws IOException {
        String scriptContent = null;
        String remotePreScript = preScriptPath;
        if (remotePreScript == null) {
            remotePreScript = "";
        }
        try {
            Template template = this.freemarkerConfiguration.getTemplate(templateName);
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("isishome", IsisFish.config.getSimulatorSshIsisHome());
            root.put("isistemp", this.getRemoteTempDirectory());
            root.put("javapath", IsisFish.config.getSimulatorSshJavaPath());
            root.put("javamemory", IsisFish.config.getSimulatorSshMaxMemory());
            root.put("simulationid", simuationId);
            root.put("simulationzip", simulationZip);
            root.put("simulationstandalonezip", standaloneZip);
            root.put("simulationresultzip", simulationZipResult);
            root.put("simulationprescript", remotePreScript);
            root.put("qsubmutiplejob", multipleSimulationScript);
            StringWriter out = new StringWriter();
            template.process(root, (Writer)out);
            ((Writer)out).flush();
            scriptContent = ((Object)out).toString();
        }
        catch (TemplateException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"Process template error", (Object[])new Object[0]), (Throwable)e);
            }
            throw new IOException(I18n.t((String)"Process template error", (Object[])new Object[0]), e);
        }
        return scriptContent;
    }

    protected void sendStartSimulationRequest(Session session, String simulationId, String scriptRemotePath, int lastSimulationNumber) throws SSHException {
        StringWriter output;
        int exit;
        String remoteFilenameId = this.getRemoteTempDirectory() + "simulation-" + simulationId + "-pbs.id";
        String command = IsisFish.config.getSimulatorSshPbsBinPath() + "/qsub";
        String qsubOptions = IsisFish.config.getSimulatorSshPbsQsubOptions();
        if (StringUtils.isNotEmpty((CharSequence)qsubOptions)) {
            command = command + " " + qsubOptions;
        }
        if (lastSimulationNumber >= 0) {
            command = command + " -J 0-" + String.valueOf(lastSimulationNumber);
        }
        command = command + " \"" + scriptRemotePath + "\"|tee \"" + remoteFilenameId + "\"";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send qsub job starting command : " + command));
        }
        if ((exit = SSHUtils.exec(session, command, output = new StringWriter())) != 0) {
            throw new SSHException(I18n.t((String)"Command '%s' fail to execute", (Object[])new Object[]{command}));
        }
        String out = ((Object)output).toString();
        if (out.trim().matches("\\d+(\\[\\])?\\.\\w+") && log.isInfoEnabled()) {
            log.info((Object)("Job submitted with job id : " + out));
        }
    }

    protected void sendStopSimulationRequest(Session session, String simulationId) throws SSHException {
        String remoteFilenameId = this.getRemoteTempDirectory() + "simulation-" + simulationId + "-pbs.id";
        String command = IsisFish.config.getSimulatorSshPbsBinPath() + "/qdel `cat \"" + remoteFilenameId + "\"`";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Send stop request : " + command));
        }
        SSHUtils.exec(session, command);
    }

    protected String getRemoteTempDirectory() {
        String remotePath = IsisFish.config.getSimulatorSshTmpPath();
        if (!remotePath.startsWith("/")) {
            remotePath = IsisFish.config.getSimulatorSshUserHome() + "/" + remotePath;
        }
        if (!remotePath.endsWith("/")) {
            remotePath = remotePath + "/";
        }
        return remotePath;
    }

    protected static class ControlProgressMonitor
    extends ProgressMonitor {
        protected SimulationControl control;

        public ControlProgressMonitor(SimulationControl control) {
            this.control = control;
        }

        @Override
        public void init(long max) {
            super.init(max);
            this.control.setProgressMax(this.initFileSize);
        }

        @Override
        public void count(long len) {
            super.count(len);
            this.control.setProgress(this.totalLength);
        }

        @Override
        public void end() {
            super.end();
            this.control.setProgress(this.initFileSize);
        }
    }
}

