/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import java.util.HashMap;
import java.util.Map;

public class SimulationPlanContext {
    protected String id;
    protected int number = 0;
    protected SimulationParameter param;
    protected Map<String, Object> values = new HashMap<String, Object>();

    public SimulationPlanContext(String id, SimulationParameter param) {
        this.id = id;
        this.param = param;
    }

    public String getId() {
        return this.id;
    }

    public int getNumber() {
        return this.number;
    }

    public void incNumber() {
        ++this.number;
    }

    public SimulationParameter getParam() {
        return this.param;
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    public void setValue(String key, Object value) {
        this.values.put(key, value);
    }

    public SimulationStorage getLastSimulation() {
        SimulationStorage result = this.getSimulation(this.getNumber() - 1);
        return result;
    }

    public SimulationStorage getSimulation(int number) {
        SimulationStorage result = null;
        if (0 <= number && number <= this.getNumber()) {
            result = SimulationStorage.getSimulation(this.id + "_" + number);
        }
        return result;
    }
}

