/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.SimulationPlanContext;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;

public class OptimizationContext
extends SimulationPlanContext {
    protected SimulationJob job;
    protected List<List<SimulationStorage>> generations = new ArrayList<List<SimulationStorage>>();
    protected List<SimulationStorage> nextSimulations;

    public OptimizationContext(String id, SimulationParameter param, SimulationJob job) {
        super(id, param);
        this.job = job;
    }

    public List<SimulationStorage> getNextSimulations() {
        if (this.nextSimulations == null) {
            this.nextSimulations = new ArrayList<SimulationStorage>();
        }
        return this.nextSimulations;
    }

    public List<SimulationStorage> clearNextSimulation() {
        List<SimulationStorage> result = this.nextSimulations;
        if (CollectionUtils.isNotEmpty(result)) {
            this.generations.add(result);
            this.nextSimulations = null;
        }
        return result;
    }

    public List<SimulationStorage> getLastSimulations() {
        List<SimulationStorage> result = this.getGeneration(this.generations.size() - 1);
        return result;
    }

    public SimulationStorage newSimulation() {
        try {
            String simId = this.id + "_" + this.number;
            SimulationParameter childParam = this.param.copy();
            childParam.setSimulationPlanNumber(this.number);
            SimulationStorage result = SimulationStorage.importAndRenameZip(this.job.getItem().getSimulationZip(), simId);
            this.incNumber();
            this.addSimulation(result);
            return result;
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException("can't create new simulation", eee);
        }
    }

    protected void addSimulation(SimulationStorage s) {
        this.getNextSimulations().add(s);
    }

    public void newSimulation(Factor ... factors) {
        SimulationStorage s = this.newSimulation();
        ArrayList<Factor> colFactors = new ArrayList<Factor>();
        Collections.addAll(colFactors, factors);
        String script = FactorHelper.generatePreScript(colFactors);
        SimulationParameter childParam = s.getParameter();
        childParam.setGeneratedPreScript(script);
    }

    public int getCurrentGeneration() {
        return this.generations.size();
    }

    public int getSimulationNumber() {
        return this.number;
    }

    public List<SimulationStorage> getGeneration(int n) {
        List<SimulationStorage> result = null;
        if (n >= 0 && CollectionUtils.isNotEmpty(this.generations)) {
            result = this.generations.get(n);
        }
        return result;
    }
}

