/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.MetierSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpeciesAbstract;
import fr.ifremer.isisfish.equation.TargetSpeciesTargetFactorEquation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class TargetSpeciesImpl
extends TargetSpeciesAbstract {
    private static final long serialVersionUID = 8028733540961872729L;
    private static Log log = LogFactory.getLog(TargetSpeciesImpl.class);

    @Override
    public Equation getTargetFactorEquation() {
        if (super.getTargetFactorEquation() == null) {
            try {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                Equation eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("TargetFactor");
                eq.setLanguage("java");
                eq.setJavaInterface(TargetSpeciesTargetFactorEquation.class);
                eq.update();
                this.setTargetFactorEquation(eq);
            }
            catch (TopiaException eee) {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.create.equation", (Object[])new Object[0]), eee);
            }
        }
        return super.getTargetFactorEquation();
    }

    public void setTargetFactorEquationContent(String content) {
        try {
            Equation eq = this.getTargetFactorEquation();
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.change.equation", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public void setMetierSeasonInfo(MetierSeasonInfo value) {
        super.setMetierSeasonInfo(value);
        this.setEquationName(this.getTargetFactorEquation());
    }

    @Override
    public void setSpecies(Species value) {
        super.setSpecies(value);
        this.setEquationName(this.getTargetFactorEquation());
    }

    protected void setEquationName(Equation eq) {
        if (this.getMetierSeasonInfo() != null && this.getMetierSeasonInfo().getMetier() != null && this.getSpecies() != null) {
            eq.setName(this.getMetierSeasonInfo().getMetier().getName() + "-" + this.getSpecies().getName() + "(" + this.getMetierSeasonInfo().toString() + ")");
        }
    }

    @Override
    public double getTargetFactor(PopulationGroup group) {
        double result;
        block3: {
            result = 0.0;
            try {
                Equation eq = this.getTargetFactorEquation();
                Species species = this.getSpecies();
                MetierSeasonInfo msi = this.getMetierSeasonInfo();
                boolean primaryCatch = this.getPrimaryCatch();
                result = eq.evaluate("group", group, "species", species, "infoMetier", msi, "primaryCatch", primaryCatch);
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in target factor equation");
                }
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    @Override
    public String toString() {
        String result = "" + this.getTargetFactorEquation();
        return result;
    }
}

