/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Gear;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.SetOfVesselsAbstract;
import fr.ifremer.isisfish.equation.SoVTechnicalEfficiencyEquation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaException;

public class SetOfVesselsImpl
extends SetOfVesselsAbstract {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(SetOfVesselsImpl.class);

    @Override
    public FisheryRegion getFisheryRegion() {
        try {
            FisheryRegion result = RegionStorage.getFisheryRegion(this.getTopiaContext());
            return result;
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't get fishery region", eee);
        }
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        Equation eq = this.getTechnicalEfficiencyEquation();
        if (eq != null) {
            eq.setName(this.getName());
        }
    }

    @Override
    public double getTechnicalEfficiency(Metier metier) {
        double result;
        block4: {
            result = 1.0;
            try {
                Equation eq = this.getTechnicalEfficiencyEquation();
                if (eq != null) {
                    Gear gear = metier.getGear();
                    result = eq.evaluate("metier", metier, "gear", gear);
                }
            }
            catch (Exception eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"Error in technical efficiency equation");
                }
                if (!log.isDebugEnabled()) break block4;
                log.debug((Object)"StackTrace", (Throwable)eee);
            }
        }
        return result;
    }

    public void setTechnicalEfficiencyEquationContent(String content) {
        try {
            Equation eq = this.getTechnicalEfficiencyEquation();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("TechnicalEfficiency");
                eq.setJavaInterface(SoVTechnicalEfficiencyEquation.class);
                eq.setLanguage("java");
                this.setTechnicalEfficiencyEquation(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.change.equation", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public String toString() {
        String result = this.getName();
        return result;
    }
}

