/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.data.Mooring;
import fr.ifremer.echobase.entities.data.MooringImpl;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.services.service.UserDbPersistenceService;
import fr.ifremer.echobase.services.service.importdata.MooringCodeAlreadyExistException;
import fr.ifremer.echobase.services.service.importdata.MooringService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CreateMooring
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CreateMooring.class);
    protected Mooring mooring;
    protected String missionId;
    protected Map<String, String> missions;
    @Inject
    protected transient MooringService mooringService;
    @Inject
    protected transient UserDbPersistenceService userDbPersistenceService;

    public Mooring getMooring() {
        if (this.mooring == null) {
            this.mooring = new MooringImpl();
        }
        return this.mooring;
    }

    public Map<String, String> getMissions() {
        return this.missions;
    }

    public void setMissionId(String missionId) {
        this.missionId = missionId;
    }

    public String getMissionId() {
        return this.missionId;
    }

    public final String input() throws Exception {
        this.missions = this.userDbPersistenceService.loadSortAndDecorate(Mission.class);
        return "input";
    }

    @InputConfig(methodName="input")
    public String execute() throws Exception {
        Preconditions.checkNotNull((Object)this.mooring);
        String result = "input";
        try {
            Mission mission = this.userDbPersistenceService.getMission(this.missionId);
            this.mooring.setMission(mission);
            Mooring mooringSaved = this.mooringService.createMooring(this.mooring);
            if (log.isInfoEnabled()) {
                log.info((Object)("Created mooring : " + mooringSaved.getTopiaId()));
            }
            this.addFlashMessage(this.t("echobase.information.mooring.created", new Object[]{mooringSaved.getCode()}));
            result = "success";
        }
        catch (MooringCodeAlreadyExistException e) {
            this.addFieldError("mooring.code", this.t("echobase.error.mooring.code.already.exist", new Object[0]));
        }
        return result;
    }
}

