/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.spatial;

import fr.ifremer.echobase.persistence.JdbcConfiguration;
import fr.ifremer.echobase.services.service.spatial.SpatialService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import fr.ifremer.echobase.ui.actions.spatial.ShowSpatialModel;
import javax.inject.Inject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Show
extends EchoBaseActionSupport {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(Show.class);
    @Inject
    protected transient SpatialService spatialService;
    protected final ShowSpatialModel model = new ShowSpatialModel();
    protected boolean canAddSpatial;
    protected String lizmapRepository;

    public ShowSpatialModel getModel() {
        return this.model;
    }

    public String getLizmapUrl() {
        String url = this.getServiceContext().getConfiguration().getLizmapUrl() + "?" + "repository=" + this.lizmapRepository;
        return url;
    }

    public String getLizmapRepository() {
        return this.lizmapRepository;
    }

    public boolean isCanAddSpatial() {
        return this.canAddSpatial;
    }

    public String execute() throws Exception {
        JdbcConfiguration dbConf = this.getEchoBaseSession().getWorkingDbConfiguration();
        this.lizmapRepository = this.spatialService.generateMaps(dbConf);
        if (log.isInfoEnabled()) {
            log.info((Object)("Loading spatial view for repository: " + this.lizmapRepository));
        }
        this.model.setJdbcUrl(this.getServiceContext().getUserDbUrl());
        this.model.setWithSpatial(this.spatialService.isSpatialAware());
        this.canAddSpatial = !this.model.isWithSpatial() && this.spatialService.isPostgresql();
        return "success";
    }
}

