<%--
  #%L
  EchoBase :: UI
  %%
  Copyright (C) 2011 - 2013 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<title>
  <s:text name="echobase.title.show.spatial"/>
</title>

<script type="text/javascript"
        src="<s:url value='/js/gridHelper.js' />"></script>

<s:if test="model.withSpatial">

  <s:form namespace="/spatial" method="POST" enctype="multipart/form-data">

    <div class="toolbar">
      <ul class="toolbar floatRight">
        <li>
          <s:submit action='refreshSpatialViews' key="echobase.action.reloadSpatialData"/>
        </li>
      </ul>
    </div>
  </s:form>

  <iframe id="spatialViewContent" src="${lizmapUrl}"></iframe>

</div>


</s:if>
<s:else>

  <p>
    <s:text name="echobase.message.no.spatial.database.support"/>
  </p>

  <s:if test="canAddSpatial">
    <br/>
    <s:form id="createForm" namespace="/spatial">
      <ul class="toolbar floatLeft">

        <li>
          <s:submit theme="simple" action="addSpatial"
                    key="echobase.action.workingDbconfiguration.addSpatial"/>
        </li>

      </ul>
    </s:form>
  </s:if>
</s:else>


