/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.io.EchoBaseIOUtil;
import fr.ifremer.echobase.io.InputFile;
import fr.ifremer.echobase.services.service.importdata.AbstractImportConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.FileUtil;

public abstract class AbstractConfigureImport<M extends AbstractImportConfiguration>
extends AbstractConfigureAction<M> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractConfigureImport.class);

    protected AbstractConfigureImport(Class<M> modelType) {
        super(modelType);
    }

    protected void prepareExecuteAction(M model) throws IOException {
        File tempDirectory = FileUtils.getTempDirectory();
        File dataDirectory = new File(tempDirectory, "echobase-importData-" + System.currentTimeMillis());
        FileUtil.createDirectoryIfNecessary((File)dataDirectory);
        model.setWorkingDirectory(dataDirectory);
        if (log.isInfoEnabled()) {
            log.info((Object)("Temporary directory to use : " + dataDirectory));
        }
        for (InputFile inputFile : model.getInputFiles()) {
            if (!inputFile.hasFile()) continue;
            EchoBaseIOUtil.copyFile((InputFile)inputFile, (File)dataDirectory);
        }
    }
}

