/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.opensymphony.xwork2.ActionContext;
import fr.ifremer.echobase.config.EchoBaseConfiguration;
import fr.ifremer.echobase.entities.TopiaEchoBaseInternalPersistenceContext;
import fr.ifremer.echobase.entities.TopiaEchoBasePersistenceContext;
import fr.ifremer.echobase.entities.spatial.SpatialDataCache;
import fr.ifremer.echobase.persistence.EchoBaseDbMeta;
import fr.ifremer.echobase.persistence.EchoBaseEntityHelper;
import fr.ifremer.echobase.persistence.EchobaseTopiaContexts;
import fr.ifremer.echobase.services.DefaultEchoBaseServiceContext;
import fr.ifremer.echobase.services.EchoBaseServiceContext;
import fr.ifremer.echobase.ui.EchoBaseSession;
import fr.ird.converter.FloatConverter;
import java.beans.Introspector;
import java.io.File;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.i18n.init.DefaultI18nInitializer;
import org.nuiton.i18n.init.I18nInitializer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.converter.ConverterUtil;

public class EchoBaseApplicationContext {
    private static final Log log = LogFactory.getLog(EchoBaseApplicationContext.class);
    private static final String APPLICATION_CONTEXT_PARAMETER = "echobaseApplicationContext";
    protected Set<EchoBaseSession> sessions;
    protected EchoBaseConfiguration configuration;
    protected EchoBaseDbMeta dbMeta;
    protected TopiaContext internalRootContext;
    protected boolean defaultUsersCreated;
    protected final SpatialDataCache spatialDataCache = new SpatialDataCache();

    public static EchoBaseApplicationContext getApplicationContext(ActionContext actionContext) {
        Map application = actionContext.getApplication();
        EchoBaseApplicationContext result = (EchoBaseApplicationContext)application.get(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static EchoBaseApplicationContext getApplicationContext(ServletContext servletContext) {
        EchoBaseApplicationContext result = (EchoBaseApplicationContext)servletContext.getAttribute(APPLICATION_CONTEXT_PARAMETER);
        return result;
    }

    public static void setApplicationContext(ServletContext servletContext, EchoBaseApplicationContext applicationContext) {
        servletContext.setAttribute(APPLICATION_CONTEXT_PARAMETER, (Object)applicationContext);
    }

    public static void removeApplicationContext(ServletContext servletContext) {
        servletContext.removeAttribute(APPLICATION_CONTEXT_PARAMETER);
    }

    public Set<EchoBaseSession> getEchoBaseSessions() {
        return this.sessions;
    }

    public synchronized void registerEchoBaseSession(EchoBaseSession session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        if (this.sessions == null) {
            this.sessions = Sets.newHashSet();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Register user session for [" + session.getUser().getEmail() + "]"));
        }
        this.sessions.add(session);
    }

    public synchronized void destroyEchoBaseSession(EchoBaseSession session) {
        Preconditions.checkNotNull((Object)session);
        Preconditions.checkNotNull((Object)session.getUser());
        Preconditions.checkNotNull((Object)this.sessions);
        if (log.isInfoEnabled()) {
            log.info((Object)("Destroy user session for [" + session.getUser().getEmail() + "]"));
        }
        this.sessions.remove(session);
        session.close();
    }

    public void init() {
        DefaultI18nInitializer i18nInitializer = new DefaultI18nInitializer("echobase-i18n");
        i18nInitializer.setMissingKeyReturnNull(true);
        I18n.init((I18nInitializer)i18nInitializer, (Locale)Locale.getDefault());
        Converter converter = ConverterUtil.getConverter(Float.class);
        if (converter != null) {
            ConvertUtils.deregister(Float.class);
        }
        ConvertUtils.register((Converter)new FloatConverter(), Float.class);
        EchoBaseConfiguration configuration = new EchoBaseConfiguration();
        TopiaContext internalRootContext = EchobaseTopiaContexts.newInternalDb((File)configuration.getInternalDbDirectory());
        this.setConfiguration(configuration);
        this.setDbMeta(EchoBaseDbMeta.newDbMeta());
        this.setInternalRootContext(internalRootContext);
    }

    public EchoBaseConfiguration getConfiguration() {
        return this.configuration;
    }

    public EchoBaseDbMeta getDbMeta() {
        return this.dbMeta;
    }

    public TopiaContext getInternalRootContext() {
        return this.internalRootContext;
    }

    public boolean isDefaultUsersCreated() {
        return this.defaultUsersCreated;
    }

    public SpatialDataCache getSpatialDataCache() {
        return this.spatialDataCache;
    }

    public EchoBaseServiceContext newServiceContext(Locale locale, TopiaContext topiaInternalContext, TopiaContext topiaContext) {
        EchoBaseServiceContext newServiceContext = DefaultEchoBaseServiceContext.newContext((Locale)locale, (EchoBaseConfiguration)this.configuration, (EchoBaseDbMeta)this.dbMeta, (SpatialDataCache)this.spatialDataCache);
        TopiaEchoBaseInternalPersistenceContext internalPersistenceContext = new TopiaEchoBaseInternalPersistenceContext(topiaInternalContext);
        newServiceContext.setEchoBaseInternalPersistenceContext(internalPersistenceContext);
        TopiaEchoBasePersistenceContext persistenceContext = new TopiaEchoBasePersistenceContext(topiaContext);
        newServiceContext.setEchoBasePersistenceContext(persistenceContext);
        return newServiceContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.spatialDataCache.clear();
            if (this.internalRootContext != null) {
                EchoBaseEntityHelper.releaseRootContext((TopiaContext)this.internalRootContext);
            }
        }
        finally {
            try {
                if (CollectionUtils.isNotEmpty((Collection)this.sessions)) {
                    for (EchoBaseSession session : this.sessions) {
                        this.destroyEchoBaseSession(session);
                    }
                }
            }
            finally {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                LogFactory.release((ClassLoader)contextClassLoader);
                Introspector.flushCaches();
            }
        }
    }

    public void setDbMeta(EchoBaseDbMeta dbMeta) {
        this.dbMeta = dbMeta;
    }

    public void setInternalRootContext(TopiaContext internalRootContext) {
        this.internalRootContext = internalRootContext;
    }

    public void setDefaultUsersCreated(boolean defaultUsersCreated) {
        this.defaultUsersCreated = defaultUsersCreated;
    }

    public void setConfiguration(EchoBaseConfiguration configuration) {
        this.configuration = configuration;
    }
}

