<%--
  #%L
  EchoBase :: UI
  
  $Id: exportQuery.jsp 677 2012-09-21 10:32:50Z tchemit $
  $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-1.3/echobase-ui/src/main/webapp/WEB-INF/jsp/exportQuery/exportQuery.jsp $
  %%
  Copyright (C) 2011 Ifremer, Codelutin
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<s:set var="noError" value="!hasErrors()"/>

<script type="text/javascript">

  function reloadPage(params) {
    var url = "<s:url action='manageExportQuery' namespace='/exportQuery'/>?";
    window.location = url + $.param(params);
    return false;
  }

  function newQuery(newParam) {
    if (<s:property value="%{queryExists or (!newQuery and !newLibreOfficeQuery)}"/>) {
      var params = {};
      params[newParam] = true;
      reloadPage(params);
    } else {
      $('[name="query.topiaId"]').val('');
      $('[name="query.name"]').val('');
      $('[name="query.description"]').val('');
      $('[name="query.sqlQuery"]').val('');
      if (newParam=='newLibreOfficeQuery') {
        openNewLibreOfficeDialog();
      }
    }
    return false;
  }

  function reloadQuery() {
    return reloadPage({'query.topiaId':'<s:property value="query.topiaId"/>'});
  }

  function openNewLibreOfficeDialog() {
    var dialog = $("#newLibreOfficeDialog");
    var url = "<s:url action='newLibreOfficeQuery' namespace='/exportQuery' method="input"/>";
    dialog.load(url);
    dialog.dialog('open');
  }

  function newLibreOfficeQuery() {
    if (<s:property value="%{queryExists or (!newQuery and !newLibreOfficeQuery)}"/>) {
      reloadPage({'newLibreOfficeQuery':true});
    } else {
      $('[name="query.topiaId"]').val('');
      $('[name="query.name"]').val('');
      $('[name="query.description"]').val('');
      $('[name="query.sqlQuery"]').val('');
      openNewLibreOfficeDialog();
    }
    return false;
  }

  function confirmDeleteQuery() {
    var url = "<s:url action='confirmDelete' namespace='/exportQuery'/>?" +
              $.param({ 'query.topiaId':'<s:property value="query.topiaId"/>'});
    var dialog = $("#confirmDeleteDialog");
    dialog.load(url);
    dialog.dialog('open');
    return false;
  }
</script>

<title><s:text name="echobase.title.export"/></title>

<s:form id="exportQueryForm" namespace="/exportQuery">

  <ul class="toolbar floatLeft">
    <li>
      <s:submit onclick="return newQuery('newQuery');" theme="simple"
                key="echobase.action.newQuery"/>
    </li>
    <li>
      <s:submit onclick="return newQuery('newLibreOfficeQuery');" theme="simple"
                key="echobase.action.newLibreOfficeQuery"/>
    </li>
  </ul>

  <fieldset>
    <legend><s:text name="echobase.label.sqlQueries"/></legend>
    <s:select key="query.topiaId" cssStyle="font-size: 140%"
              label="%{getText('echobase.label.sqlQueries')}"
              list="queries" headerKey="" headerValue="" theme="simple"/>
  </fieldset>

  <s:if test="%{!#noError or queryExists or newQuery or newLibreOfficeQuery}">
    <fieldset>
      <legend><s:text name="echobase.legend.sqlQuery.configuration"/></legend>

      <s:textarea key="query.name" required="true" cols="160" rows="1"
                  readonly="%{queryExists}"
                  label="%{getText('echobase.label.query.name')}"/>

      <s:textarea key="query.description" required="true" cols="160" rows="2"
                  readonly="%{queryExists and !canUpdateQuery}"
                  label="%{getText('echobase.label.query.description')}"/>

      <s:textarea key="query.sqlQuery" required="true" cols="160" rows="4"
                  readonly="%{queryExists and !canUpdateQuery}"
                  label="%{getText('echobase.label.query.sql')}"/>

      <s:if test="queryExists">
        <s:label value="%{query.lastModifiedDate}" readonly="true"
                 label="%{getText('echobase.common.lastModifiedDate')}"/>

        <s:label value="%{query.lastModifiedUser}" readonly="true"
                 label="%{getText('echobase.common.lastModifiedUser')}"/>
      </s:if>

      <ul id="dbeditorToolbar" class="toolbar floatRight">
        <s:if test="queryExists">
          <li>
            <s:submit onclick="return reloadQuery();" theme="simple"
                      key="echobase.action.reloadSqlQuery"/>
          </li>
          <li>
            <s:submit action="clone" theme="simple"
                      key="echobase.action.clone"/>
          </li>
          <s:if test="canUpdateQuery">
            <li>
              <s:submit onclick="return confirmDeleteQuery();" theme="simple"
                        key="echobase.action.delete"/>
            </li>
            <li>
              <s:submit action="save" theme="simple"
                        key="echobase.action.saveSqlQuery"/>
            </li>
          </s:if>
        </s:if>
        <s:if test="%{!queryExists}">
          <li>
            <s:submit action="save" theme="simple"
                      key="echobase.action.createSqlQuery"/>
          </li>
        </s:if>
      </ul>
    </fieldset>
  </s:if>
</s:form>

<br/>

<div id="resultGrid" class="cleanBoth"></div>

<sj:dialog id="newLibreOfficeDialog" resizable="false"
           title="%{getText('echobase.title.newLibreOfficeQuery')}"
           autoOpen="false" modal="true" width="780"/>

<sj:dialog id="confirmDeleteDialog" resizable="false"
           title="%{getText('echobase.title.confirm.deleteQuery')}"
           autoOpen="false" modal="true" width="780"/>

<script type="text/javascript">

  jQuery(document).ready(function () {

    $('[name="query.topiaId"]').change(function (event) {
      reloadPage({'query.topiaId':this.value});
    });

    if (<s:property value='%{#noError and queryExists}'/>) {

      // load sql query
      $.ajax(
        {
          url:'<s:url action="exportQueryResult" namespace="/exportQuery"/>',
          data:{sql:$('[name="query.sqlQuery"]').val()},
          success:function (data, textStatus, jqXHR) {
            $('#resultGrid').html(data);
          }
        });
    }

    if (<s:property value="newLibreOfficeQuery"/>) {

      // auto load new libreOffice dialog
      openNewLibreOfficeDialog();
    }
  });

</script>


