/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.echobase.ui.actions.removeData;

import com.google.common.base.Preconditions;
import fr.ifremer.echobase.entities.ImportLog;
import fr.ifremer.echobase.entities.ImportType;
import fr.ifremer.echobase.entities.data.Voyage;
import fr.ifremer.echobase.services.DecoratorService;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.removedata.RemoveDataConfiguration;
import fr.ifremer.echobase.ui.actions.AbstractConfigureAction;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConfirmDelete
extends AbstractConfigureAction<RemoveDataConfiguration> {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ConfirmDelete.class);
    protected ImportLog importLog;
    protected String voyage;
    protected String importType;

    public ConfirmDelete() {
        super(RemoveDataConfiguration.class);
    }

    public String getImportType() {
        return this.importType;
    }

    public ImportLog getImportLog() {
        return this.importLog;
    }

    public String getVoyage() {
        return this.voyage;
    }

    protected RemoveDataConfiguration createModel() {
        return new RemoveDataConfiguration();
    }

    protected void prepareExecuteAction(RemoveDataConfiguration model) throws IOException {
    }

    protected void prepareInputAction(RemoveDataConfiguration model) {
        String importLogId = model.getImportLogId();
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)importLogId));
        if (log.isInfoEnabled()) {
            log.info((Object)("Load import log " + importLogId));
        }
        EchoBaseServiceSupport service = (EchoBaseServiceSupport)this.getService(EchoBaseServiceSupport.class);
        this.importLog = (ImportLog)service.getEntityById(ImportLog.class, importLogId);
        this.importType = (String)this.decorateEnums((Enum[])new ImportType[]{this.importLog.getImportType()}).entrySet().iterator().next().getValue();
        Voyage voyageEntity = (Voyage)service.getEntityById(Voyage.class, this.importLog.getVoyageId());
        this.voyage = ((DecoratorService)this.getService(DecoratorService.class)).decorate(this.getLocale(), (Object)voyageEntity, null);
    }
}

