/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: AbstractLaunchImport.java 460 2012-03-30 16:46:14Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.5/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/AbstractLaunchImport.java $
 * %%
 * Copyright (C) 2011 - 2012 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import fr.ifremer.echobase.services.ImportException;
import fr.ifremer.echobase.services.importdata.AbstractImportConfiguration;
import fr.ifremer.echobase.services.importdata.AbstractImportDataService;
import fr.ifremer.echobase.ui.actions.AbstractWaitAndExecAction;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * TODO
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.3
 */
public class AbstractLaunchImport<M extends AbstractImportConfiguration, S extends AbstractImportDataService<M>> extends AbstractWaitAndExecAction<M> {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(AbstractLaunchImport.class);

    protected final Class<M> modelType;

    protected final Class<S> serviceType;

    protected transient S service;

    protected transient Exception error;

    protected String result;

    protected AbstractLaunchImport(Class<M> modelType, Class<S> serviceType) {
        this.modelType = modelType;
        this.serviceType = serviceType;
    }

    @Override
    protected M initModel() {
        return getEchoBaseSession().getImportDataConfiguration(modelType);
    }

    public String getResult() {
        return result;
    }

    public Exception getError() {
        return error;
    }

    public String getErrorStack() {

        String errorStack = null;
        if (error != null) {

            errorStack = ExceptionUtils.getStackTrace(error);
        }

        return errorStack;
    }

    @Override
    public void prepare() throws Exception {

        super.prepare();

        service = newService(serviceType);
    }

    @Override
    protected void startAction(M model) throws Exception {
        if (log.isInfoEnabled()) {
            log.info("Start imports for " + getModel());
        }

        try {
            result = service.doImport(model,
                                      getEchoBaseSession().getEchoBaseUser());

            addActionMessage(_("echobase.info.import.succeded"));

        } catch (ImportException e) {

            addActionError(_("echobase.info.import.failed"));

            if (log.isErrorEnabled()) {
                log.error("Error while import ", e);
            }

            error = e;
        }
    }

    @Override
    protected void closeAction(M model) throws Exception {

        // clean configuration
        model.destroy();

        // remove configuration from session
        getEchoBaseSession().removeImportDataConfiguration(modelType);
    }
}
