/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: ConfigureMission.java 136 2011-11-27 10:09:45Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.2/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/importData/ConfigureMission.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.importData;

import com.google.common.collect.Maps;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import fr.ifremer.echobase.entities.references.Mission;
import fr.ifremer.echobase.entities.references.MissionImpl;
import fr.ifremer.echobase.services.EchoBaseServiceSupport;
import fr.ifremer.echobase.services.ImportDataService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import java.util.List;
import java.util.Map;

/**
 * Configure the mission to use in the data import.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.2
 */
public class ConfigureMission extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(ConfigureMission.class);

    /** Universe of existing missions. */
    protected Map<String, String> missions;

    /** Universe of possible import modes. */
    protected Map<String, String> importModes;

    /** Selected import mode. */
    protected SelectedMissionMode importMode;

    /** mission to use. */
    protected Mission mission;

    public Mission getMission() {
        if (mission == null) {
            mission = new MissionImpl();
        }
        return mission;
    }

    public Map<String, String> getImportModes() {
        return importModes;
    }

    public Map<String, String> getMissions() {
        return missions;
    }

    public SelectedMissionMode getImportMode() {
        return importMode;
    }

    public void setImportMode(SelectedMissionMode importMode) {
        this.importMode = importMode;
    }

    @Override
    public String input() throws Exception {
        importModes = Maps.newLinkedHashMap();
        for (SelectedMissionMode mode : SelectedMissionMode.values()) {
            importModes.put(mode.name(), _(mode.getI18nKey()));
        }

        if (importMode == null) {
            importMode = SelectedMissionMode.USE_EXISTING_MISSION;
        }

        EchoBaseServiceSupport service =
                newService(EchoBaseServiceSupport.class);

        List<Mission> allMissions = service.getEntities(Mission.class);
        missions = sortAndDecorate(allMissions, null);

        if (log.isInfoEnabled()) {
            log.info("File errors : " + getFieldErrors());
        }
        return INPUT;
    }

    @InputConfig(methodName = "input")
    @Override
    public String execute() throws Exception {

        if (importMode == SelectedMissionMode.CREATE_NEW_MISSION) {

            // create voyage in db
            ImportDataService service = newService(ImportDataService.class);
            Mission missionToCreate = getMission();

            mission = service.createMission(missionToCreate);
        }
        return SUCCESS;
    }

}
