/*
 * #%L
 * EchoBase :: UI
 * 
 * $Id: CreateEmbeddedApplication.java 55 2011-11-13 22:22:54Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/echobase/tags/echobase-0.1/echobase-ui/src/main/java/fr/ifremer/echobase/ui/actions/export/CreateEmbeddedApplication.java $
 * %%
 * Copyright (C) 2011 Ifremer, Codelutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.ifremer.echobase.ui.actions.export;

import fr.ifremer.echobase.EchoBaseConfiguration;
import fr.ifremer.echobase.entities.Voyage;
import fr.ifremer.echobase.services.VoyageService;
import fr.ifremer.echobase.ui.actions.EchoBaseActionSupport;
import org.nuiton.util.Version;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * To create the embeddedApplication.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 0.1
 */
public class CreateEmbeddedApplication extends EchoBaseActionSupport {

    private static final long serialVersionUID = 1L;

    /** Universe of voyages to export in db. */
    protected Map<String, String> voyages;

    /** Default file name to create. */
    protected String fileName;

    /** File name of the war used. */
    protected String warFileName;

    public Map<String, String> getVoyages() {
        return voyages;
    }

    public Set<String> getVoyageIds() {
        return voyages.keySet();
    }

    public String getFileName() {
        return fileName;
    }

    public String getWarFileName() {
        return warFileName;
    }

    @Override
    public String execute() throws Exception {

        VoyageService service = newService(VoyageService.class);
        List<Voyage> allVoyages = service.getVoyages();
        voyages = sortAndDecorate(allVoyages, null);

        EchoBaseConfiguration configuration = getConfiguration();
        Version version = configuration.getApplicationVersion();
        fileName = "echobase-embedded-" + version.toString();
        File warLocation = configuration.getWarLocation();
        if (!warLocation.exists()) {
            addActionError(_("echobase.error.warlocation.notFound",
                             warLocation));
        }
        warFileName = warLocation.getName();
        return SUCCESS;
    }

}
