/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.admin;

import com.google.common.collect.Maps;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.ResultType;
import fr.ifremer.coser.result.repository.ResultRepositoryType;
import fr.ifremer.coser.result.request.GetAllResultsRequest;
import fr.ifremer.coser.web.CoserWebException;
import fr.ifremer.coser.web.actions.common.AbstractCoserAction;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ListProjectsAction
extends AbstractCoserAction {
    private static final long serialVersionUID = 1L;
    protected Map<String, ResultRepositoryType> repositoryTypes;
    protected String selectedRepositoryType;
    protected Map<String, String> facades;
    protected Map<String, List<String>> zonesByFacades;
    protected Map<ResultType, Map<String, String>> results;

    public Map<String, ResultRepositoryType> getRepositoryTypes() {
        return this.repositoryTypes;
    }

    public String getSelectedRepositoryType() {
        return this.selectedRepositoryType;
    }

    public void setSelectedRepositoryType(String selectedRepositoryType) {
        this.selectedRepositoryType = selectedRepositoryType;
    }

    public Map<String, String> getFacades() {
        return this.facades;
    }

    public Map<String, List<String>> getZonesByFacades() {
        return this.zonesByFacades;
    }

    public Map<String, String> getResults(ResultType resultType) {
        return (Map)this.results.get(resultType);
    }

    public String getZoneDisplayName(String zoneId) {
        return this.getService().getZoneFullName(zoneId);
    }

    public String execute() {
        this.repositoryTypes = this.getService().getRepositoryTypes();
        if (MapUtils.isEmpty((Map)this.repositoryTypes)) {
            throw new CoserWebException("No result repository type defined!");
        }
        if (StringUtils.isEmpty((CharSequence)this.selectedRepositoryType)) {
            ResultRepositoryType repositoryType = (ResultRepositoryType)this.repositoryTypes.values().iterator().next();
            this.selectedRepositoryType = repositoryType.getId();
        }
        this.facades = this.getService().getFacades();
        this.zonesByFacades = this.getService().getZoneByFacade();
        GetAllResultsRequest request = (GetAllResultsRequest)this.requestBuilder(GetAllResultsRequest.class).addRepositoryType(this.getSelectedRepositoryType()).toRequest();
        this.results = Maps.newEnumMap(ResultType.class);
        if (this.selectedRepositoryType != null) {
            ResultRepositoryType repositoryType = (ResultRepositoryType)this.repositoryTypes.get(this.selectedRepositoryType);
            Set resultTypes = repositoryType.getResultTypes();
            for (ResultType resultType : resultTypes) {
                request.setResultType(resultType);
                Map resultsForType = this.getService().toMap((CoserRequest)request);
                this.results.put(resultType, resultsForType);
            }
        }
        return "success";
    }
}

