/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web;

import fr.ifremer.coser.bean.ZoneMap;
import fr.ifremer.coser.web.CoserWebApplicationContext;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CoserApplicationListener
implements ServletContextListener {
    protected static final Log log = LogFactory.getLog(CoserApplicationListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application starting at " + new Date() + "..."));
        }
        CoserWebApplicationContext.init();
        CoserWebApplicationContext coserWebApplicationContext = CoserWebApplicationContext.get();
        this.checkConfiguration(coserWebApplicationContext);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Application is ending at " + new Date() + "..."));
        }
        CoserWebApplicationContext.close();
    }

    protected void checkConfiguration(CoserWebApplicationContext coserWebApplicationContext) {
        ZoneMap zoneMap = coserWebApplicationContext.getZoneMap();
        Map zonePictures = zoneMap.getZonePictures();
        for (Map.Entry entry : zonePictures.entrySet()) {
            if (!StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue())) || !log.isErrorEnabled()) continue;
            log.error((Object)String.format("Zone with no picture: %s", entry.getKey()));
        }
    }
}

