/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web.actions.map;

import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.request.GetSpeciesForMapResultRequest;
import fr.ifremer.coser.result.request.GetZonesForMapResultRequest;
import fr.ifremer.coser.web.actions.common.AbstractCoserJspAction;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpeciesAction
extends AbstractCoserJspAction {
    private static final long serialVersionUID = 1663244944108703571L;
    private static final Log log = LogFactory.getLog(SpeciesAction.class);
    protected String facade;
    protected String zone;
    protected Map<String, String> species;

    public String getFacade() {
        return this.facade;
    }

    public void setFacade(String facade) {
        this.facade = facade;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public Map<String, String> getSpecies() {
        return this.species;
    }

    public String getFacadeDisplayName() {
        return this.getService().getFacadeDisplayName(this.facade);
    }

    public String getZoneDisplayName() {
        GetZonesForMapResultRequest request = (GetZonesForMapResultRequest)this.requestBuilder(GetZonesForMapResultRequest.class).addFacade(this.facade).toRequest();
        return this.getService().getZoneDisplayName((CoserRequest)request, this.zone);
    }

    public String execute() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Looking for species for zone " + this.zone));
        }
        GetSpeciesForMapResultRequest request = (GetSpeciesForMapResultRequest)this.requestBuilder(GetSpeciesForMapResultRequest.class).addFacade(this.facade).addZone(this.zone).toRequest();
        this.species = this.getService().toMap((CoserRequest)request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Species are : " + this.species));
        }
        return "success";
    }
}

