/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.coser.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.opensymphony.xwork2.ActionSupport;
import fr.ifremer.coser.CoserApplicationContext;
import fr.ifremer.coser.bean.ZoneMap;
import fr.ifremer.coser.result.CoserRequest;
import fr.ifremer.coser.result.CoserRequestContext;
import fr.ifremer.coser.result.CoserRequestExecutor;
import fr.ifremer.coser.result.repository.ResultRepository;
import fr.ifremer.coser.result.repository.ResultRepositoryType;
import fr.ifremer.coser.result.request.DeleteResultsRequest;
import fr.ifremer.coser.result.request.ExtractRawDataAndResultsRequest;
import fr.ifremer.coser.result.result.FileResult;
import fr.ifremer.coser.result.result.MapResult;
import fr.ifremer.coser.services.WebResultService;
import fr.ifremer.coser.web.CoserWebApplicationContext;
import fr.ifremer.coser.web.CoserWebConfig;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ServiceHelper {
    protected final ActionSupport action;
    protected final CoserWebApplicationContext applicationContext;
    protected final WebResultService webResultService;

    public ServiceHelper(ActionSupport action) {
        Preconditions.checkNotNull((Object)action);
        this.applicationContext = CoserWebApplicationContext.get();
        this.action = action;
        this.webResultService = new WebResultService((CoserApplicationContext)this.applicationContext);
    }

    public Map<String, String> getFacades() {
        return this.applicationContext.getZoneMap().getFacades();
    }

    public String getFacadeDisplayName(String facade) {
        Map facades = this.getFacades();
        return (String)facades.get(facade);
    }

    public Map<String, List<String>> getZoneByFacade() {
        return this.applicationContext.getZoneMap().getZoneByFacade();
    }

    public Map<String, String> getZonesForFacade(String facade) {
        ZoneMap zoneMap = this.applicationContext.getZoneMap();
        List zoneIds = zoneMap.getZonesForFacade(facade);
        HashMap map = Maps.newHashMap();
        for (String zoneId : zoneIds) {
            String zoneName = zoneMap.getZoneFullNameWithNoFacade(zoneId);
            map.put(zoneId, zoneName);
        }
        return map;
    }

    public Map<String, String> getZonePictures() {
        return this.applicationContext.getZoneMap().getZonePictures();
    }

    public Map<String, String> getZoneMetaInfo(Locale locale) {
        return this.applicationContext.getZoneMap().getZoneMetaInfo(locale);
    }

    public String getZoneFullName(String zoneId) {
        return this.applicationContext.getZoneMap().getZoneFullName(zoneId);
    }

    public String getZoneDisplayName(CoserRequest request, String zone) {
        Map availableZones = this.toMap(request);
        String displayName = (String)availableZones.get(zone);
        return displayName;
    }

    public String getSpeciesDisplayName(CoserRequest request, String species) {
        Map availableSpecies = this.toMap(request);
        String displayName = (String)availableSpecies.get(species);
        return displayName;
    }

    public Set<String> getIndicatorIds() {
        return this.applicationContext.getIndicatorMap().getIds();
    }

    public String getIndicatorDisplayName(CoserRequest request, String indicator) {
        Map availableIndicators = this.toMap(request);
        String displayName = (String)availableIndicators.get(indicator);
        return displayName;
    }

    public FileResult extractRawDataAndResults(Locale locale, ExtractRawDataAndResultsRequest request) {
        CoserRequestContext context = this.newRequestContext(locale);
        FileResult result = this.webResultService.extractRawDataAndResults(context, request);
        return result;
    }

    public void deleteResults(DeleteResultsRequest request) {
        CoserRequestContext context = this.newRequestContext();
        this.webResultService.deleteResults(context, request);
    }

    public void registerNewUploadedResults(String login, File resultFile) {
        CoserRequestContext context = this.newRequestContext();
        this.webResultService.registerNewUploadedResults(context, login, resultFile);
    }

    public FileResult toFileResult(CoserRequest request) {
        CoserRequestContext context = this.newRequestContext();
        FileResult result = this.webResultService.executeUnique(context, request).toFileResult();
        return result;
    }

    public FileResult toFirstFileResult(CoserRequest request) {
        CoserRequestContext context = this.newRequestContext();
        FileResult result = this.webResultService.executeFirst(context, request).toFileResult();
        return result;
    }

    public MapResult toMapResult(CoserRequest request) {
        CoserRequestContext context = this.newRequestContext();
        MapResult result = this.webResultService.executeUnique(context, request).toMapResult();
        return result;
    }

    public Map<String, String> toMap(CoserRequest request) {
        CoserRequestContext context = this.newRequestContext();
        Map result = this.webResultService.executeAll(context, request).toMap();
        return result;
    }

    public CoserWebConfig getConfig() {
        return this.applicationContext.getConfig();
    }

    public void reloadProjects() {
        this.webResultService.resetRepositories();
    }

    public Map<String, ResultRepositoryType> getRepositoryTypes() {
        Map result = this.webResultService.getRepositoryTypes();
        return result;
    }

    public ResultRepositoryType getMatchingRepositoryType(CoserRequest request) {
        CoserRequestContext context = this.newRequestContext();
        CoserRequestExecutor coserRequestExecutor = this.webResultService.executeAll(context, request);
        ResultRepository matchingRepository = coserRequestExecutor.getFirstMatchingRepository();
        return matchingRepository.getResultRepositoryType();
    }

    protected CoserRequestContext newRequestContext() {
        return this.newRequestContext(this.action.getLocale());
    }

    protected CoserRequestContext newRequestContext(Locale locale) {
        return this.webResultService.newRequestContext(locale);
    }
}

