/*
 * #%L
 * $Id: CoserWebConfig.java 977 2012-02-10 13:26:59Z echatellier $
 * $HeadURL: http://svn.forge.codelutin.com/svn/coser/tags/coser-1.4.3/coser-web/src/main/java/fr/ifremer/coser/web/CoserWebConfig.java $
 * %%
 * Copyright (C) 2010 Ifremer, Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

package fr.ifremer.coser.web;

import static org.nuiton.i18n.I18n._;

import fr.ifremer.coser.CoserBusinessConfig;

/**
 * Coser web configuration.
 * 
 * @author chatellier
 * @version $Revision: 977 $
 * 
 * Last update : $Date: 2012-02-10 14:26:59 +0100 (Fri, 10 Feb 2012) $
 * By : $Author: echatellier $
 */
public class CoserWebConfig extends CoserBusinessConfig {

    public CoserWebConfig() {
        // init configuration with default options
        for (CoserWebOption o : CoserWebOption.values()) {
            if (o.defaultValue != null) {
                setDefaultOption(o.key, o.defaultValue);
            }
        }
    }

    public String getApplicationVersion() {
        String result = getOption(CoserWebOption.APPLICATION_VERSION.key);
        return result;
    }

    /**
     * Get administrator email.
     * 
     * @return admin email
     */
    public String getAdminEmail() {
        String result = getOption(CoserWebOption.ADMIN_EMAIL.key);
        return result;
    }

    /**
     * Get admin login.
     * 
     * @return admin login
     */
    public String getAdminLogin() {
        String result = getOption(CoserWebOption.ADMIN_LOGIN.key);
        return result;
    }

    /**
     * Get admin password.
     * 
     * @return admin password
     */
    public String getAdminPassword() {
        String result = getOption(CoserWebOption.ADMIN_PASSWORD.key);
        return result;
    }

    /**
     * Get analytics id.
     * 
     * @return analytics id
     */
    public String getAnalyticsId() {
        String result = getOption(CoserWebOption.ANALYTICS_ID.key);
        return result;
    }

    public enum CoserWebOption {

        /** Context name for multiple deployment. */
        CONTEXT_NAME(APP_NAME, null, "coser"),
        // see : http://www.nuiton.org/issues/1862
        ENCODING_HACK(CONTEXT_NAME.getDefaultValue() + "." + CONFIG_ENCODING, null, "UTF-8"),
        CONFIG_FILE(CONTEXT_NAME.defaultValue + "." + CONFIG_FILE_NAME, _("coser.config.config.file.description"), "coserweb.properties"),
        APPLICATION_VERSION("coser.application.version", _("coser.config.application.version.description"), null),
        ADMIN_EMAIL("coser.admin.email", _("coser.config.config.file.description"), "harmonie@ifremer.fr"),
        ADMIN_LOGIN("coser.admin.login", _("coser.config.admin.login.description"), null),
        ADMIN_PASSWORD("coser.admin.password", _("coser.config.admin.password.description"), null),
        ANALYTICS_ID("coser.analytics.id", _("coser.config.analytics.id.description"), "UA-27739588-1");

        protected String key;
        protected String description;
        protected String defaultValue;
    
        private CoserWebOption(String key, String description, String defaultValue) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
        }
    
        public String getDefaultValue() {
            return defaultValue;
        }
    
        public String getDescription() {
            return description;
        }
    
        public String getKey() {
            return key;
        }
    }
}
